package com.jhscale.meter.tool.barcode.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.protocol.model.BarCodeItemResult;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lie_w
 * @title: CashierResult
 * @projectName meter-jar
 * @description: 收银商品结果信息
 * @date 2022/8/53:01
 */
public class CashierResult extends JSONModel {

    // 商品结果
    // 0 - 不是条码商品
    // 1 - 条码商品
    private int type;

    // 识别的条码
    private String code;

    // 解析原始数据
    private BarCodeInfo barCodeInfo;

    // 解析信息
    private BarCodeItemResult barCodeItemResult;

    // 货号|PLU编号|常量
    private PLUNumberNoConstant pluNumberNoConstant;

    // 由 货号|PLU编号|常量 入参参数
    private PLUSpecsParam pluSpecsParam;

    // 数量
    private BigDecimal amount;

    // 重量
    private BigDecimal weight;

    // 单价
    private BigDecimal price;

    // 小计|总计
    private BigDecimal total;

    public CashierResult() {
    }

    public CashierResult(int type) {
        this.type = type;
    }

    public CashierResult(int type, String code, BarCodeInfo barCodeInfo) {
        this.type = type;
        this.code = code;
        this.barCodeInfo = barCodeInfo;
    }

    public CashierResult(int type, String code) {
        this.type = type;
        this.code = code;
    }

    public CashierResult(int type, String code,
                         BarCodeItemResult barCodeItemResult,
                         PLUNumberNoConstant pluNumberNoConstant) {
        this.type = type;
        this.code = code;
        this.barCodeItemResult = barCodeItemResult;
        this.pluNumberNoConstant = pluNumberNoConstant;
    }

    public CashierResult(int type, String code,
                         BarCodeItemResult barCodeItemResult,
                         PLUNumberNoConstant pluNumberNoConstant,
                         PLUSpecsParam pluSpecsParam) {
        this.type = type;
        this.code = code;
        this.barCodeItemResult = barCodeItemResult;
        this.pluNumberNoConstant = pluNumberNoConstant;
        this.pluSpecsParam = pluSpecsParam;
    }

    public CashierResult(int type,
                         BarCodeInfo barCodeInfo,
                         PLUNumberNoConstant pluNumberNoConstant,
                         PLUSpecsParam pluSpecsParam,
                         BigDecimal amount, BigDecimal weight, BigDecimal price, BigDecimal total) {
        this.type = type;
        this.barCodeInfo = barCodeInfo;
        this.pluNumberNoConstant = pluNumberNoConstant;
        this.pluSpecsParam = pluSpecsParam;
        this.amount = amount;
        this.weight = weight;
        this.price = price;
        this.total = total;
    }

    /**
     * @description: 获取数重量
     **/
    public BigDecimal weightOrAmount() {
        return Objects.nonNull(this.weight) ? this.weight : this.amount;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BarCodeInfo getBarCodeInfo() {
        return barCodeInfo;
    }

    public void setBarCodeInfo(BarCodeInfo barCodeInfo) {
        this.barCodeInfo = barCodeInfo;
    }

    public BarCodeItemResult getBarCodeItemResult() {
        return barCodeItemResult;
    }

    public void setBarCodeItemResult(BarCodeItemResult barCodeItemResult) {
        this.barCodeItemResult = barCodeItemResult;
    }

    public PLUNumberNoConstant getPluNumberNoConstant() {
        return pluNumberNoConstant;
    }

    public void setPluNumberNoConstant(PLUNumberNoConstant pluNumberNoConstant) {
        this.pluNumberNoConstant = pluNumberNoConstant;
    }

    public PLUSpecsParam getPluSpecsParam() {
        return pluSpecsParam;
    }

    public void setPluSpecsParam(PLUSpecsParam pluSpecsParam) {
        this.pluSpecsParam = pluSpecsParam;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTotal() {
        return total;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }
}
