package com.jhscale.meter.tool.barcode.entity;

import com.jhscale.common.model.simple.JSONModel;

/**
 * @author lie_w
 * @title: CommodityResult
 * @projectName meter-jar
 * @description: 商品结果
 * @date 2022/8/52:48
 */
public class CommodityResult extends JSONModel {

    // 商品结果
    // 0 - 不是条码商品
    // 1 - 条码商品
    private int type;

    // 识别的条码
    private String code;

    // 解析后初步商品信息 EAN13|18 需要完善 数重量|单价 信息
    private BarCodeInfo barCodeInfo;

    public CommodityResult() {
    }

    public CommodityResult(int type, String code, BarCodeInfo barCodeInfo) {
        this.type = type;
        this.code = code;
        this.barCodeInfo = barCodeInfo;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BarCodeInfo getBarCodeInfo() {
        return barCodeInfo;
    }

    public void setBarCodeInfo(BarCodeInfo barCodeInfo) {
        this.barCodeInfo = barCodeInfo;
    }
}
