package com.jhscale.meter.tool.barcode.entity;

import com.jhscale.common.model.simple.JSONModel;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: PLUSpecsResult
 * @projectName meter-jar
 * @description: 商品 规格 信息 对象可以被继承，接口会直接 返回 此对象
 * @date 2022/8/53:04
 */
public class PLUSpecsParam extends JSONModel {

    // PLU编号
    private int no;

    // PLU货号
    private int number;

    // 单位类型 1-计重 2-计件 与 weightType 字段对应
    private int unit;

    // 商品单价 售价
    private BigDecimal price;

    public PLUSpecsParam() {
    }

    public PLUSpecsParam(int no, int number, int unit, BigDecimal price) {
        this.no = no;
        this.number = number;
        this.unit = unit;
        this.price = price;
    }

    public int getNo() {
        return no;
    }

    public void setNo(int no) {
        this.no = no;
    }

    public int getNumber() {
        return number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getUnit() {
        return unit;
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
}
