package com.jhscale.meter.tool.barcode.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.utils.BigDecimalUtils;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: Rule
 * @projectName meter-jar
 * @description: 规则
 * @date 2022/8/50:49
 */
public class Rule extends JSONModel {

    private int ean;
    private int no;

    // 第一部分 标志
    private String part1;
    // 第二部分 格式：序号 1-货号 2-PLU编号 3-常数
    private int part2;
    // 常量 part2 == 3 填写
    private String constant;
    // 第三部分 1-重量/数量 2-总计
    private int part3;
    // 第四部分 1-重量/数量 2-总计
    private int part4;
    // 校验位
    private int verify;

    // 金额小数点 12.34 money=2  ==> 1234
    private int money;
    private BigDecimal bd_money;
    // 重量小数点 0.255 weight=3 ==>255
    private int weight;
    private BigDecimal bd_weight;
    // 数量小数点 3 amount=3     ==>3000
    private int amount;
    private BigDecimal bd_amount;
    // 除法 BigDecimal 取舍方式
    private int round;

    public Rule() {
    }

    // EAN 规则 包括取舍方式
    public static Rule EAN13(int no, String part1, int part2, String constant, int part3, int money, int weight, int amount, int round) {
        return new Rule(no, part1, part2, constant, part3, money, weight, amount, round);
    }

    // EAN 规则 包括 默认 BigDecimal.ROUND_CEILING 取舍方式
    public static Rule EAN13(int no, String part1, int part2, String constant, int part3, int money, int weight, int amount) {
        return new Rule(no, part1, part2, constant, part3, money, weight, amount, BigDecimal.ROUND_CEILING);
    }

    public static Rule EAN13(String part1, int part2, String constant, int part3, int money, int weight, int amount) {
        return new Rule(1, part1, part2, constant, part3, money, weight, amount, BigDecimal.ROUND_CEILING);
    }

    // EAN 规则 包括取舍方式
    public static Rule EAN18(int no, String part1, int part2, String constant, int part3, int part4, int money, int weight, int amount, int round) {
        return new Rule(no, part1, part2, constant, part3, part4, money, weight, amount, round);
    }

    // EAN 规则 包括 默认 BigDecimal.ROUND_CEILING 取舍方式
    public static Rule EAN18(int no, String part1, int part2, String constant, int part3, int part4, int money, int weight, int amount) {
        return new Rule(no, part1, part2, constant, part3, part4, money, weight, amount, BigDecimal.ROUND_CEILING);
    }

    public static Rule EAN18(String part1, int part2, String constant, int part3, int part4, int money, int weight, int amount) {
        return new Rule(1, part1, part2, constant, part3, part4, money, weight, amount, BigDecimal.ROUND_CEILING);
    }

    // EAN13
    public Rule(int no, String part1, int part2, String constant, int part3, int money, int weight, int amount, int round) {
        this(13, no, part1, part2, constant, part3, 0, money, weight, amount, round);
    }

    // EAN18
    public Rule(int no, String part1, int part2, String constant, int part3, int part4, int money, int weight, int amount, int round) {
        this(18, no, part1, part2, constant, part3, part4, money, weight, amount, round);
    }

    public Rule(int ean, int no, String part1, int part2, String constant, int part3, int part4, int money, int weight, int amount, int round) {
        this.ean = ean;
        this.no = no;
        this.part1 = part1;
        this.part2 = part2;
        this.constant = constant;
        this.part3 = part3;
        this.part4 = part4;
        this.money = money;
        this.bd_money = BigDecimalUtils.cardinality(money);
        this.weight = weight;
        this.bd_weight = BigDecimalUtils.cardinality(weight);
        this.amount = amount;
        this.bd_amount = BigDecimalUtils.cardinality(amount);
        this.round = round;
    }

    /**
     * @description: 获取序号
     **/
    public Integer serialNo() {
        return Integer.parseInt(String.valueOf(this.ean) + String.valueOf(this.no));
    }

    public int getEan() {
        return ean;
    }

    public void setEan(int ean) {
        this.ean = ean;
    }

    public int getNo() {
        return no;
    }

    public void setNo(int no) {
        this.no = no;
    }

    public String getPart1() {
        return part1;
    }

    public void setPart1(String part1) {
        this.part1 = part1;
    }

    public int getPart2() {
        return part2;
    }

    public void setPart2(int part2) {
        this.part2 = part2;
    }

    public String getConstant() {
        return constant;
    }

    public void setConstant(String constant) {
        this.constant = constant;
    }

    public int getPart3() {
        return part3;
    }

    public void setPart3(int part3) {
        this.part3 = part3;
    }

    public int getPart4() {
        return part4;
    }

    public void setPart4(int part4) {
        this.part4 = part4;
    }

    public int getMoney() {
        return money;
    }

    public void setMoney(int money) {
        this.money = money;
        this.bd_money = BigDecimalUtils.cardinality(money);
    }

    public BigDecimal getBd_money() {
        return bd_money;
    }

    public void setBd_money(BigDecimal bd_money) {
        this.bd_money = bd_money;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
        this.bd_weight = BigDecimalUtils.cardinality(weight);
    }

    public BigDecimal getBd_weight() {
        return bd_weight;
    }

    public void setBd_weight(BigDecimal bd_weight) {
        this.bd_weight = bd_weight;
    }

    public int getAmount() {
        return amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.bd_amount = BigDecimalUtils.cardinality(amount);
    }

    public BigDecimal getBd_amount() {
        return bd_amount;
    }

    public void setBd_amount(BigDecimal bd_amount) {
        this.bd_amount = bd_amount;
    }

    public int getRound() {
        return round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public int getVerify() {
        return verify;
    }

    public void setVerify(int verify) {
        this.verify = verify;
    }

    /**
     * @description: 转换金额
     **/
    public BigDecimal convertMoney(String money) {
        return new BigDecimal(money).divide(this.bd_money).setScale(this.money, this.round);
    }

    /**
     * @description: 转换金额
     **/
    public String convertMoney(BigDecimal money) {
        return String.valueOf(money.multiply(this.bd_money).intValue());
    }

    /**
     * @description: 转换重量
     **/
    public BigDecimal convertWeight(String weight) {
        return new BigDecimal(weight).divide(this.bd_weight).setScale(this.weight, this.round);
    }

    /**
     * @description: 转换重量
     **/
    public String convertWeight(BigDecimal weight) {
        return String.valueOf(weight.multiply(this.bd_weight).intValue());
    }

    /**
     * @description: 转换数量
     **/
    public BigDecimal convertAmount(String amount) {
        return new BigDecimal(amount).multiply(this.bd_amount).setScale(this.amount, this.round);
    }

    /**
     * @description: 转换数量
     **/
    public String convertAmount(BigDecimal amount) {
        return String.valueOf(amount.divide(this.bd_amount).intValue());
    }
}
