package com.jhscale.meter.tool.barcode.loader;

/**
 * @author lie_w
 * @title: CloudPayLoader
 * @projectName meter-jar
 * @description: 吉卡云支付码
 * @date 2022/8/49:54
 */
public class JKYPayCodeLoader implements BarCodeLoader {

    // 前缀
    private String prefix;

    // 长度
    private int length;

    public JKYPayCodeLoader() {
    }

    public JKYPayCodeLoader(String prefix, int length) {
        this.prefix = prefix;
        this.length = length;
    }

    /**
     * @description: 吉卡云正则
     **/
    public String regular() {
        return "^" + prefix + "\\d{" + (length - prefix.length()) + "}$";
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getLength() {
        return length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}
