package com.jhscale.meter.tool.barcode.loader.rule;

import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.tool.barcode.entity.BarCodeInfo;
import com.jhscale.meter.tool.barcode.entity.PLUSpecsItem;
import com.jhscale.meter.tool.barcode.entity.Rule;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: ParseCode
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/8/50:48
 */
public abstract class CashierCode extends JSONModel {

    // 规则参数
    private Rule rule;

    /**
     * @description: 方法序号
     **/
    public abstract int sn();

    /**
     * @description: 检查Length
     **/
    public abstract boolean checkLength(String code);

    /**
     * @description: 检查第一部分
     **/
    public abstract boolean checkPart1(String code);

    /**
     * @description: 填充解析数值
     **/
    public abstract void parse(String code, BarCodeInfo barCodeInfo);

    /**
     * @description: 完善完整信息
     **/
    public abstract void complete(BarCodeInfo barCodeInfo, int unit, BigDecimal price);

    /**
     * @description: 填充第二部分
     **/
    protected abstract String paddingPart2(String part2) throws MeterException;

    /**
     * @description: 填充第三部分
     **/
    protected abstract String paddingPart3(String part3) throws MeterException;

    /**
     * @description: 第二部分添加
     **/
    public String addPart2(PLUSpecsItem item) throws MeterException {
        String part2 = null;
        switch (this.getRule().getPart2()) {
            case 1:
                part2 = String.valueOf(item.getNumber());
                break;
            case 2:
                part2 = String.valueOf(item.getNo());
                break;
            case 3:
                part2 = StringUtils.isBlank(this.getRule().getConstant()) ? "" : this.getRule().getConstant();
                break;
        }
        return this.paddingPart2(part2);
    }

    /**
     * @description: 添加第三部分
     **/
    public String addPart3(PLUSpecsItem item) throws MeterException {
        String part3 = null;
        switch (this.getRule().getPart3()) {
            case 1:
                part3 = UnitType.计件.equals(UnitType.getUnitType(item.getUnit()))
                        ?
                        this.getRule().convertAmount(item.getVal())
                        :
                        this.getRule().convertWeight(item.getVal());
                break;
            case 2:
                part3 = this.getRule().convertMoney(item.getItem());
                break;
        }
        return this.paddingPart3(part3);
    }

    /**
     * @description: 添加第四部分
     **/
    public String addPart4(PLUSpecsItem item) throws MeterException {
        return "";
    }

    /**
     * @description: 添加校验位
     **/
    public String addVerify() {
        return String.valueOf(this.getRule().getVerify());
    }

    /**
     * @description: 第二部分解析
     **/
    protected void parsePart2(BarCodeInfo barCodeInfo, String part2) {
        switch (this.getRule().getPart2()) {
            case 1:
                barCodeInfo.setNumber(Integer.parseInt(part2));
                break;
            case 2:
                barCodeInfo.setPluNo(Integer.parseInt(part2));
                break;
            case 3:
                barCodeInfo.setConstant(part2);
                break;
        }
    }

    /**
     * @description: 第 三 部分解析
     **/
    void parsePart3(BarCodeInfo barCodeInfo, String part) {
        switch (this.getRule().getPart3()) {
            case 1:
                barCodeInfo.setVal(part);
                break;
            case 2:
                barCodeInfo.setTotal(this.getRule().convertMoney(part));
                break;
        }
    }

    /**
     * @description: 第 四 部分解析
     **/
    void parsePart4(BarCodeInfo barCodeInfo, String part) {
        switch (this.getRule().getPart4()) {
            case 1:
                barCodeInfo.setVal(part);
                break;
            case 2:
                barCodeInfo.setTotal(this.getRule().convertMoney(part));
                break;
        }
    }

    /**
     * @description: 填充内容
     **/
    protected String padding(String part, int length) throws MeterException {
        part = part == null ? "" : part;
        int partLength = part.length();
        if (partLength > length)
            throw new MeterException(MeterStateEnum.集中收银内容段长度不合法);
        for (int i = 0; i < length - partLength; i++) {
            part = "0" + part;
        }
        return part;
    }

    public Rule getRule() {
        return rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }
}
