package com.jhscale.meter.tool.barcode.loader.rule;

import com.jhscale.meter.tool.barcode.entity.BarCodeInfo;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: CashierCode_13
 * @projectName meter-jar
 * @description: EAN13
 * @date 2022/8/50:52
 */
public abstract class CashierCode_13 extends CashierCode {
    /**
     * @param code
     * @description: 检查Length
     */
    @Override
    public boolean checkLength(String code) {
        return code.length() == 13;
    }

    /**
     * @param barCodeInfo
     * @param unit
     * @param price
     * @description: 完善完整信息
     */
    @Override
    public void complete(BarCodeInfo barCodeInfo, int unit, BigDecimal price) {
        barCodeInfo.labelUnitAndPrice(this.getRule(), unit, price);
    }
}
