package com.jhscale.meter.tool.barcode.loader.rule;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.tool.barcode.entity.BarCodeInfo;

/**
 * @author lie_w
 * @title: CashierCode_13_2
 * @projectName meter-jar
 * @description: EAN13 2+6+4+1
 * @date 2022/8/50:52
 */
public class CashierCode_13_2 extends CashierCode_13 {

    /**
     * @description: 方法序号
     **/
    @Override
    public int sn() {
        return 132;
    }

    /**
     * @param code
     * @description: 检查第一部分
     */
    @Override
    public boolean checkPart1(String code) {
        return code.substring(0, 2).equalsIgnoreCase(this.getRule().getPart1());
    }

    /**
     * @param code
     * @param barCodeInfo
     * @description: 填充解析数值
     */
    @Override
    public void parse(String code, BarCodeInfo barCodeInfo) {
        this.parsePart2(barCodeInfo, code.substring(2, 8));
        this.parsePart3(barCodeInfo, code.substring(8, 12));
    }

    /**
     * @param part2
     * @description: 填充第二部分
     */
    @Override
    protected String paddingPart2(String part2) throws MeterException {
        return this.padding(part2, 6);
    }

    /**
     * @param part3
     * @description: 填充第三部分
     */
    @Override
    protected String paddingPart3(String part3) throws MeterException {
        return this.padding(part3, 4);
    }

}
