package com.jhscale.meter.tool.barcode.loader.rule;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.tool.barcode.entity.BarCodeInfo;

/**
 * @author lie_w
 * @title: CashierCode_13_4
 * @projectName meter-jar
 * @description: EAN13 1+6+5+1
 * @date 2022/8/50:52
 */
public class CashierCode_13_4 extends CashierCode_13 {

    /**
     * @description: 方法序号
     **/
    @Override
    public int sn() {
        return 134;
    }

    /**
     * @param code
     * @description: 检查第一部分
     */
    @Override
    public boolean checkPart1(String code) {
        return code.substring(0, 1).equalsIgnoreCase(this.getRule().getPart1());
    }

    /**
     * @param code
     * @param barCodeInfo
     * @description: 填充解析数值
     */
    @Override
    public void parse(String code, BarCodeInfo barCodeInfo) {
        this.parsePart2(barCodeInfo, code.substring(1, 7));
        this.parsePart3(barCodeInfo, code.substring(7, 12));
    }

    /**
     * @param part2
     * @description: 填充第二部分
     */
    @Override
    protected String paddingPart2(String part2) throws MeterException {
        return this.padding(part2, 6);
    }

    /**
     * @param part3
     * @description: 填充第三部分
     */
    @Override
    protected String paddingPart3(String part3) throws MeterException {
        return this.padding(part3, 5);
    }

}
