package com.jhscale.meter.tool.barcode.loader.rule;

import com.jhscale.common.model.device.UnitType;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.tool.barcode.entity.BarCodeInfo;
import com.jhscale.meter.tool.barcode.entity.PLUSpecsItem;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: CashierCode_18
 * @projectName meter-jar
 * @description: EAN18
 * @date 2022/8/50:52
 */
public abstract class CashierCode_18 extends CashierCode {
    /**
     * @param code
     * @description: 检查Length
     */
    @Override
    public boolean checkLength(String code) {
        return code.length() == 18;
    }

    /**
     * @param barCodeInfo
     * @param unit
     * @param price
     * @description: 完善完整信息
     */
    @Override
    public void complete(BarCodeInfo barCodeInfo, int unit, BigDecimal price) {
        barCodeInfo.labelUnit(this.getRule(), unit);
    }

    /**
     * @description: 填充第4部分
     **/
    protected abstract String paddingPart4(String part4) throws MeterException;

    /**
     * @description: 添加第四部分
     **/
    @Override
    public String addPart4(PLUSpecsItem item) throws MeterException {
        String part4 = null;
        switch (this.getRule().getPart4()) {
            case 1:
                part4 = UnitType.计件.equals(UnitType.getUnitType(item.getUnit()))
                        ?
                        this.getRule().convertAmount(item.getVal())
                        :
                        this.getRule().convertWeight(item.getVal());
                break;
            case 2:
                part4 = this.getRule().convertMoney(item.getItem());
                break;
        }
        return this.paddingPart4(part4);
    }
}
