package com.jhscale.meter.utils;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

/**
 * @author lie_w
 * @title: AesHexUtils
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/11/159:19
 */
public class AesHexUtils {

    private AesHexUtils() {
    }

    private static final String AES = "AES";

    private static final String AES_ECB_PADDING = "AES/ECB/NoPadding";


    /**
     * @description: AES加密
     **/
    public static byte[] encrypt(byte[] content, String key) throws MeterException {
        try {
            SecretKeySpec spec = new SecretKeySpec(ByteUtils.fromHexString(key), AES);
            Cipher cipher = Cipher.getInstance(AES_ECB_PADDING);
            cipher.init(Cipher.ENCRYPT_MODE, spec);
            return cipher.doFinal(content);
        } catch (Exception e) {
            e.printStackTrace();
            throw new MeterException(MeterStateEnum.AES加密失败);
        }
    }

    /**
     * @description: AES加密
     **/
    public static byte[] encrypt_byte(String content, String key) throws MeterException {
        return encrypt(ByteUtils.fromHexString(content), key);
    }

    /**
     * @description: AES加密
     **/
    public static String encrypt(String content, String key) throws MeterException {
        return ByteUtils.toHexString(encrypt(ByteUtils.fromHexString(content), key));
    }


    /**
     * @description: AES解密
     **/
    public static byte[] decrypt(byte[] content, String key) throws MeterException {
        try {
            SecretKeySpec spec = new SecretKeySpec(ByteUtils.fromHexString(key), AES);
            Cipher cipher = Cipher.getInstance(AES_ECB_PADDING);
            cipher.init(Cipher.DECRYPT_MODE, spec);
            return cipher.doFinal(content);
        } catch (Exception e) {
            e.printStackTrace();
            throw new MeterException(MeterStateEnum.AES解密失败);
        }
    }

    /**
     * @description: AES解密
     **/
    public static String decrypt(String content, String key) throws MeterException {
        return ByteUtils.toHexString(decrypt(ByteUtils.fromHexString(content), key));
    }

    /**
     * @description: AES解密
     **/
    public static String decrypt_byte(byte[] content, String key) throws MeterException {
        return ByteUtils.toHexString(decrypt(content, key));
    }
}
