package com.jhscale.meter.utils;

import com.jhscale.common.utils.BigDecimalUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * @author Loveven
 * @title: ByteUtils
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2019/9/216:36
 */
public class ByteUtils {

    private final static short UNSIGNED_MAX_VALUE = (Byte.MAX_VALUE * 2) + 1;

    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /**
     * @description: HEX 转 ASCII
     **/
    public static String hex2Ascii(String hexStr) {
        StringBuilder output = new StringBuilder("");
        for (int i = 0; i < hexStr.length(); i += 2) {
            String str = hexStr.substring(i, i + 2);
            output.append((char) Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    /**
     * @description: ASCII 转 HEX
     **/
    public static String ascii2Hex(String asciiStr) {
        char[] chars = asciiStr.toCharArray();
        StringBuilder hex = new StringBuilder();
        for (char ch : chars) {
            hex.append(Integer.toHexString((int) ch));
        }
        return hex.toString().toUpperCase();
    }

    /**
     * 解析
     *
     * @param mark
     * @return
     */
    public static String formatMark(String mark) {
        String binaryStr = Integer.toBinaryString(Integer.parseInt(mark, 16));
        int lg = binaryStr.length();
        if (lg < 8) {
            int cn = 8 - lg;
            String str = "";
            for (int i = 0; i < cn; i++) {
                str += "0";
            }
            return str + binaryStr;
        }
        return binaryStr;
    }

    /**
     * @description: 10进制转2进制 前置补充长度
     **/
    public static String ten2two(int val, int length) {
        String binaryStr = Integer.toBinaryString(val);
        int lg = binaryStr.length();
        if (lg < length) {
            int cn = length - lg;
            String str = "";
            for (int i = 0; i < cn; i++) {
                str += "0";
            }
            return str + binaryStr;
        }
        return binaryStr;
    }

    /**
     * @description: 指定下坐标添加字符
     **/
    public static String inserE(String targe, int index, String str) {
        String res = "";
        for (int i = targe.length(); i > 0; i--) {
            if ((targe.length() - i) == index)
                res = str + res;
            res = targe.charAt(i - 1) + res;
        }
        return res;
    }

    /**
     * HEX 二进制反转
     *
     * @param mark
     * @return
     */
    public static String formatData(String mark) {
        String binaryStr = Integer.toBinaryString(Integer.parseInt(mark, 16));
        int lg = binaryStr.length();
        if (lg < 8) {
            int cn = 8 - lg;
            String str = "";
            for (int i = 0; i < cn; i++) {
                str += "0";
            }
            binaryStr = str + binaryStr;
        }
        return new StringBuffer(binaryStr).reverse().toString();
    }

    /**
     * HEX TO ASCII 字节数组
     *
     * @param s
     * @return
     * @throws NumberFormatException
     */
    public static byte[] fromHexAscii(String s) throws NumberFormatException {
        try {
            int len = s.length();
            if ((len % 2) != 0)
                throw new NumberFormatException("Hex ascii must be exactly two digits per byte.");

            int out_len = len / 2;
            byte[] out = new byte[out_len];
            int i = 0;
            StringReader sr = new StringReader(s);
            while (i < out_len) {
                int val = (16 * fromHexDigit(sr.read())) + fromHexDigit(sr.read());
                out[i++] = (byte) val;
            }
            return out;
        } catch (IOException e) {
            throw new InternalError("IOException reading from StringReader?!?!");
        }
    }

    public static String toBinary(int length) {
        String str = Integer.toBinaryString(length);
        if (str.length() < 2) {
            if (length == 0) {
                str = "01";
            } else {
                str = "0" + str;
            }
        }
        return str;
    }

    private static int fromHexDigit(int c) throws NumberFormatException {
        if (c >= 0x30 && c < 0x3A)
            return c - 0x30;
        else if (c >= 0x41 && c < 0x47)
            return c - 0x37;
        else if (c >= 0x61 && c < 0x67)
            return c - 0x57;
        else
            throw new NumberFormatException('\'' + c + "' is not a valid hexadecimal digit.");
    }

    public static String covert102Hex(String data) {
        Integer dInt = Integer.parseInt(data);
        String hexString = dInt.toHexString(dInt);
        if (hexString.length() % 2 != 0) {
            hexString = "0" + hexString;
        }
        return convert(hexString);
    }

    public static String convert(String hex) {
        return toHexAscii(reverse(fromHexAscii(hex)));
    }

    /**
     * @description: hex to ten
     **/
    public static int hex2Ten(String hex) {
        return Integer.parseInt(ByteUtils.convert(hex), 16);
    }

    /**
     * @description: hex to binary
     **/
    public static String hex2Bin(String hex, int bit_len) {
        String binaryStr = Integer.toBinaryString(hex2Ten(hex));
        int lg = binaryStr.length();
        bit_len = bit_len * 8;
        if (lg < bit_len) {
            int cn = bit_len - lg;
            String str = "";
            for (int i = 0; i < cn; i++) {
                str += "0";
            }
            return str + binaryStr;
        }
        return binaryStr;
    }

    /**
     * @description: ten to hex
     **/
    public static String ten2Hex(int i) {
        return ByteUtils.convert(ByteUtils.appendFill(Integer.toHexString(i), 8));
    }

    /**
     * @description: ten to hex
     **/
    public static String ten2Hex(int i, int length) {
        return ByteUtils.convert(ByteUtils.appendFill(Integer.toHexString(i).toUpperCase(), length));
    }

    public static String toHexAscii(byte[] bytes) {
        int len = bytes.length;
        StringWriter sw = new StringWriter(len * 2);
        for (int i = 0; i < len; ++i)
            addHexAscii(bytes[i], sw);
        return sw.toString();
    }

    public static String toHexAscii(byte b) {
        StringWriter sw = new StringWriter(2);
        addHexAscii(b, sw);
        return sw.toString();
    }

    private static void addHexAscii(byte b, StringWriter sw) {
        short ub = toUnsigned(b);
        int h1 = ub / 16;
        int h2 = ub % 16;
        sw.write(toHexDigit(h1));
        sw.write(toHexDigit(h2));
    }

    private static short toUnsigned(byte b) {
        return (short) (b < 0 ? (UNSIGNED_MAX_VALUE + 1) + b : b);
    }

    private static char toHexDigit(int h) {
        char out;
        if (h <= 9) out = (char) (h + 0x30);
        else out = (char) (h + 0x37);
        return out;
    }

    public static byte[] reverse(byte[] bytes) {
        int len = bytes.length;
        byte[] newBytes = new byte[len];
        for (int i = 0; i < len; i++) {
            newBytes[i] = bytes[len - 1 - i];
        }
        return newBytes;
    }

    public static int[] reverse(int[] ints) {
        int len = ints.length;
        int[] newInts = new int[len];
        for (int i = 0; i < len; i++) {
            newInts[i] = ints[len - 1 - i];
        }
        return newInts;
    }

    /**
     * @description: 数值转HEX 并补充长度到 length
     **/
    public static String int2HexWithPush(int val, int length) {
        String hex = Integer.toHexString(val);
        int hexLength = hex.length();
        if (hexLength < length) {
            for (int i = 0; i < length - hexLength; i++) {
                hex = "0" + hex;
            }
        } else {
            hex = hex.substring(0, length);
        }
        hex = ByteUtils.convert(hex);
        return hex;
    }

    /**
     * @description: 数值转HEX 并补充长度到 length
     **/
    public static String int2Hex(int val) {
        String hex = Integer.toHexString(val);
        if (hex.length() % 2 != 0) hex = "0" + hex;
        hex = ByteUtils.convert(hex);
        return hex;
    }

    /**
     * @description: 浮动值获取
     **/
    public static String dataFormat(String data) {
        String hexString = Integer.toHexString(Integer.parseInt(data, 2));
        if (hexString.length() % 2 != 0) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    /**
     * @param strPart 字符串
     * @return 16进制字符串
     * @throws
     * @Title:string2HexUTF8
     * @Description:字符UTF8串转16进制字符串
     */
    public static String string2HexUTF8(String strPart) {
        return string2HexString(strPart, "UTF-8");
    }

    /**
     * @param strPart    字符串
     * @param tochartype hex目标编码
     * @return 16进制字符串
     * @throws
     * @Title:string2HexString
     * @Description:字符串转16进制字符串
     */
    public static String string2HexString(String strPart, String tochartype) {
        try {
            return bytes2HexString(strPart.getBytes(tochartype));
        } catch (Exception e) {
            return "";
        }
    }

    /**
     * @param b 字节数组
     * @return 16进制字符串
     * @throws
     * @Title:bytes2HexString
     * @Description:字节数组转16进制字符串
     */
    public static String bytes2HexString(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < b.length; i++) {
            result.append(String.format("%02X", b[i]));
        }
        return result.toString();
    }

    public static String toHexString(byte[] var0) {
        String var1 = "";

        for (int var2 = 0; var2 < var0.length; ++var2) {
            var1 = var1 + HEX_CHARS[var0[var2] >>> 4 & 15];
            var1 = var1 + HEX_CHARS[var0[var2] & 15];
        }
        return var1.toUpperCase();
    }

    /**
     * @description: 两字节截取获取指定字符串下坐标
     **/
    public static int indexOf(String content, String str) {
        int index = -1;
        char[] chars = content.toCharArray();
        for (int i = 0; i < content.length() / 2; i++) {
            String st = String.valueOf(chars[i * 2]) + String.valueOf(chars[i * 2 + 1]);
            if (st.equals(str)) {
                index = i * 2;
                break;
            }
        }
        return index;
    }

    /**
     * @description: 时间转换
     **/
    public static Date convertTime(String hexString) {
        long time = Long.parseLong(convert(hexString), 16);
        return new Date((time + 946656000) * 1000);
    }

    /**
     * @description: 时间
     **/
    public static String convertTime(Date date) {
        long time = (date.getTime() - 946656000) / 1000;
        return convert(appendFill(Long.toHexString(time), 8));
    }

    /**
     * HEX 2 BigDeciamal
     *
     * @param hexString
     * @return
     */
    public static BigDecimal convertBigDecimal(String hexString) {
        String convert = convert(hexString);
        int money = Integer.parseUnsignedInt(convert, 16);
        // System.out.printf("money:[%s],unscaledVal:[%s],scale:[%s]%n", money, money >> 3, money & 0x07);
        return BigDecimal.valueOf(money >> 3, money & 0x07);
    }

    /**
     * @description: 浮动小数
     **/
    public static int toSPF(BigDecimal d) {
        long A;
        int B;
        A = d.multiply(new BigDecimal(10000000)).add(BigDecimal.valueOf(BigDecimalUtils.compareLessZeroValue(d) ? -0.5 : 0.5)).longValue();
        B = 7;
        while (true) {
            if (B == 0) {
                if (A >= 268435456)
                    A = 268435455;
                else if (A < -268435456)
                    A = -268435456;
                break;
            }
            if ((A >= 268435456) || (A < -268435456)) {
                if (A > 0)
                    A = (A + 5) / 10;
                else
                    A = (A - 5) / 10;
                B--;
            } else if (((int) (A / 10)) * 10 == A) {
                A = A / 10;
                B--;
            } else {
                break;
            }
        }
        // System.out.printf("A:[%s],B:[%s]%n", A, B);
        return (int) ((A << 3) | B);
    }

    /**
     * @description: 浮动小数
     **/
    public static int toSPF2(BigDecimal d) {
        int flot = BigDecimalUtils.getNumberOfDecimalPlace(d);
        int fv = 1;
        for (int i = 0; i < flot; i++) {
            fv *= 10;
        }
        long A;
        int B;
        A = d.multiply(BigDecimal.valueOf(fv)).add(BigDecimal.valueOf(BigDecimalUtils.compareLessZeroValue(d) ? -0.5 : 0.5)).longValue();
        B = flot;
        // System.out.printf("A:[%s],B:[%s]%n", A, B);
        return  (int) ((A << 3) | B);
    }

    public static byte[] fromHexString(String var0) {
        char[] var1 = var0.toUpperCase().toCharArray();
        int var2 = 0;

        for (int var3 = 0; var3 < var1.length; ++var3) {
            if (var1[var3] >= 48 && var1[var3] <= 57 || var1[var3] >= 65 && var1[var3] <= 70) {
                ++var2;
            }
        }
        byte[] var6 = new byte[var2 + 1 >> 1];
        int var4 = var2 & 1;
        for (int var5 = 0; var5 < var1.length; ++var5) {
            if (var1[var5] >= 48 && var1[var5] <= 57) {
                var6[var4 >> 1] = (byte) (var6[var4 >> 1] << 4);
                var6[var4 >> 1] = (byte) (var6[var4 >> 1] | var1[var5] - 48);
            } else {
                if (var1[var5] < 65 || var1[var5] > 70) {
                    continue;
                }
                var6[var4 >> 1] = (byte) (var6[var4 >> 1] << 4);
                var6[var4 >> 1] = (byte) (var6[var4 >> 1] | var1[var5] - 65 + 10);
            }
            ++var4;
        }
        return var6;
    }

    public static byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }

    public static int[] byteMerger(int[] int_1, int[] int_2) {
        int[] int_3 = new int[int_1.length + int_2.length];
        System.arraycopy(int_1, 0, int_3, 0, int_1.length);
        System.arraycopy(int_2, 0, int_3, int_1.length, int_2.length);
        return int_3;
    }

    /**
     * @description: HEX转换
     **/
    public static String convertHex(String hex) {
        return toHexAscii(reverse(fromHexString(hex)));
    }

    /**
     * @description: INT 转 字节长度HEX
     **/
    public static String completeBytes(Integer num, int length) {
        String hexNum = Integer.toHexString(num);
        return completeBytes(hexNum, length * 2).toUpperCase();
    }

    /**
     * @Description: 字节长度补充
     */
    public static String completeBytes(String content, int length) {
        if (content.length() % 2 != 0) {
            content = "0" + content;
        }

        content = ByteUtils.toHexString(ByteUtils.reverse(ByteUtils.fromHexString(content)));

        int contenLength = content.length();

        if (length < contenLength) return content.substring(0, length);

        for (int i = 0; i < length - contenLength; i++) {
            content += "0";
        }
        return content;
    }

    public static final LocalDateTime getStartTime() {
        return LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0);
    }

    public static String appendFill(String content) {
        String res = content;
        int lg = content.length() / 2;
        if (lg % 16 == 0) {
            return content;
        }
        int appendBit = 16 - (lg % 16);
        if (appendBit != 0) {
            for (int i = 0; i < appendBit; i++) {
                if (i == 0) {
                    res = res + "F0";
                } else {
                    res = res + "00";
                }
            }
        }
        return res;
    }

    /**
     * @description: 头添加补充长度
     **/
    public static String appendFill(String hexString, int length) {
        if (StringUtils.isBlank(hexString)) return "";
        if (hexString.length() >= length) return hexString.substring(0, length);
        int pantting = length - hexString.length();// 补充长度
        for (int i = 0; i < pantting; i++) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    /**
     * 将整数转换为byte数组并指定长度
     */
    public static byte[] intToBytes(int a, int length) {
        byte[] bs = new byte[length];
        for (int i = bs.length - 1; i >= 0; i--) {
            bs[i] = (byte) (a % 0xFF);
            a = a / 0xFF;
        }
        return bs;
    }

    /**
     * @description: 将整数转换为byte数组并1长度
     **/
    public static byte[] intToBytes(int a) {
        return intToBytes(a, 1);
    }

    /**
     * 将byte数组转换为整数
     */
    public static int bytesToInt(byte[] bs) {
        int a = 0;
        for (int i = bs.length - 1; i >= 0; i--) {
            a += bs[i] * Math.pow(0xFF, bs.length - i - 1);
        }
        return a;
    }
}
