package com.jhscale.meter.utils;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Loveven
 * @title: CodeUtils
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2019/9/215:31
 */
public class CodeUtils {

    public static final int[] codeArr = {
            0x10, 0x0F, 0x9C, 0x8B, 0x5E, 0x2E, 0x4D, 0x7D, 0xF8, 0xE8, 0x6C, 0xD9, 0xC9, 0x3F, 0xBA, 0xAA,
            0x30, 0x8A, 0x0E, 0x9D, 0x4C, 0x5F, 0x6B, 0xE7, 0x2D, 0xF9, 0xC8, 0x7E, 0xDA, 0xA9, 0x11, 0xBB,
            0xBC, 0x89, 0x50, 0x2C, 0x4B, 0x9E, 0xE6, 0x6A, 0xC7, 0x31, 0xFA, 0x12, 0xA8, 0xDB, 0x0D, 0x7F,
            0x70, 0xBD, 0x4A, 0x51, 0x69, 0xE5, 0x0C, 0xC6, 0x9F, 0x13, 0xA7, 0xFB, 0x32, 0x2B, 0xDC, 0x88,
            0x90, 0x14, 0xBE, 0x71, 0xE4, 0x68, 0xC5, 0x2A, 0x52, 0xA6, 0x0B, 0x33, 0xFC, 0x87, 0x49, 0xDD,
            0xDE, 0x67, 0x91, 0xE3, 0x34, 0xBF, 0xC4, 0x72, 0x29, 0xA5, 0x0A, 0x53, 0x86, 0xFD, 0x48, 0x15,
            0xB0, 0xDF, 0xE2, 0x16, 0x35, 0xC3, 0x92, 0x47, 0xA4, 0x73, 0x09, 0x85, 0x54, 0x28, 0xFE, 0x66,
            0xD0, 0xE1, 0x08, 0xB1, 0xC2, 0x46, 0x27, 0xA3, 0x93, 0x36, 0x84, 0x74, 0x17, 0x65, 0x55, 0xFF,
            0xF0, 0xE0, 0x56, 0xD1, 0xC1, 0x45, 0xB2, 0xA2, 0x26, 0x83, 0x94, 0x18, 0x64, 0x75, 0x07, 0x37,
            0xEF, 0xF1, 0xC0, 0x38, 0xD2, 0xA1, 0x57, 0xB3, 0x82, 0x06, 0x63, 0x95, 0x19, 0x25, 0x76, 0x44,
            0xA0, 0x1A, 0xF2, 0x81, 0xD3, 0xCF, 0x39, 0xB4, 0x62, 0x58, 0x24, 0x96, 0x43, 0x05, 0x77, 0xEE,
            0x80, 0x78, 0xCE, 0xF3, 0x23, 0xD4, 0x61, 0xAF, 0xB5, 0x04, 0x42, 0x59, 0x97, 0x3A, 0xED, 0x1B,
            0x60, 0xCD, 0x79, 0x1C, 0xF4, 0xAE, 0xD5, 0x41, 0x03, 0xB6, 0x22, 0x8F, 0x5A, 0xEC, 0x98, 0x3B,
            0xCC, 0x40, 0x6F, 0xAD, 0x7A, 0xF5, 0x3C, 0xD6, 0x02, 0x8E, 0xB7, 0x21, 0xEB, 0x1D, 0x5B, 0x99,
            0x9A, 0xAC, 0x6E, 0x5C, 0x4F, 0x7B, 0xF6, 0x8D, 0xD7, 0x20, 0xB8, 0xEA, 0x3D, 0x1E, 0xCB, 0x01,
            0xAB, 0x2F, 0x9B, 0x5D, 0x00, 0x8C, 0x3E, 0xF7, 0x7C, 0xD8, 0xE9, 0x1F, 0xB9, 0xCA, 0x4E, 0x6D
    };

    public static final int[] decodeArr = {
            0xF4, 0xEF, 0xD8, 0xC8, 0xB9, 0xAD, 0x99, 0x8E, 0x72, 0x6A, 0x5A, 0x4A, 0x36, 0x2E, 0x12, 0x01,
            0x00, 0x1E, 0x2B, 0x39, 0x41, 0x5F, 0x63, 0x7C, 0x8B, 0x9C, 0xA1, 0xBF, 0xC3, 0xDD, 0xED, 0xFB,
            0xE9, 0xDB, 0xCA, 0xB4, 0xAA, 0x9D, 0x88, 0x76, 0x6D, 0x58, 0x47, 0x3D, 0x23, 0x18, 0x05, 0xF1,
            0x10, 0x29, 0x3C, 0x4B, 0x54, 0x64, 0x79, 0x8F, 0x93, 0xA6, 0xBD, 0xCF, 0xD6, 0xEC, 0xF6, 0x0D,
            0xD1, 0xC7, 0xBA, 0xAC, 0x9F, 0x85, 0x75, 0x67, 0x5E, 0x4E, 0x32, 0x24, 0x14, 0x06, 0xFE, 0xE4,
            0x22, 0x33, 0x48, 0x5B, 0x6C, 0x7E, 0x82, 0x96, 0xA9, 0xBB, 0xCC, 0xDE, 0xE3, 0xF3, 0x04, 0x15,
            0xC0, 0xB6, 0xA8, 0x9A, 0x8C, 0x7D, 0x6F, 0x51, 0x45, 0x34, 0x27, 0x16, 0x0A, 0xFF, 0xE2, 0xD2,
            0x30, 0x43, 0x57, 0x69, 0x7B, 0x8D, 0x9E, 0xAE, 0xB1, 0xC2, 0xD4, 0xE5, 0xF8, 0x07, 0x1B, 0x2F,
            0xB0, 0xA3, 0x98, 0x89, 0x7A, 0x6B, 0x5C, 0x4D, 0x3F, 0x21, 0x11, 0x03, 0xF5, 0xE7, 0xD9, 0xCB,
            0x40, 0x52, 0x66, 0x78, 0x8A, 0x9B, 0xAB, 0xBC, 0xCE, 0xDF, 0xE0, 0xF2, 0x02, 0x13, 0x25, 0x38,
            0xA0, 0x95, 0x87, 0x77, 0x68, 0x59, 0x49, 0x3A, 0x2C, 0x1D, 0x0F, 0xF0, 0xE1, 0xD3, 0xC5, 0xB7,
            0x60, 0x73, 0x86, 0x97, 0xA7, 0xB8, 0xC9, 0xDA, 0xEA, 0xFC, 0x0E, 0x1F, 0x20, 0x31, 0x42, 0x55,
            0x92, 0x84, 0x74, 0x65, 0x56, 0x46, 0x37, 0x28, 0x1A, 0x0C, 0xFD, 0xEE, 0xD0, 0xC1, 0xB2, 0xA5,
            0x70, 0x83, 0x94, 0xA4, 0xB5, 0xC6, 0xD7, 0xE8, 0xF9, 0x0B, 0x1C, 0x2D, 0x3E, 0x4F, 0x50, 0x61,
            0x81, 0x71, 0x62, 0x53, 0x44, 0x35, 0x26, 0x17, 0x09, 0xFA, 0xEB, 0xDC, 0xCD, 0xBE, 0xAF, 0x90,
            0x80, 0x91, 0xA2, 0xB3, 0xC4, 0xD5, 0xE6, 0xF7, 0x08, 0x19, 0x2A, 0x3B, 0x4C, 0x5D, 0x6E, 0x7F
    };

    /**
     * @description: 字符串转码
     **/
    private static String code(String str, int[] arr) throws MeterException {
        if (StringUtils.isBlank(str) || str.length() % 2 != 0)
            throw new MeterException(MeterStateEnum.AD数据包格式错误);

        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < (str.length() / 2); i++) {
            int index = Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
            String val = Integer.toHexString(arr[index]);
            if (val.length() != 2) {
                val = "0" + val;
            }
            stringBuffer.append(val);
        }
        return stringBuffer.toString().toUpperCase();
    }

    /**
     * @description: 字节流转码
     **/
    private static byte[] code(byte[] source, int[] arr) throws MeterException {
        if (source == null || source.length == 0)
            throw new MeterException(MeterStateEnum.AD数据包格式错误);
        byte[] target = new byte[source.length];
        for (int i = 0; i < source.length; i++) {
            target[i] = (byte) arr[source[i] & 0XFF];
        }
        return target;
    }

    /**
     * @description: 加密
     **/
    public static byte[] encode(byte[] bytes) throws MeterException {
        return code(bytes, codeArr);
    }

    /**
     * @description: 加密
     **/
    public static String encode(String data) throws MeterException {
        return code(data, codeArr);
    }

    /**
     * @description: 解密
     **/
    public static byte[] decode(byte[] bytes) throws MeterException {
        return code(bytes, decodeArr);
    }

    /**
     * @description: 解密
     **/
    public static String decode(String data) throws MeterException {
        return code(data, decodeArr);
    }

    public static String checkData(String data) throws MeterException {
        String start = data.substring(0, 2);
        if (!"02".equals(start)) {
            throw new MeterException(MeterStateEnum.AD数据包头无效);
        }

        String end = data.substring(data.length() - 2, data.length());
        if (!"03".equals(end)) {
            throw new MeterException(MeterStateEnum.AD数据包尾无效);
        }
        return data.substring(2, data.length() - 2);
    }
}
