package com.jhscale.meter.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: CrcUtils
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/12/115:55
 */
public class CrcUtils {

    /**
     * @description: CRC值计算
     **/
    public static int crc(byte[] data_arr) {
        int icrc = 0;
        for (byte by : data_arr) {
            icrc += by;
        }
        return icrc;
    }

    /**
     * @description: 业务CRC有效值
     **/
    public static String crc(String data) {
        String crc = Integer.toHexString(crc(ByteUtils.fromHexString(data)));
        return StringUtils.isBlank(crc) ? "00" : (crc.length() == 1 ? "0" + crc : crc.substring(crc.length() - 2)).toUpperCase();
    }

    /**
     * @description: 0xff - 和 % 0xff
     **/
    public static String crc_0xff(String data) {
        String crc = crc(data);
        int cv = 0XFF - Integer.parseInt(crc, 16);
        crc = Integer.toHexString(cv);
        return (crc.length() % 2 == 0 ? crc : ("0" + crc)).toUpperCase();
    }
}
