package com.jhscale.meter.utils;

import com.jhscale.common.utils.JSONUtils;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: FileUtils
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-0516:52
 */
public class FileUtils {

    private FileUtils() {
    }

    /**
     * @description: 文件转Hex 字符串
     **/
    public static String fileToHex(File file) {
        try {
            return inputStreamToHex(new FileInputStream(file));
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    /**
     * @description: 文件内容那个转 HEX字符
     **/
    public static String fileContentsToHex(String content) {
        // long s1 = System.currentTimeMillis();
        byte[] bytes = content.getBytes();
        // long s2 = System.currentTimeMillis();
        StringBuilder builder = new StringBuilder();

        for (int i = 0; i < bytes.length; i++) {
            builder.append(Integer.toHexString(bytes[i] - 0x40));
        }
        // long s3 = System.currentTimeMillis();
        // System.out.println(String.format("S1:[%s] S2:[%s]", (s2 - s1), (s3 - s2)));
        // hex = hex.toUpperCase();
        // String _content = hexToFileContents(hex);
        // System.out.println(_content.equals(content));
        return builder.toString();
    }

    /**
     * @description: 文件内容那个转 HEX字符
     **/
    public static String hexToFileContents(String hex) {
        byte[] bytes = new byte[hex.length()];
        for (int i = 0; i < hex.length(); i++) {
            bytes[i] = (byte) (Integer.parseInt(String.valueOf(hex.charAt(i)), 16) + 0x40);
        }
        return new String(bytes);
    }

    /**
     * @description: 流转Hex 字符串
     **/
    public static String inputStreamToHex(InputStream inputStream) {
        return ByteUtils.toHexAscii(inputStreamToBytes(inputStream)).toUpperCase();
    }

    /**
     * @description: 文件 转 字节流
     **/
    public static byte[] fileToBytes(File file) {
        try {
            return inputStreamToBytes(new FileInputStream(file));
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * @description: 流 转 字节流
     **/
    public static byte[] inputStreamToBytes(InputStream inputStream) {
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            int len = 0;
            byte[] buffer = new byte[1024];
            while (-1 != (len = inputStream.read(buffer))) {
                bos.write(buffer, 0, len);
            }
            return bos.toByteArray();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                }
            }
        }
        return null;
    }

    private final static byte STX = 0X55;
    private final static byte ETX = 0X04;
    private final static byte DLE = 0X05;

    /**
     * @description: 升级文件处理
     **/
    public static byte[] upgradeBytes(byte[] source) {
        if (source == null || source.length == 0) return new byte[0];
        List<Byte> targetList = new ArrayList<>();
        targetList.add(DLE);
        for (byte b : source) {
            if (b == STX || b == ETX || b == DLE)
                targetList.add(DLE);
            targetList.add(b);
        }
        targetList.add(STX);
        byte[] target = new byte[targetList.size()];
        for (int i = 0; i < targetList.size(); i++) {
            target[i] = targetList.get(i);
        }
        return target;
    }

    /**
     * @description: 写文件
     **/
    public static void writer(String str, String filePath) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filePath));
            out.write(str);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * @description: 读文件
     **/
    /**
     * @description: 读文件
     **/
    public static String reader(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }

        FileReader fr = null;
        BufferedReader br = null;

        try {
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            StringBuffer buffer = new StringBuffer();
            while (br.ready()) {
                buffer = buffer.append(br.readLine());
            }
            return buffer.toString();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                } catch (IOException e) {
                }
            }
        }
        return null;
    }

    /**
     * @description: 读文件
     **/
    public static <T> T reader(File file, Class<T> clazz) {
        return JSONUtils.jsonToObject(reader(file), clazz);
    }

    /**
     * @description: 读文件
     **/
    public static <T> List<T> readerList(File file, Class<T> clazz) {
        return JSONUtils.jsonToList(reader(file), clazz);
    }
}
