package com.jhscale.meter.utils;

import com.jhscale.meter.mqtt.em.SensorLock;
import com.jhscale.meter.mqtt.entity.SensorLocking;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * @author lie_w
 * @title: MQTTUtils
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/11/116:26
 */
public class MQTTUtils {

    private MQTTUtils() {
    }

    /**
     * @description: 十进制转16进制
     **/
    public static String int2Hex(int i) {
        String hex = Integer.toHexString(i);
        return hex.length() % 2 != 0 ? ("0" + hex) : hex;
    }

    /**
     * @description: 十进制转16进制 2字节
     **/
    public static String int2Hex2(int i) {
        String hex = Integer.toHexString(i);
        int insert = 4 - hex.length();
        for (int j = 0; j < insert; j++) {
            hex = "0" + hex;
        }
        return hex;
    }

    /**
     * @description: 16进制转十进制
     **/
    public static int hex2Int(String hex) {
        return Integer.parseInt(hex, 16);
    }

    /**
     * @description: 16进制转二进制
     **/
    public static String hex2Bit(String hex) {
        String bit = Integer.toBinaryString(Integer.parseInt(hex, 16));
        int insert = 8 - bit.length();
        for (int i = 0; i < insert; i++) {
            bit = "0" + bit;
        }
        return bit;
    }

    /**
     * @description: 二进制转16进制
     **/
    public static String bit2Hex(String bit) {
        String hex = Integer.toHexString(Integer.parseInt(bit, 2));
        return hex.length() % 2 != 0 ? ("0" + hex) : hex;
    }

    /**
     * @description: 二进制转十进制
     **/
    public static int bit2Int(String bit) {
        return Integer.parseInt(bit, 2);
    }

    /**
     * @description: 十进制转二进制
     **/
    public static String int2Bit(int i) {
        return int2Bit(i, 2);
    }

    /**
     * @description: 十进制转二进制
     **/
    public static String int2Bit(int i, int len) {
        String bitStr = Integer.toBinaryString(i);
        int insert = len - bitStr.length();
        for (int index = 0; index < insert; index++) {
            bitStr = "0" + bitStr;
        }
        return bitStr;
    }

    /**
     * @description: 浮动数组填充
     **/
    public static void bitPart(List<Character> chars, List<String> params, int i) {
        try {
            if (StringUtils.isNotBlank(params.get(i))) {
                chars.add('1');
            } else {
                chars.add('0');
            }
        } catch (Exception e) {
            chars.add('0');
        }
    }

    /**
     * @description: 浮动数组填充
     **/
    public static void collect(List<Character> chars2, List<Character> chars) {
        if (chars.contains('1')) {
            chars2.add('1');
        } else {
            chars2.add('0');
        }
    }

    /**
     * @description: 浮动数组转Hex
     **/
    public static String floatArr2Hex(List<Character> list) {
        StringBuffer sb = new StringBuffer();
        if (list != null && !list.isEmpty()) {
            for (int i = list.size(); i > 0; i--)
                sb.insert(0, list.get(i - 1));
        }
        return sb.toString();
    }

    /**
     * @description: 汽车衡传感器异常
     **/
    public static String sensorLock(List<SensorLocking> sensorLockings) {
        int[] lock = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] hardware = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] link = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] config = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] ovf = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

        Optional.ofNullable(sensorLockings)
                .orElse(Collections.emptyList())
                .forEach(sensorLocking -> {
                    switch (sensorLocking.getLock()) {
                        case LOCK:
                            lock[sensorLocking.getIndex()] = 1;
                            break;
                        case HARDWARE:
                            hardware[sensorLocking.getIndex()] = 1;
                            break;
                        case LINK:
                            link[sensorLocking.getIndex()] = 1;
                            break;
                        case CONFIG:
                            config[sensorLocking.getIndex()] = 1;
                            break;
                        case OVF:
                            ovf[sensorLocking.getIndex()] = 1;
                            break;
                    }
                });

        return intBinArrToHex(lock) +
                intBinArrToHex(hardware) +
                intBinArrToHex(link) +
                intBinArrToHex(config) +
                intBinArrToHex(ovf);
    }

    /**
     * @description: int 二进制数组 转 Hex
     **/
    public static String intBinArrToHex(int[] binArr) {
        String bin = "";
        for (int i : binArr) {
            bin += i;
        }
        return int2Hex2(bit2Int(bin));
    }

    /**
     * @description: 汽车衡传感器异常
     **/
    public static List<SensorLocking> sensorLock(String sesorLockHex) {
        int[] lock = hexToIntBinArr(sesorLockHex.substring(0, 4));
        int[] hardware = hexToIntBinArr(sesorLockHex.substring(4, 8));
        int[] link = hexToIntBinArr(sesorLockHex.substring(8, 12));
        int[] config = hexToIntBinArr(sesorLockHex.substring(12, 16));
        int[] ovf = hexToIntBinArr(sesorLockHex.substring(16, 20));

        List<SensorLocking> sensorLockings = new ArrayList<>();

        if (contains(lock, 1)) {
            for (int i = 0; i < lock.length; i++) {
                if (lock[i] == 1) sensorLockings.add(new SensorLocking(i, SensorLock.LOCK));
            }
        }

        if (contains(hardware, 1)) {
            for (int i = 0; i < hardware.length; i++) {
                if (hardware[i] == 1) sensorLockings.add(new SensorLocking(i, SensorLock.HARDWARE));
            }
        }

        if (contains(link, 1)) {
            for (int i = 0; i < link.length; i++) {
                if (link[i] == 1) sensorLockings.add(new SensorLocking(i, SensorLock.LINK));
            }
        }

        if (contains(config, 1)) {
            for (int i = 0; i < config.length; i++) {
                if (config[i] == 1) sensorLockings.add(new SensorLocking(i, SensorLock.CONFIG));
            }
        }

        if (contains(ovf, 1)) {
            for (int i = 0; i < ovf.length; i++) {
                if (ovf[i] == 1) sensorLockings.add(new SensorLocking(i, SensorLock.OVF));
            }
        }
        return sensorLockings;
    }

    /**
     * @description: HEX 转 二进制 bin 数组
     **/
    public static int[] hexToIntBinArr(String hex) {
        String bin = int2Bit(hex2Int(hex), 16);
        int[] binArr = new int[bin.length()];
        for (int i = 0; i < bin.length(); i++) {
            binArr[i] = Integer.parseInt(String.valueOf(bin.charAt(i)));
        }
        return binArr;
    }

    /**
     * @description: 数组包含元素
     **/
    private static boolean contains(int[] arr, int val) {
        if (arr == null || arr.length == 0) return false;
        for (int i : arr) {
            if (i == val) return true;
        }
        return false;
    }

//    public static void main(String[] args) {
//        List<SensorLocking> sensorLockings = new ArrayList<>();
//        sensorLockings.add(new SensorLocking(1, SensorLock.LOCK));
//        sensorLockings.add(new SensorLocking(4, SensorLock.HARDWARE));
//        sensorLockings.add(new SensorLocking(8, SensorLock.LINK));
//        sensorLockings.add(new SensorLocking(12, SensorLock.CONFIG));
//        sensorLockings.add(new SensorLocking(15, SensorLock.OVF));
//
//        String hex = sensorLock(sensorLockings);
//        System.out.println(hex);
//
//        List<SensorLocking> sensorLockings1 = sensorLock(hex);
//        System.out.println(JSONUtils.objectToJSON(sensorLockings));
//    }
}
