package com.jhscale.meter.utils;

import com.alibaba.fastjson.JSON;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author lie_w
 * @title: MapUtils
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2020-12-1614:16
 */
public class MapUtils {

    /**
     * @description: 对象转MAP
     **/
    public static Map<String, String> toMap(Object obj) {
        Map<String, String> map = new HashMap<>();

        List<Field> fields = new ArrayList<>();
        getAllFieldList(obj.getClass(), fields);

        if (!fields.isEmpty()) {
            fields.forEach(field -> {
                try {
                    field.setAccessible(true);
                    Object o = field.get(obj);
                    if (o != null) {
                        if (o instanceof String || o instanceof Integer || o instanceof Double || o instanceof Long || o instanceof BigDecimal) {
                            map.put(field.getName(), o.toString());
                        } else {
                            map.put(field.getName(), JSON.toJSONString(o));
                        }
                    }
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
        }
        return map;
    }

    /**
     * @description: 获取类全部属性
     **/
    public static void getAllFieldList(Class clazz, List<Field> fields) {
        Field[] declaredFields = clazz.getDeclaredFields();
        if (declaredFields != null && declaredFields.length > 0) fields.addAll(Arrays.asList(declaredFields));
        Class superclass = clazz.getSuperclass();
        if (Objects.nonNull(superclass)) getAllFieldList(superclass, fields);
    }
}
