package com.jhscale.meter.utils;

import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.common.model.device._inner.PublicExecuteModify;
import com.jhscale.common.model.device._inner.PublicExecuteRecovery;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.DDataUtils;
import com.jhscale.common.utils.GJSONUtils;
import com.jhscale.meter.entity.ProtocolAnalyse;
import com.jhscale.meter.protocol.model.GlobalPara;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import static com.jhscale.common.model.device.DConstant.TXT_END;

/**
 * @author Loveven
 * @title: MeterUtils
 * @projectName meter-jar
 * @description: TODO
 * @date 2021-06-1416:14
 */
public class MeterUtils {

    private MeterUtils() {
    }

    /**
     * @description: 查看小数点位数
     **/
    public static int checkIsDoublePointTwo(BigDecimal val) {
        if (val == null) return 0;
        String[] ss = val.toString().split("\\.");
        return ss.length <= 1 ? 0 : ss[1].length();
    }

    /**
     * @description: 获取10的倍数
     **/
    public static int floatVal(int floa) {
        int floaVal = 1;
        for (int i = 0; i < floa; i++) {
            floaVal = floaVal * 10;
        }
        return floaVal;
    }

    /**
     * @description: 通用数据响应数据包处理
     **/
    public static String public_response_package(List<PublicExecute> accepts, List<PublicExecute> sends) {
        if (sends == null || sends.isEmpty()) {
            if (accepts != null && !accepts.isEmpty()) {
                for (PublicExecute callExecute : accepts) {
                    if (callExecute instanceof PublicExecuteRecovery) {
                        if (sends == null) sends = new ArrayList<>();
                        sends.add(new PublicExecuteModify(callExecute.getType()));
                    }
                }
            }
        }

        if (GlobalPara.getInstance().isRunLog()) {
            System.out.println(String.format("Request --- Package: %s", GJSONUtils.objectToJSON(accepts)));
            System.out.println(String.format("Response --- Package: %s", GJSONUtils.objectToJSON(sends)));
        }

        return answers_execute(sends);
    }

    /**
     * @description: 通用数据响应数据包处理
     **/
    public static String public_response_package(PublicExecute accept, List<PublicExecute> answers) {
        if (accept instanceof PublicExecuteRecovery && (answers == null || answers.isEmpty())) {
            answers = new ArrayList<>();
            answers.add(new PublicExecuteModify(accept.getType()));
        }

        if (GlobalPara.getInstance().isRunLog()) {
            System.out.println(String.format("Accept --- Package: %s", GJSONUtils.objectToJSON(accept)));
            System.out.println(String.format("Answers --- Package: %s", GJSONUtils.objectToJSON(answers)));
        }

        return answers_execute(answers);
    }

    /**
     * @description: 响应结果转换
     **/
    private static String answers_execute(List<PublicExecute> answers) {
        if (answers != null && !answers.isEmpty()) {
            String response = DDataUtils.Public_Package_No_Reflex(answers);
            if (GlobalPara.getInstance().isRunLog())
                System.out.println(String.format("Response --- Content：%s", response));
            return response;
        } else {
            return "";
        }
    }

    /**
     * @description: 9C 8B 内容解包
     **/
    public static ProtocolAnalyse analyse(byte[] buffer) {
        ProtocolAnalyse analyse = new ProtocolAnalyse();
        if (buffer[0] != 0x02) {
            boolean has_prefix = false;
            for (int i = 0; i < buffer.length; i++) {
                if (buffer[i] == 0x02) {
                    buffer = Arrays.copyOfRange(buffer, i, buffer.length);
                    has_prefix = true;
                    break;
                }
            }
            if (!has_prefix) return analyse;
        }

        int index = 0;

        for (int i = 0; i < buffer.length; i++) {
            if (buffer[i] == 0x03) {
                byte[] copy = Arrays.copyOfRange(buffer, index, i + 1);
                int length = Integer.parseInt(ByteUtils.toHexString(Arrays.copyOfRange(copy, 1, 2)), 16) + 5;
                if (length == copy.length) {
                    analyse.addBytes(copy);
                    index = i + 1;
                    continue;
                }
            }

            // if (buffer[i] == 0x03) {
            //     if (i + 1 != buffer.length && buffer[i + 1] == 0x02) {
            //         analyse.addBytes(Arrays.copyOfRange(buffer, index, i + 1));
            //         index = i + 1;
            //         continue;
            //     }

            //     if (i + 1 == buffer.length) {
            //         byte[] copy = Arrays.copyOfRange(buffer, index, i + 1);
            //         if (Integer.parseInt(ByteUtils.toHexString(Arrays.copyOfRange(copy, 1, 2)), 16) + 5 == copy.length) {
            //             analyse.addBytes(copy);
            //             index = i + 1;
            //             continue;
            //         }
            //     }
            // }
        }

        analyse.setSurplus(Arrays.copyOfRange(buffer, index, buffer.length));

        return analyse;
    }

    /**
     * @description: 数字字节
     **/
    public static String append(int val) {
        return ByteUtils.int2HexWithPush_nr(val, 2);
    }

    /**
     * @description: 数字字节
     **/
    public static String append(int val, int length) {
        return ByteUtils.int2HexWithPush_nr(val, length);
    }

    /**
     * @description: 添加字符串
     **/
    public static String append(String text) {
        return (StringUtils.isNotBlank(text) ? ByteUtils.toHexString(text.getBytes()) : "") + TXT_END;
    }

    /**
     * @description: 添加时间
     **/
    public static String append(Date date) {
        return ByteUtils.timeToStr(date);
    }

    /**
     * @description: 添加字节
     **/
    public static String append(byte[] bytes) {
        return ByteUtils.toHexString(bytes);
    }

}
