package com.jhscale.meter.utils;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @ClassName: NidManage
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/3/29 9:03
 * @Version: V1.0.0
 */
public class NidManagerUtils {

    private Map<String, Integer> manager;

    private NidManagerUtils() {
        manager = new ConcurrentHashMap<>();
    }

    private static class Singleton {
        private static final NidManagerUtils manager = new NidManagerUtils();
    }

    public static NidManagerUtils getInstance() {
        return Singleton.manager;
    }

    public String getNId(String mac) {
        Integer vaule = manager.get(mac);
        if (Objects.isNull(vaule))
            vaule = 0;
        vaule = vaule + (int) (Math.random() * 256);
        String hexData = ByteUtils.int2HexWithPush(vaule, 4);
        manager.put(mac, vaule);
        return hexData;
    }
}
