package com.jhscale.meter.utils;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.print.entity.PrintLOGParam;
import com.jhscale.meter.protocol.print.entity.para.Para;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: PrintUtils
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/10/2519:09
 */
public class PrintUtils {

    private PrintUtils() {
    }

    private static PrintLOGParam PRINT_LOG_PARAM;

    static {
        PRINT_LOG_PARAM = new PrintLOGParam();
    }

    /**
     * @description: 设置静态打印参数
     **/
    public static boolean PRINT_LOG_PARAM(PrintLOGParam printLogParam) {
        PRINT_LOG_PARAM = printLogParam;
        return true;
    }

    /**
     * @description: Para 数据编译
     **/
    public static String compile(List<Para> paras) {
        StringBuffer buffer = new StringBuffer();
        if (paras != null && !paras.isEmpty()) {
            for (Para para : paras) {
                buffer.append(para.compile(GlobalPara.getInstance().getWord_encoding()));
            }
        }
        return buffer.toString();
    }

    /**
     * @description: Para 数据编译
     **/
    public static String compile(Para... paras) {
        return (paras != null && paras.length > 0) ? compile(Arrays.asList(paras)) : "";
    }

    /**
     * @description: 打印日志
     **/
    public static void debug(PrintLOGParam param, Object obj) {
        param = Objects.isNull(param) ? PRINT_LOG_PARAM : param;
        long time = System.currentTimeMillis();
        int count = 1;
        try {
            if (param.is_switch() && Objects.nonNull(param.get_length())) {
                String log = JSONObject.toJSONString(obj);
                while (StringUtils.isNotBlank(log)) {
                    if (log.length() <= param.get_length()) {
                        System.out.println(String.format("DEBUG --{ %s }[%s]--- %s ", time, count, log));
                        log = null;
                    } else {
                        System.out.println(String.format("DEBUG --{ %s }[%s]--- %s ", time, count, log.substring(0, param.get_length())));
                        log = log.substring(param.get_length());
                    }
                    count++;
                }
            }
        } catch (Exception e) {
            System.err.printf("DEBUG Log ERROR---{ %s }[%s]---- %s%n", time, count, e.getMessage());
            e.printStackTrace();
        }
    }
}
