package com.jhscale.meter.utils;

import java.util.List;
import java.util.Scanner;

/**
 * @author lie_w
 * @title: ScannerUtil
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/6/1014:04
 */
public class ScannerUtils {

    private ScannerUtils() {
    }

    /**
     * @description: 获取输入
     **/
    public static String scanner(String description) {
        Scanner scanner = new Scanner(System.in);
        System.out.print(description + ": ");
        return scanner.nextLine();
    }

    /**
     * @description: 下拉选择
     **/
    public static <T> T scanner(String description, List<T> list) {
        Scanner scanner = new Scanner(System.in);
        try {
            System.out.println("下拉列表[" + list.size() + "]如下: ");
            for (int i = 0; i < list.size(); i++) {
                System.out.println((i + 1) + ".: " + list.get(i).toString());
            }
            System.out.print(description + ": ");
            int i = scanner.nextInt();
            return list.get(i - 1);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * @description: 下拉选择
     **/
    public static <T> T scanner(String description, T... arr) {
        Scanner scanner = new Scanner(System.in);
        try {
            System.out.println("下拉列表[" + arr.length + "]如下: ");
            for (int i = 0; i < arr.length; i++) {
                System.out.println((i + 1) + ".: " + arr[i].toString());
            }
            System.out.print(description + ": ");
            int i = scanner.nextInt();
            return arr[i - 1];
        } catch (Exception e) {
            return null;
        }
    }
}
