package com.jhscale.meter.wifi.entity;

import com.jhscale.common.em.SyncDataType;
import com.jhscale.common.model.device.saleman.DSaleManV1;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.common.utils.DDataUtils;
import com.jhscale.meter.wifi.constant.CMDConstant;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lie_w
 * @title: Assistant
 * @projectName jhscale-agreement
 * @description: 营业员
 * @date 2019/9/1523:42
 */
public class Assistant extends Content {

    private static final String dSort = "07";

    private String name;

    private String pwd;
    private String discountLower;
    private String discountUpper;
    private String security;
    private String number;

    /**
     * @param charter 字符集
     * @param dCmd    指令类型
     * @param dId     编号
     * @description: 带字符集有参构造指令类型
     */
    public Assistant(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    /**
     * @param dCmd 指令类型
     * @param dId  编号
     * @description: 默认字符集有参构造指令类型
     */
    public Assistant(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    /**
     * @description: 默认构造 回收指令
     **/
    public Assistant() {
        super("", CMDConstant.REQ, dSort, CMDConstant.RECOVER_DID);
    }

    /**
     * @description: 数据解析
     **/
    public Assistant(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) Base64Utils.ungzipString(dData);
        ContentParse parse = new ContentParse(dData, charter);
        this.name = parse.parseText();
        char[] chars = parse.parsefloatData();
        parseFload(chars, parse);
    }

    private void parseFload(char[] chars, ContentParse parse) {
        if (chars[0] == '1') this.pwd = parse.parse4Bytes();
        if (chars[1] == '1') this.discountLower = parse.parse1Bytes();
        if (chars[2] == '1') this.discountUpper = parse.parse1Bytes();
        if (chars[3] == '1') this.security = parse.parse4Bytes();
        if (chars[4] == '1') this.number = parse.parseText();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPwd() {
        return pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public String getDiscountLower() {
        return discountLower;
    }

    public void setDiscountLower(String discountLower) {
        this.discountLower = discountLower;
    }

    public String getDiscountUpper() {
        return discountUpper;
    }

    public void setDiscountUpper(String discountUpper) {
        this.discountUpper = discountUpper;
    }

    public String getSecurity() {
        return security;
    }

    public void setSecurity(String security) {
        this.security = security;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @Override
    public List<String> gtCollectList() {
        collectionList.add(pwd);
        collectionList.add(discountLower);
        collectionList.add(discountUpper);
        collectionList.add(security);
        collectionList.add(number);
        return collectionList;
    }

    @Override
    public String gtDData(String charter) {
        ContentAssembler assembler = new ContentAssembler(charter)
                .appendText(this.name)
                .append(gtFloat());

        if (StringUtils.isNotBlank(this.pwd))
            assembler.append4Bytes(this.pwd);
        if (StringUtils.isNotBlank(this.discountLower))
            assembler.append1Bytes(this.discountLower);
        if (StringUtils.isNotBlank(this.discountUpper))
            assembler.append1Bytes(this.discountUpper);
        if (StringUtils.isNotBlank(this.security))
            assembler.append4Bytes(this.security);
        if (StringUtils.isNotBlank(this.number))
            assembler.appendText(this.number);
        return assembler.over();
    }

    /**
     * @description: 数据同步类型key 如  PLU、CLS、SAL
     **/
    @Override
    public String dataKey() {
        return SyncDataType.SAL.getType();
    }

    /**
     * @description: 对象转换
     **/
    @Override
    public DataJSONModel toDData() {
        return new DSaleManV1<>()
                .setNo(this.did())
                .setName(name)
                .setPassword(pwd)
                .setChangeLower(StringUtils.isBlank(discountLower) ? BigDecimal.ZERO : new BigDecimal(discountLower))
                .setChangeUpper(StringUtils.isBlank(discountUpper) ? BigDecimal.ZERO : new BigDecimal(discountUpper))
                .setDisPowers(DDataUtils.disPowerToDisPowers(this.security))
                .setCard(number);
    }
}
