package com.jhscale.meter.wifi.entity;

import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.wifi.constant.CMDConstant;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @author lie_w
 * @title: BarCode
 * @projectName jhscale-agreement
 * @description: 条码格式
 * @date 2019/9/1612:09
 */
public class BarCode extends Content {

    private static final String dSort = "05";

    private String name;
    private String type;
    private String description;

    private String checkType;
    private String constant1;
    private String constant2;

    /**
     * @param charter 字符集
     * @param dCmd    指令类型
     * @param dId     编号
     * @description: 带字符集有参构造指令类型
     */
    public BarCode(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    /**
     * @param dCmd 指令类型
     * @param dId  编号
     * @description: 默认字符集有参构造指令类型
     */
    public BarCode(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    /**
     * @description: 默认构造 回收指令
     **/
    public BarCode() {
        super("", CMDConstant.REQ, dSort, CMDConstant.RECOVER_DID);
    }

    /**
     * @description: 数据解析
     **/
    public BarCode(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) Base64Utils.ungzipString(dData);
        ContentParse parse = new ContentParse(dData, charter);
        this.name = parse.parseText();
        this.type = parse.parse1Bytes();
        this.description = parse.parseText();
        char[] chars = parse.parsefloatData();
        parseFload(chars, parse);
    }

    private void parseFload(char[] chars, ContentParse parse) {
        if (chars[0] == '1') this.checkType = parse.parse4Bytes();
        if (chars[1] == '1') this.constant1 = parse.parse4Bytes();
        if (chars[2] == '1') this.constant2 = parse.parse4Bytes();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCheckType() {
        return checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    public String getConstant1() {
        return constant1;
    }

    public void setConstant1(String constant1) {
        this.constant1 = constant1;
    }

    public String getConstant2() {
        return constant2;
    }

    public void setConstant2(String constant2) {
        this.constant2 = constant2;
    }

    @Override
    public List<String> gtCollectList() {
        collectionList.add(checkType);
        collectionList.add(constant1);
        collectionList.add(constant2);
        return collectionList;
    }

    @Override
    public String gtDData(String charter) {
        ContentAssembler assembler = new ContentAssembler(charter)
                .appendText(this.name)
                .append1Bytes(this.type)
                .appendText(this.description)
                .append(gtFloat());

        if (StringUtils.isNotBlank(this.checkType))
            assembler.append1Bytes(this.checkType);
        if (StringUtils.isNotBlank(this.constant1))
            assembler.append4Bytes(this.constant1);
        if (StringUtils.isNotBlank(this.constant2))
            assembler.append4Bytes(this.constant2);

        return assembler.over();
    }
}
