package com.jhscale.meter.wifi.entity;

import com.jhscale.common.utils.ASCIIUtils;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.wifi.constant.CommandType;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Arrays;

/**
 * @author lie_w
 * @title: CmdInfo
 * @projectName jhscale-agreement
 * @description: 请求对象
 * @date 2020/6/1714:08
 */
public class CommandRequest extends CommandResponse {

    //
    private byte[] bytes;

    // 内容
    private byte[] content;

    // 加密填充
    private byte[] filling;

    // 加密校验
    private int crc;

    // 是否伪造数据 false 不是伪造 true 是伪造
    private boolean crcr = true;

    // 指令类型
    private CommandType type;

    // 实现类ID
    private String service;

    public CommandRequest() {
    }

    public CommandRequest(byte[] bytes) {
        this.bytes = bytes;
    }

    /**
     * @description: 获取指定字段数组
     **/
    public byte[] lengthData(int length) {
        byte[] bytes = Arrays.copyOfRange(this.content, 0, length);
        this.content = Arrays.copyOfRange(this.content, length, this.content.length);
        return bytes;
    }

    /**
     * @description: 金额转换
     **/
    public BigDecimal bigDecimal() {
        return new BigDecimal(integer(4));
    }

    /**
     * @description: 数值
     **/
    public Integer integer(int length) {
        return Integer.parseInt(ByteUtils.toHexString(ByteUtils.reverse(lengthData(length))), 16);
    }

    /**
     * @description: 获取指定字段的值
     **/
    public String lengthField(int length) {
        String ascii = ByteUtils.toHexAscii(Arrays.copyOfRange(this.content, 0, length));
        this.content = Arrays.copyOfRange(this.content, length, this.content.length);
        return ascii;
    }

    /**
     * @description: 获取定长文本字段的指
     **/
    public String textField(int length) {
        String text = ASCIIUtils.convertHexToString(ByteUtils.toHexAscii(Arrays.copyOfRange(this.content, 0, length)));
        this.content = Arrays.copyOfRange(this.content, length, this.content.length);
        return text;
    }

    /**
     * @description: 获取文本字段的指
     **/
    public String textField() {
        int index = index(this.content, (byte) 0x00);
        String text = ASCIIUtils.convertHexToString(ByteUtils.toHexAscii(Arrays.copyOfRange(this.content, 0, index)));
        this.content = Arrays.copyOfRange(this.content, index + 1, this.content.length);
        return text;
    }

    /**
     * @description: 字符串解析
     **/
    public String text() {
        int index = index(this.content, (byte) 0x00);
        String text;
        try {
            text = new String(Arrays.copyOfRange(this.content, 0, index), super.getEncoding());
        } catch (UnsupportedEncodingException e) {
            System.err.println("商品名字符集解析失败" + e.getMessage());
            text = "Unknow";
        }
        this.content = Arrays.copyOfRange(this.content, index + 1, this.content.length);
        return text;
    }

    /**
     * @description: 获取字节数组中第一个指定字节的位置
     **/
    private int index(byte[] bytes, byte b) {
        for (int i = 0; i < bytes.length; i++) {
            if (bytes[i] == b) return i;
        }
        return -1;
    }

    /**
     * @description: 数字类型解析
     **/
    public Long number(int index) {
        Long number = Long.valueOf(ByteUtils.toHexString(ByteUtils.reverse(Arrays.copyOfRange(this.content, 0, index))), 16);
        this.content = Arrays.copyOfRange(this.content, index, this.content.length);
        return number;
    }

    /**
     * @description: 获取字符数
     **/
    public Character character(int index) {
        char charcter = (char) Integer.valueOf(ByteUtils.toHexString(Arrays.copyOfRange(this.content, 0, index)), 16).intValue();
        this.content = Arrays.copyOfRange(this.content, index, this.content.length);
        return charcter;
    }

    /**
     * @description: 获取内容数据包String 数据
     **/
    public String contentString() {
        return ByteUtils.bytes2HexString(this.content);
    }

    public byte[] getBytes() {
        return bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getContent() {
        return content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public byte[] getFilling() {
        return filling;
    }

    public void setFilling(byte[] filling) {
        this.filling = filling;
    }

    public int getCrc() {
        return crc;
    }

    public void setCrc(int crc) {
        this.crc = crc;
    }

    public boolean isCrcr() {
        return this.crcr;
    }

    public void setCrcr(boolean crcr) {
        this.crcr = crcr;
    }

    public CommandType getType() {
        return type;
    }

    public void setType(CommandType type) {
        this.type = type;
    }

    public String getService() {
        return service;
    }

    public void setService(String service) {
        this.service = service;
    }
}
