package com.jhscale.meter.wifi.entity;

import com.jhscale.common.model.device.data_parameter.DDataParameterV1;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.wifi.constant.CMDConstant;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

import static com.jhscale.common.model.device.DConstant.TMS;

/**
 * @author lie_w
 * @title: Data
 * @projectName jhscale-agreement
 * @description: 数据参数
 * @date 2019/9/1612:12
 */
public class Data extends Content {

    private static final String dSort = "08";

    private String value;

    /**
     * @param charter 字符集
     * @param dCmd    指令类型
     * @param dId     编号
     * @description: 带字符集有参构造指令类型
     */
    public Data(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    /**
     * @param dCmd 指令类型
     * @param dId  编号
     * @description: 默认字符集有参构造指令类型
     */
    public Data(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    /**
     * @description: 默认构造 回收指令
     **/
    public Data() {
        super("", CMDConstant.REQ, dSort, CMDConstant.RECOVER_DID);
    }

    /**
     * @description: 数据解析
     **/
    public Data(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) Base64Utils.ungzipString(dData);
        ContentParse parse = new ContentParse(dData, charter);
        this.value = parse.parseHex();
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public List<String> gtCollectList() {
        return new ArrayList<>();
    }

    @Override
    public String gtDData(String charter) {
        return new ContentAssembler(charter)
                .appendHex(this.value).over();
    }

    @Override
    public boolean canAdd() {
        return super.canAdd() && StringUtils.isNotBlank(this.value) ? true : false;
    }

    /**
     * @description: 数据同步类型key 如  PLU、CLS、SAL
     **/
    @Override
    public String dataKey() {
        return TMS;
    }

    /**
     * @description: 对象转换
     **/
    @Override
    public DataJSONModel toDData() {
        DDataParameterV1 dDataParameter = new DDataParameterV1<>()
                .setNo(this.did());
        try {
            dDataParameter.setValue(StringUtils.isNotBlank(this.value) ? Integer.parseInt(this.value) : 0);
        } catch (NumberFormatException e) {
            dDataParameter.setValue(0);
        }
        return dDataParameter;
    }
}
