package com.jhscale.meter.wifi.entity;

import com.jhscale.meter.wifi.constant.CMDConstant;
import com.jhscale.meter.wifi.model.Content;

import java.util.List;

/**
 * @author lie_w
 * @title: DefaultContent
 * @projectName jhscale-agreement
 * @description: 默认内容段 获取设备信息
 * @date 2020/6/2218:17
 */
public class DefaultContent extends Content {

    private static final String dSort = "255";

    // 4.17.1 秤的硬件信息
    private static final String DEVICE_INFO = "00";

    // 4.17.2 秤的识别信息
    private static final String DEVICE_NICK = "01";

    // 4.17.3 秤的时间信息
    private static final String DEVICE_TIME = "02";

    public DefaultContent() {
        super("", CMDConstant.REQ, dSort, DEVICE_INFO);
    }

    public DefaultContent(String dId) {
        super("", CMDConstant.REQ, dSort, dId);
    }

    /**
     * @description: 浮动标志集合
     **/
    @Override
    public List<String> gtCollectList() {
        return null;
    }

    /**
     * @param charter
     * @description: 数据包
     */
    @Override
    public String gtDData(String charter) {
        return null;
    }
}
