package com.jhscale.meter.wifi.entity;

import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.wifi.constant.CMDConstant;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: Derpartment
 * @projectName jhscale-agreement
 * @description: 部门
 * @date 2019/9/1612:13
 */
public class Derpartment extends Content {

    private static final String dSort = "02";

    private String name;

    /**
     * @param charter 字符集
     * @param dCmd    指令类型
     * @param dId     编号
     * @description: 带字符集有参构造指令类型
     */
    public Derpartment(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    /**
     * @param dCmd 指令类型
     * @param dId  编号
     * @description: 默认字符集有参构造指令类型
     */
    public Derpartment(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    /**
     * @description: 默认构造 回收指令
     **/
    public Derpartment() {
        super("", CMDConstant.REQ, dSort, CMDConstant.RECOVER_DID);
    }

    /**
     * 数据解析
     *
     * @param dId
     * @param dData
     * @param charter
     * @param base64
     */
    public Derpartment(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) Base64Utils.ungzipString(dData);
        ContentParse parse = new ContentParse(dData, charter);
        this.name = parse.parseText();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<String> gtCollectList() {
        return new ArrayList<>();
    }

    @Override
    public String gtDData(String charter) {
        return new ContentAssembler(charter).appendText(this.name).over();
    }
}
