package com.jhscale.meter.wifi.entity;

import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: Goods
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2019/9/1615:16
 */
public class Goods extends Content {

    // 单位
    private String unit;
    // PLU编号
    private String pluNo;
    // 数重量
    private String amount = "0";
    //    private String weigth;          //amount      weight/pcs 数重量
    // 单价
    private String unitPrice = "0";
    //    private String univalent;      //unitPrice
    // 单计
    private String itemTotal = "0";
    //    private String singleMeter;     //itemTotal
    // 商品名
    private String pluName;
//    private String tradeName;       //pluName

    // 组编号
    private String classNo;
    //    private String groupNo;         //classNo
    // 部门编号
    private String deptNo;
    // 成本
    private String cost = "0";
    //    private String costTrade;       //cost
    // 税额
    private String itemTax = "0";
    //    private String amount;          //itemTax
    // 文本1
    private String text1;
    // 文本2
    private String text2;
    // 文本3
    private String text3;
    // 文本4
    private String text4;
    // 日志类型
    private String itemLogType;       //itemLogType

    public Goods() {
    }

    public Goods(ContentParse parse) {
        this.unit = parse.parse1Bytes();
        this.pluNo = parse.parse4Bytes();
        this.amount = parse.parseBigDecimal();
        this.unitPrice = parse.parseBigDecimal();
        this.itemTotal = parse.parseBigDecimal();
        this.pluName = parse.parseText();
        char[] chars = parse.parsefloatData();
        parseFload(chars, parse);
    }

    private void parseFload(char[] chars, ContentParse parse) {
        if (chars[0] == '1') {
            this.classNo = parse.parse2Bytes();
            this.deptNo = parse.parse1Bytes();
        }
        if (chars[1] == '1') this.cost = parse.parseBigDecimal();
        if (chars[2] == '1') this.itemTax = parse.parseBigDecimal();
        if (chars[3] == '1') this.text1 = parse.parseText();
        if (chars[4] == '1') this.text2 = parse.parseText();
        if (chars[5] == '1') this.text3 = parse.parseText();
        if (chars[6] == '1') this.text4 = parse.parseText();
        if (chars[16] == '1') this.itemLogType = parse.parse1Bytes();
    }

    /**
     * @description: 浮动标志集合
     **/
    @Override
    public List<String> gtCollectList() {
        this.collectionList = new ArrayList<>();
        collectionList.add((StringUtils.isNotBlank(this.classNo) ? this.classNo : "") + (StringUtils.isNotBlank(this.deptNo) ? this.deptNo : ""));
        collectionList.add(StringUtils.isNotBlank(this.cost) && !"0".equals(this.cost) ? this.cost : null);
        collectionList.add(StringUtils.isNotBlank(this.itemTax) && !"0".equals(this.itemTax) ? this.itemTax : null);
        collectionList.add(this.text1);
        collectionList.add(this.text2);
        collectionList.add(this.text3);
        collectionList.add(this.text4);
        collectionList.add(this.itemLogType);
        return collectionList;
    }

    /**
     * @param charter
     * @description: 数据包
     */
    @Override
    public String gtDData(String charter) {
        ContentAssembler assembler = new ContentAssembler(charter)
                .append1Bytes(this.unit)
                .append4Bytes(this.pluNo)
                .appendBigDecimal(this.amount)
                .appendBigDecimal(this.unitPrice)
                .appendBigDecimal(this.itemTotal)
                .appendText(this.pluName)
                .append(this.gtFloat());
        if (StringUtils.isNotBlank(this.classNo) && StringUtils.isNotBlank(this.deptNo)) {
            assembler.append2Bytes(this.classNo);
            assembler.append1Bytes(this.deptNo);
        }
        if (StringUtils.isNotBlank(this.cost) && !"0".equals(this.cost)) assembler.appendBigDecimal(this.cost);
        if (StringUtils.isNotBlank(this.itemTax) && !"0".equals(this.itemTax)) assembler.appendBigDecimal(this.itemTax);
        if (StringUtils.isNotBlank(this.text1)) assembler.appendText(this.text1);
        if (StringUtils.isNotBlank(this.text2)) assembler.appendText(this.text2);
        if (StringUtils.isNotBlank(this.text3)) assembler.appendText(this.text3);
        if (StringUtils.isNotBlank(this.text4)) assembler.appendText(this.text4);
        if (StringUtils.isNotBlank(this.itemLogType)) assembler.append1Bytes(this.itemLogType);
        return assembler.over();
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getPluNo() {
        return pluNo;
    }

    public void setPluNo(String pluNo) {
        this.pluNo = pluNo;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
    }

    public String getItemTotal() {
        return itemTotal;
    }

    public void setItemTotal(String itemTotal) {
        this.itemTotal = itemTotal;
    }

    public String getPluName() {
        return pluName;
    }

    public void setPluName(String pluName) {
        this.pluName = pluName;
    }

    public String getClassNo() {
        return classNo;
    }

    public void setClassNo(String classNo) {
        this.classNo = classNo;
    }

    public String getDeptNo() {
        return deptNo;
    }

    public void setDeptNo(String deptNo) {
        this.deptNo = deptNo;
    }

    public String getCost() {
        return cost;
    }

    public void setCost(String cost) {
        this.cost = cost;
    }

    public String getItemTax() {
        return itemTax;
    }

    public void setItemTax(String itemTax) {
        this.itemTax = itemTax;
    }

    public String getText1() {
        return text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    public String getText2() {
        return text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    public String getText3() {
        return text3;
    }

    public void setText3(String text3) {
        this.text3 = text3;
    }

    public String getText4() {
        return text4;
    }

    public void setText4(String text4) {
        this.text4 = text4;
    }

    public String getItemLogType() {
        return itemLogType;
    }

    public void setItemLogType(String itemLogType) {
        this.itemLogType = itemLogType;
    }
}
