package com.jhscale.meter.wifi.entity;

import com.jhscale.common.em.SyncDataType;
import com.jhscale.common.model.device.category.DCategoryV1;
import com.jhscale.common.model.device.plu.module.DPrintV2;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.wifi.constant.CMDConstant;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

import static com.jhscale.common.content.JHContents.DEFAULT_DEPT;
import static com.jhscale.common.model.device.DConstant.ZERO;

/**
 * @author lie_w
 * @title: Group
 * @projectName jhscale-agreement
 * @description: 组别
 * @date 2019/9/1612:17
 */
public class Group extends Content {

    private static final String dSort = "03";

    private String name;
    private String department;

    private String putType1;
    private String barType1;
    private String barSgin1;
    private String putType2;
    private String barType2;
    private String barSgin2;

    /**
     * @param charter 字符集
     * @param dCmd    指令类型
     * @param dId     编号
     * @description: 带字符集有参构造指令类型
     */
    public Group(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    /**
     * @param dCmd 指令类型
     * @param dId  编号
     * @description: 默认字符集有参构造指令类型
     */
    public Group(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    /**
     * @description: 默认构造 回收指令
     **/
    public Group() {
        super("", CMDConstant.REQ, dSort, CMDConstant.RECOVER_DID);
    }

    /**
     * @description: 数据解析
     **/
    public Group(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) Base64Utils.ungzipString(dData);
        ContentParse parse = new ContentParse(dData, charter);
        this.name = parse.parseText();
        this.department = parse.parse1Bytes();
        char[] chars = parse.parsefloatData();
        parseFload(chars, parse);
    }

    private void parseFload(char[] chars, ContentParse parse) {
        if (chars[0] == '1') this.putType1 = parse.parse2Bytes();
        if (chars[1] == '1') this.barType1 = parse.parse2Bytes();
        if (chars[2] == '1') this.barSgin1 = parse.parse2Bytes();
        if (chars[3] == '1') this.putType2 = parse.parse2Bytes();
        if (chars[4] == '1') this.barType2 = parse.parse2Bytes();
        if (chars[5] == '1') this.barSgin2 = parse.parse2Bytes();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDepartment() {
        return department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getPutType1() {
        return putType1;
    }

    public void setPutType1(String putType1) {
        this.putType1 = putType1;
    }

    public String getBarType1() {
        return barType1;
    }

    public void setBarType1(String barType1) {
        this.barType1 = barType1;
    }

    public String getBarSgin1() {
        return barSgin1;
    }

    public void setBarSgin1(String barSgin1) {
        this.barSgin1 = barSgin1;
    }

    public String getPutType2() {
        return putType2;
    }

    public void setPutType2(String putType2) {
        this.putType2 = putType2;
    }

    public String getBarType2() {
        return barType2;
    }

    public void setBarType2(String barType2) {
        this.barType2 = barType2;
    }

    public String getBarSgin2() {
        return barSgin2;
    }

    public void setBarSgin2(String barSgin2) {
        this.barSgin2 = barSgin2;
    }

    @Override
    public List<String> gtCollectList() {
        collectionList.add(putType1);
        collectionList.add(barType1);
        collectionList.add(barSgin1);
        collectionList.add(putType2);
        collectionList.add(barType2);
        collectionList.add(barSgin2);
        return collectionList;
    }

    @Override
    public String gtDData(String charter) {
        ContentAssembler assembler = new ContentAssembler(charter)
                .append(this.name)
                .append1Bytes(this.department)
                .append(gtFloat());
        if (StringUtils.isNotBlank(putType1))
            assembler.append2Bytes(this.putType1);
        if (StringUtils.isNotBlank(barType1))
            assembler.append2Bytes(this.barType1);
        if (StringUtils.isNotBlank(barSgin1))
            assembler.append2Bytes(this.barSgin1);
        if (StringUtils.isNotBlank(putType2))
            assembler.append2Bytes(this.putType2);
        if (StringUtils.isNotBlank(barType2))
            assembler.append2Bytes(this.barType2);
        if (StringUtils.isNotBlank(barSgin2))
            assembler.append2Bytes(this.barSgin2);
        return assembler.over();
    }

    /**
     * @description: 数据同步类型key 如  PLU、CLS、SAL
     **/
    @Override
    public String dataKey() {
        return SyncDataType.CLS.getType();
    }

    /**
     * @description: 对象转换
     **/
    @Override
    public DataJSONModel toDData() {
        return new DCategoryV1<DCategoryV1>()
                .setNo(this.did())
                .setName(name)
                .setDept(StringUtils.isBlank(department) ? DEFAULT_DEPT : Integer.parseInt(department))
                .setPrint(new DPrintV2()
                        .setType1(StringUtils.isBlank(putType1) ? ZERO : Integer.parseInt(putType1))
                        .setBarcode1(StringUtils.isBlank(barType1) ? ZERO : Integer.parseInt(barType1))
                        .setSign1(StringUtils.isBlank(barSgin1) ? ZERO : Integer.parseInt(barSgin1))
                        .setType2(StringUtils.isBlank(putType2) ? ZERO : Integer.parseInt(putType2))
                        .setBarcode2(StringUtils.isBlank(barType2) ? ZERO : Integer.parseInt(barType2))
                        .setSign2(StringUtils.isBlank(barSgin2) ? ZERO : Integer.parseInt(barSgin2)));
    }
}
