package com.jhscale.meter.wifi.entity;

import com.jhscale.common.em.BarcodeScale;
import com.jhscale.common.em.SyncDataType;
import com.jhscale.common.model.device.shortkey.DShortKeyV1;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.meter.wifi.constant.CMDConstant;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: Keyboard
 * @projectName jhscale-agreement
 * @description: 快捷键
 * @date 2019/9/1612:18
 */
public class Keyboard extends Content {

    private static final String dSort = "10";

    private String value;

    /**
     * @param charter 字符集
     * @param dCmd    指令类型
     * @param dId     编号
     * @description: 带字符集有参构造指令类型
     */
    public Keyboard(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    /**
     * @param dCmd 指令类型
     * @param dId  编号
     * @description: 默认字符集有参构造指令类型
     */
    public Keyboard(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    /**
     * @description: 默认构造 回收指令
     **/
    public Keyboard() {
        super("", CMDConstant.REQ, dSort, CMDConstant.RECOVER_DID);
    }

    /**
     * @description: 数据解析
     **/
    public Keyboard(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) Base64Utils.ungzipString(dData);
        ContentParse parse = new ContentParse(dData, charter);
        this.value = parse.parseHex();
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public List<String> gtCollectList() {
        return new ArrayList<>();
    }

    @Override
    public String gtDData(String charter) {
        return new ContentAssembler(charter).appendHex(this.value).over();
    }

    /**
     * @description: 数据同步类型key 如  PLU、CLS、SAL
     **/
    @Override
    public String dataKey() {
        return SyncDataType.SCP.getType();
    }

    /**
     * @description: 对象转换
     **/
    @Override
    public DataJSONModel toDData() {
        String hexVal = ByteUtils.appendFill(Integer.toHexString(this.did()), 4);
        return new DShortKeyV1<DShortKeyV1>()
                .setNo(1)
                .setPage(Integer.parseInt(hexVal.substring(0, 2), 16))
                .setIndex(Integer.parseInt(hexVal.substring(2, 4), 16))
                .setPlu(Integer.parseInt(this.value))
                .setName("Short_Key")
                .setBoard(BarcodeScale.KAB.getFtBoard());
    }
}
