package com.jhscale.meter.wifi.entity;

import com.alibaba.fastjson.JSON;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.utils.Constant;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import com.jhscale.meter.wifi.model.WifiCmdUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: Log
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2019/9/1615:12
 */
public class Log extends Content {

    // 最终交易时间
    private Date reviseTime;
    // 修正状态 // 0未修正；1修正
    private String reviseFlag = Constant.DATA_UNREVISE;
    //未知支付标识
    private String unknowPay = Constant.KNOW_PAY;

    // 设备fid
    private String fid;

    // 交易时间
    private Date date;
    // SID
    private String sid;
    // 实际交易额
    private String total = "0";
    //    private String money;   //total
    // 日志类型(增加)
    // 0:销售;1:退货;2:未确认;
    //3:清除;4:挂单;5:自动模式;
    //6~9:预留;10:入库;11:出库;
    //12:盘库;13:订单;14:损耗
    //255:错误日志
    private String logType;
    // 累计数
    private String number = "0";
    // 现金
    private String cash = "0";

    // 营业员编号
    private String saleman;
    //    private String shopManId;   //saleman
    // 折舍金额
    private String roudingDiscount = "0";
    // 税额
    private String tax = "0";
    //    private String cesse;           //tax
    // 成本
    private String cost = "0";
    // 卡付
    private String cardPay = "0";
    //    private String cardPayment;     //cardPay
    // 其他支付1
    private String otherPay1 = "0";
    // 其他支付2
    private String otherPay2 = "0";
    // 其他支付3
    private String otherPay3 = "0";
    // 服务费
    private String serviceCharge = "0";
    // CoFID
    private String coFid;
    // 支付宝
    private String aliPay = "0";
    // 微信支付
    private String weixinPay = "0";
    // 特殊支付2(预留) 吉卡云消费
    private String specialPay2 = "0";
    // 特殊支付3(预留) 吉卡云赠送金额消费
    private String specialPay3 = "0";
    // 特殊支付4(预留)
    private String specialPay4 = "0";
    // 特殊支付5(预留)
    private String specialPay5 = "0";
    // 特殊支付6(预留)
    private String specialPay6 = "0";
    // 特殊支付7(预留)
    private String specialPay7 = "0";
    // 错误代码
    private String errCode;
    // 错误文本1
    private String errMsg1;
    // 错误文本2
    private String errMsg2;
    // 错误文本3
    private String errMsg3;
    // 错误文本4
    private String errMsg4;
    // 吉卡云消费金额
    private String jkyPay = "0";
    // 吉卡云赠送支付
    private String jkyGiftPay = "0";
    //    private String jkyGivePay;      //jkyGiftPay
    // 充值金额
    private String jkyRecharge = "0";
    //    private String recharge;        //jkyRecharge
    // 充值赠送
    private String jkyRechargeGift = "0";
//    private String giveRecharge;       //jkyRechargeGift

    private List<Goods> goodsList;

    public Log() {
    }

    @Override
    public String toString() {
        return "Log{" +
                "reviseTime=" + (Objects.nonNull(this.reviseTime) ? DateFormatUtils.format(reviseTime, "yyyy-MM-dd HH:mm:ss") : "暂无") +
                ", reviseFlag='" + reviseFlag + '\'' +
                ", unknowPay='" + unknowPay + '\'' +
                ", fid='" + fid + '\'' +
                ", date=" + DateFormatUtils.format(date, "yyyy-MM-dd HH:mm:ss") +
                ", sid='" + sid + '\'' +
                ", total='" + total + '\'' +
                ", logType='" + logType + '\'' +
                ", number='" + number + '\'' +
                ", cash='" + cash + '\'' +
                ", saleman='" + saleman + '\'' +
                ", roudingDiscount='" + roudingDiscount + '\'' +
                ", tax='" + tax + '\'' +
                ", cost='" + cost + '\'' +
                ", cardPay='" + cardPay + '\'' +
                ", otherPay1='" + otherPay1 + '\'' +
                ", otherPay2='" + otherPay2 + '\'' +
                ", otherPay3='" + otherPay3 + '\'' +
                ", serviceCharge='" + serviceCharge + '\'' +
                ", coFid='" + coFid + '\'' +
                ", aliPay='" + aliPay + '\'' +
                ", weixinPay='" + weixinPay + '\'' +
                ", specialPay2='" + specialPay2 + '\'' +
                ", specialPay3='" + specialPay3 + '\'' +
                ", specialPay4='" + specialPay4 + '\'' +
                ", specialPay5='" + specialPay5 + '\'' +
                ", specialPay6='" + specialPay6 + '\'' +
                ", specialPay7='" + specialPay7 + '\'' +
                ", errCode='" + errCode + '\'' +
                ", errMsg1='" + errMsg1 + '\'' +
                ", errMsg2='" + errMsg2 + '\'' +
                ", errMsg3='" + errMsg3 + '\'' +
                ", errMsg4='" + errMsg4 + '\'' +
                ", jkyPay='" + jkyPay + '\'' +
                ", jkyGiftPay='" + jkyGiftPay + '\'' +
                ", jkyRecharge='" + jkyRecharge + '\'' +
                ", jkyRechargeGift='" + jkyRechargeGift + '\'' +
                ", goodsList=" + JSON.toJSONString(goodsList) +
                '}';
    }

    /**
     * @param did     FID
     * @param dData   数据信息
     * @param charset 字符集
     * @param base64  是否base 64 true 是 false 否
     */
    public Log(String did, String dData, String charset, boolean base64) {
        if (StringUtils.isBlank(charset) || Constant.COMPATIBLE_CHARSET.equalsIgnoreCase(charset)) {
            charset = Constant.DEFAULT_CHARSET;
        }
        this.fid = did;
        if (base64) dData = Base64Utils.ungzipString(dData);
        ContentParse parse = new ContentParse(dData, charset);
        this.date = parse.parseDate();
        this.sid = parse.parse4Bytes();
        this.total = parse.parseBigDecimal();
        this.logType = parse.parse1Bytes();
        this.number = parse.parse1Bytes();
        char[] chars = parse.parsefloatData();
        parseFload(chars, parse);
        List<Goods> goodsList = WifiCmdUtils.getGoodsList(parse, Integer.parseInt(this.number));
        this.goodsList = goodsList;
    }

    /**
     * @param dId
     * @param dData
     * @param charset
     * @param upload   上传时间毫秒数
     * @param lastHeat 最后心跳时间毫秒数
     */
    public Log(String dId, String dData, String charset, boolean base64, long upload, long lastHeat) {
        this(dId, dData, charset, base64);
        if (lastHeat == 0) {
            if (this.date.getTime() > upload) {
                reviseTime = new Date(upload);
                reviseFlag = Constant.DATE_REVISE;
            } else {
                reviseTime = this.date;
            }
        } else {
            if (this.date.getTime() < lastHeat || this.date.getTime() > upload) {
                reviseTime = new Date(lastHeat);
                reviseFlag = Constant.DATE_REVISE;
            } else {
                reviseTime = this.date;
            }
        }
    }

    private void parseFload(char[] chars, ContentParse parse) {
        if (chars[0] == '1') {
            try {
                this.saleman = parse.parse4Bytes();
            } catch (Exception e) {
                this.saleman = "0";
            }
        }
        if (chars[1] == '1') this.roudingDiscount = parse.parseBigDecimal();
        if (chars[2] == '1') this.tax = parse.parseBigDecimal();
        if (chars[3] == '1') this.cost = parse.parseBigDecimal();
        if (chars[4] == '1') this.cardPay = parse.parseBigDecimal();
        if (chars[5] == '1') this.otherPay1 = parse.parseBigDecimal();
        if (chars[6] == '1') this.otherPay2 = parse.parseBigDecimal();
        if (chars[16] == '1') this.otherPay3 = parse.parseBigDecimal();
        if (chars[17] == '1') this.serviceCharge = parse.parseBigDecimal();
        if (chars[18] == '1') this.coFid = parse.parse4Bytes();
        if (chars[19] == '1') this.aliPay = parse.parseBigDecimal();
        if (chars[20] == '1') this.weixinPay = parse.parseBigDecimal();
        if (chars[21] == '1') this.specialPay2 = parse.parseBigDecimal();
        if (chars[22] == '1') this.specialPay3 = parse.parseBigDecimal();
        if (chars[23] == '1') this.specialPay4 = parse.parseBigDecimal();
        if (chars[24] == '1') this.specialPay5 = parse.parseBigDecimal();
        if (chars[25] == '1') this.specialPay6 = parse.parseBigDecimal();
        if (chars[26] == '1') this.specialPay7 = parse.parseBigDecimal();
        if (chars[27] == '1') {
            this.errCode = parse.parse4Bytes();
            if (StringUtils.isNotBlank(this.errCode) && (this.errCode.equals(Constant.PAY_ERR_HEX_CODE) || this.errCode.equals(Constant.PAY_ERR_CODE))) {
                this.unknowPay = Constant.UNKNOW_PAY;
            }
        }
        if (chars[28] == '1') this.errMsg1 = parse.parseText();
        if (chars[29] == '1') this.errMsg2 = parse.parseText();
        if (chars[30] == '1') this.errMsg3 = parse.parseText();
        if (chars[31] == '1') this.errMsg4 = parse.parseText();
        if (chars[32] == '1') this.jkyRecharge = parse.parseBigDecimal();
        if (chars[33] == '1') this.jkyRechargeGift = parse.parseBigDecimal();
        if (chars[34] == '1') this.jkyPay = parse.parseBigDecimal();
        if (chars[35] == '1') this.jkyGiftPay = parse.parseBigDecimal();
    }

    @Override
    public List<String> gtCollectList() {
        this.collectionList = new ArrayList<>();
        collectionList.add(saleman);
        collectionList.add(StringUtils.isNotBlank(this.roudingDiscount) && !"0".equals(this.roudingDiscount) ? this.roudingDiscount : null);
        collectionList.add(StringUtils.isNotBlank(this.tax) && !"0".equals(this.tax) ? this.tax : null);
        collectionList.add(StringUtils.isNotBlank(this.cost) && !"0".equals(this.cost) ? this.cost : null);
        collectionList.add(StringUtils.isNotBlank(this.cardPay) && !"0".equals(this.cardPay) ? this.cardPay : null);
        collectionList.add(StringUtils.isNotBlank(this.otherPay1) && !"0".equals(this.otherPay1) ? this.otherPay1 : null);
        collectionList.add(StringUtils.isNotBlank(this.otherPay2) && !"0".equals(this.otherPay2) ? this.otherPay2 : null);
        collectionList.add(StringUtils.isNotBlank(this.otherPay3) && !"0".equals(this.otherPay3) ? this.otherPay3 : null);
        collectionList.add(StringUtils.isNotBlank(this.otherPay3) && !"0".equals(this.otherPay3) ? this.otherPay3 : null);
        collectionList.add(coFid);
        collectionList.add(StringUtils.isNotBlank(this.aliPay) && !"0".equals(this.aliPay) ? this.aliPay : null);
        collectionList.add(StringUtils.isNotBlank(this.weixinPay) && !"0".equals(this.weixinPay) ? this.weixinPay : null);
        collectionList.add(StringUtils.isNotBlank(this.specialPay2) && !"0".equals(this.specialPay2) ? this.specialPay2 : null);
        collectionList.add(StringUtils.isNotBlank(this.specialPay3) && !"0".equals(this.specialPay3) ? this.specialPay3 : null);
        collectionList.add(StringUtils.isNotBlank(this.specialPay4) && !"0".equals(this.specialPay4) ? this.specialPay4 : null);
        collectionList.add(StringUtils.isNotBlank(this.specialPay5) && !"0".equals(this.specialPay5) ? this.specialPay5 : null);
        collectionList.add(StringUtils.isNotBlank(this.specialPay6) && !"0".equals(this.specialPay6) ? this.specialPay6 : null);
        collectionList.add(StringUtils.isNotBlank(this.specialPay7) && !"0".equals(this.specialPay7) ? this.specialPay7 : null);
        collectionList.add(errCode);
        collectionList.add(errMsg1);
        collectionList.add(errMsg2);
        collectionList.add(errMsg3);
        collectionList.add(errMsg4);
        collectionList.add(StringUtils.isNotBlank(this.jkyPay) && !"0".equals(this.jkyPay) ? this.jkyPay : null);
        collectionList.add(StringUtils.isNotBlank(this.jkyGiftPay) && !"0".equals(this.jkyGiftPay) ? this.jkyGiftPay : null);
        collectionList.add(StringUtils.isNotBlank(this.jkyRecharge) && !"0".equals(this.jkyRecharge) ? this.jkyRecharge : null);
        collectionList.add(StringUtils.isNotBlank(this.jkyRechargeGift) && !"0".equals(this.jkyRechargeGift) ? this.jkyRechargeGift : null);
        return collectionList;
    }

    @Override
    public String gtDData(String charter) {
        ContentAssembler assembler = new ContentAssembler(charter)
                .append(this.date)
                .append4Bytes(this.sid)
                .appendBigDecimal(this.total)
                .append1Bytes(this.logType)
                .append1Bytes(this.goodsList != null ? this.goodsList.size() : 0)
                .append(gtFloat());

        if (StringUtils.isNotBlank(this.saleman)) assembler.append4Bytes(this.saleman);
        if (StringUtils.isNotBlank(this.roudingDiscount) && !"0".equals(this.roudingDiscount))
            assembler.appendBigDecimal(this.roudingDiscount);
        if (StringUtils.isNotBlank(this.tax) && !"0".equals(this.tax)) assembler.appendBigDecimal(this.tax);
        if (StringUtils.isNotBlank(this.cost) && !"0".equals(this.cost)) assembler.appendBigDecimal(this.cost);
        if (StringUtils.isNotBlank(this.cardPay) && !"0".equals(this.cardPay)) assembler.appendBigDecimal(this.cardPay);
        if (StringUtils.isNotBlank(this.otherPay1) && !"0".equals(this.otherPay1))
            assembler.appendBigDecimal(this.otherPay1);
        if (StringUtils.isNotBlank(this.otherPay2) && !"0".equals(this.otherPay2))
            assembler.appendBigDecimal(this.otherPay2);
        if (StringUtils.isNotBlank(this.otherPay3) && !"0".equals(this.otherPay3))
            assembler.appendBigDecimal(this.otherPay3);
        if (StringUtils.isNotBlank(this.serviceCharge) && !"0".equals(this.serviceCharge))
            assembler.appendBigDecimal(this.serviceCharge);
        if (StringUtils.isNotBlank(this.coFid)) assembler.append4Bytes(this.coFid);
        if (StringUtils.isNotBlank(this.aliPay) && !"0".equals(this.aliPay)) assembler.appendBigDecimal(this.aliPay);
        if (StringUtils.isNotBlank(this.weixinPay) && !"0".equals(this.weixinPay))
            assembler.appendBigDecimal(this.weixinPay);
        if (StringUtils.isNotBlank(this.specialPay2) && !"0".equals(this.specialPay2))
            assembler.appendBigDecimal(this.specialPay2);
        if (StringUtils.isNotBlank(this.specialPay3) && !"0".equals(this.specialPay3))
            assembler.appendBigDecimal(this.specialPay3);
        if (StringUtils.isNotBlank(this.specialPay4) && !"0".equals(this.specialPay4))
            assembler.appendBigDecimal(this.specialPay4);
        if (StringUtils.isNotBlank(this.specialPay5) && !"0".equals(this.specialPay5))
            assembler.appendBigDecimal(this.specialPay5);
        if (StringUtils.isNotBlank(this.specialPay6) && !"0".equals(this.specialPay6))
            assembler.appendBigDecimal(this.specialPay6);
        if (StringUtils.isNotBlank(this.specialPay7) && !"0".equals(this.specialPay7))
            assembler.appendBigDecimal(this.specialPay7);
        if (StringUtils.isNotBlank(this.errCode)) assembler.append4Bytes(this.errCode);
        if (StringUtils.isNotBlank(this.errMsg1)) assembler.appendText(this.errMsg1);
        if (StringUtils.isNotBlank(this.errMsg2)) assembler.appendText(this.errMsg2);
        if (StringUtils.isNotBlank(this.errMsg3)) assembler.appendText(this.errMsg3);
        if (StringUtils.isNotBlank(this.errMsg4)) assembler.appendText(this.errMsg4);
        if (StringUtils.isNotBlank(this.jkyRecharge) && !"0".equals(this.jkyRecharge))
            assembler.appendBigDecimal(this.jkyRecharge);
        if (StringUtils.isNotBlank(this.jkyRechargeGift) && !"0".equals(this.jkyRechargeGift))
            assembler.appendBigDecimal(this.jkyRechargeGift);
        if (StringUtils.isNotBlank(this.jkyPay) && !"0".equals(this.jkyPay)) assembler.appendBigDecimal(this.jkyPay);
        if (StringUtils.isNotBlank(this.jkyGiftPay) && !"0".equals(this.jkyGiftPay))
            assembler.appendBigDecimal(this.jkyGiftPay);

        if (this.goodsList != null && !this.goodsList.isEmpty()) {
            for (Goods goods : this.goodsList) {
                assembler.append(goods.gtDData(charter));
            }
        }
        return assembler.over();
    }

    public Date getReviseTime() {
        return reviseTime;
    }

    public void setReviseTime(Date reviseTime) {
        this.reviseTime = reviseTime;
    }

    public String getReviseFlag() {
        return reviseFlag;
    }

    public void setReviseFlag(String reviseFlag) {
        this.reviseFlag = reviseFlag;
    }

    public String getUnknowPay() {
        return unknowPay;
    }

    public void setUnknowPay(String unknowPay) {
        this.unknowPay = unknowPay;
    }

    public String getFid() {
        return fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getSid() {
        return sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getTotal() {
        return total;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public String getLogType() {
        return logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getCash() {
        if (StringUtils.isBlank(cash) || "0".equals(cash)) {
            cash = new BigDecimal(getTotal())
                    .subtract(new BigDecimal(getOtherPay1()))
                    .subtract(new BigDecimal(getOtherPay2()))
                    .subtract(new BigDecimal(getOtherPay3()))
                    .subtract(new BigDecimal(getServiceCharge()))
                    .subtract(new BigDecimal(getAliPay()))
                    .subtract(new BigDecimal(getWeixinPay()))
                    .subtract(new BigDecimal(getSpecialPay2()))
                    .subtract(new BigDecimal(getSpecialPay3()))
                    .subtract(new BigDecimal(getSpecialPay4()))
                    .subtract(new BigDecimal(getSpecialPay5()))
                    .subtract(new BigDecimal(getSpecialPay6()))
                    .subtract(new BigDecimal(getSpecialPay7()))
                    .subtract(new BigDecimal(getJkyPay()))
                    .subtract(new BigDecimal(getJkyGiftPay()))
                    .subtract(new BigDecimal(getCardPay())).toString();
        }
        return cash;
    }

    public void setCash(String cash) {
        this.cash = cash;
    }

    public String getSaleman() {
        return saleman;
    }

    public void setSaleman(String saleman) {
        this.saleman = saleman;
    }

    public String getRoudingDiscount() {
        return roudingDiscount;
    }

    public void setRoudingDiscount(String roudingDiscount) {
        this.roudingDiscount = roudingDiscount;
    }

    public String getTax() {
        return tax;
    }

    public void setTax(String tax) {
        this.tax = tax;
    }

    public String getCost() {
        return cost;
    }

    public void setCost(String cost) {
        this.cost = cost;
    }

    public String getCardPay() {
        return cardPay;
    }

    public void setCardPay(String cardPay) {
        this.cardPay = cardPay;
    }

    public String getOtherPay1() {
        return otherPay1;
    }

    public void setOtherPay1(String otherPay1) {
        this.otherPay1 = otherPay1;
    }

    public String getOtherPay2() {
        return otherPay2;
    }

    public void setOtherPay2(String otherPay2) {
        this.otherPay2 = otherPay2;
    }

    public String getOtherPay3() {
        return otherPay3;
    }

    public void setOtherPay3(String otherPay3) {
        this.otherPay3 = otherPay3;
    }

    public String getServiceCharge() {
        return serviceCharge;
    }

    public void setServiceCharge(String serviceCharge) {
        this.serviceCharge = serviceCharge;
    }

    public String getCoFid() {
        return coFid;
    }

    public void setCoFid(String coFid) {
        this.coFid = coFid;
    }

    public String getAliPay() {
        return aliPay;
    }

    public void setAliPay(String aliPay) {
        this.aliPay = aliPay;
    }

    public String getWeixinPay() {
        return weixinPay;
    }

    public void setWeixinPay(String weixinPay) {
        this.weixinPay = weixinPay;
    }

    public String getSpecialPay2() {
        return specialPay2;
    }

    public void setSpecialPay2(String specialPay2) {
        this.specialPay2 = specialPay2;
    }

    public String getSpecialPay3() {
        return specialPay3;
    }

    public void setSpecialPay3(String specialPay3) {
        this.specialPay3 = specialPay3;
    }

    public String getSpecialPay4() {
        return specialPay4;
    }

    public void setSpecialPay4(String specialPay4) {
        this.specialPay4 = specialPay4;
    }

    public String getSpecialPay5() {
        return specialPay5;
    }

    public void setSpecialPay5(String specialPay5) {
        this.specialPay5 = specialPay5;
    }

    public String getSpecialPay6() {
        return specialPay6;
    }

    public void setSpecialPay6(String specialPay6) {
        this.specialPay6 = specialPay6;
    }

    public String getSpecialPay7() {
        return specialPay7;
    }

    public void setSpecialPay7(String specialPay7) {
        this.specialPay7 = specialPay7;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg1() {
        return errMsg1;
    }

    public void setErrMsg1(String errMsg1) {
        this.errMsg1 = errMsg1;
    }

    public String getErrMsg2() {
        return errMsg2;
    }

    public void setErrMsg2(String errMsg2) {
        this.errMsg2 = errMsg2;
    }

    public String getErrMsg3() {
        return errMsg3;
    }

    public void setErrMsg3(String errMsg3) {
        this.errMsg3 = errMsg3;
    }

    public String getErrMsg4() {
        return errMsg4;
    }

    public void setErrMsg4(String errMsg4) {
        this.errMsg4 = errMsg4;
    }

    public String getJkyPay() {
        return jkyPay;
    }

    public void setJkyPay(String jkyPay) {
        this.jkyPay = jkyPay;
    }

    public String getJkyGiftPay() {
        return jkyGiftPay;
    }

    public void setJkyGiftPay(String jkyGiftPay) {
        this.jkyGiftPay = jkyGiftPay;
    }

    public String getJkyRecharge() {
        return jkyRecharge;
    }

    public void setJkyRecharge(String jkyRecharge) {
        this.jkyRecharge = jkyRecharge;
    }

    public String getJkyRechargeGift() {
        return jkyRechargeGift;
    }

    public void setJkyRechargeGift(String jkyRechargeGift) {
        this.jkyRechargeGift = jkyRechargeGift;
    }

    public List<Goods> getGoodsList() {
        return goodsList;
    }

    public void setGoodsList(List<Goods> goodsList) {
        this.goodsList = goodsList;
    }
}
