package com.jhscale.meter.wifi.entity;

import com.jhscale.common.em.SyncDataType;
import com.jhscale.common.model.device.DConstant;
import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.inner.DAutoDiscountV2;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DPrintWithBitMapV1;
import com.jhscale.common.model.device.plu.module.DTextV1;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.common.ysscale.UnitEnum;
import com.jhscale.meter.wifi.constant.CMDConstant;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: PLU
 * @projectName jhscale-agreement
 * @description: PLU
 * @date 2019/9/1612:20
 */
public class PLU extends Content {

    private static final String dSort = "04";

    private String name;
    private String weight;
    private String price;

    private String number;
    private String indexBar;
    private String useDatePut;
    private String useDateData;
    private String costTrade;
    private String trae;
    private String group;
    private String putType1;
    private String barNo1;
    private String barType1;
    private String putType2;
    private String barNo2;
    private String barType2;
    private String text1;
    private String text2;
    private String text3;
    private String text4;
    private String text5;
    private String text6;
    private String text7;
    private String taxType;
    private String taxExtreme;
    private String picNo;
    private String saleDatePut;
    private String saleDateData;
    private String saleTimePut;
    private String saleTimeData;
    private String packDatePut;
    private String packDateData;
    private String packTimePut;
    private String packTimeData;
    private String manualDiscountLower;
    private String manualDiscountLowerValue;
    private String manualDiscountUpper;
    private String manualDiscountUpperValue;
    private String customDiscount0Type;
    private String customDiscount0UseDate;
    private String customDiscount0Lower;
    private String customDiscount0Upper;
    private String customDiscount0Value;
    private String customDiscount1Type;
    private String customDiscount1UseDate;
    private String customDiscount1Lower;
    private String customDiscount1Upper;
    private String customDiscount1Value;
    private String customDiscount2Type;
    private String customDiscount2UseDate;
    private String customDiscount2Lower;
    private String customDiscount2Upper;
    private String customDiscount2Value;
    private String customDiscount3Type;
    private String customDiscount3UseDate;
    private String customDiscount3Lower;
    private String customDiscount3Upper;
    private String customDiscount3Value;
    private Integer sspValue1;
    private Integer sspValue2;
    private Integer sspValue3;
    private Integer sspValue4;
    private String pluType;
    private String pluSign;
    private String pluSignValue;
    private String pingYinSearch;

    /**
     * @param charter 字符集
     * @param dCmd    指令类型
     * @param dId     编号
     * @description: 带字符集有参构造指令类型
     */
    public PLU(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    /**
     * @param dCmd 指令类型
     * @param dId  编号
     * @description: 默认字符集有参构造指令类型
     */
    public PLU(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    /**
     * @description: 默认构造 回收指令
     **/
    public PLU() {
        super("", CMDConstant.REQ, dSort, CMDConstant.RECOVER_DID);
    }

    /**
     * @description: 数据解析
     **/
    public PLU(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) Base64Utils.ungzipString(dData);
        ContentParse parse = new ContentParse(dData, charter);
        this.name = parse.parseText();
        this.weight = parse.parse1Bytes();
        this.price = parse.parseBigDecimal();
        char[] chars = parse.parsefloatData();
        parseFload(chars, parse);
    }

    private void parseFload(char[] chars, ContentParse parse) {
        if (chars[0] == '1') this.number = parse.parse4Bytes();
        if (chars[1] == '1') this.indexBar = parse.parseText();
        if (chars[2] == '1') {
            this.useDatePut = parse.parse1Bytes();
            this.useDateData = parse.parse2Bytes();
        }
        if (chars[3] == '1') this.costTrade = parse.parseBigDecimal();
        if (chars[4] == '1') this.trae = parse.parseBigDecimal();
        if (chars[5] == '1') this.group = parse.parse2Bytes();
        if (chars[6] == '1') this.putType1 = parse.parse2Bytes();
        if (chars[16] == '1') this.barNo1 = parse.parse2Bytes();
        if (chars[17] == '1') this.barType1 = parse.parse2Bytes();
        if (chars[18] == '1') this.putType2 = parse.parse2Bytes();
        if (chars[19] == '1') this.barNo2 = parse.parse2Bytes();
        if (chars[20] == '1') this.barType2 = parse.parse2Bytes();
        if (chars[21] == '1') this.text1 = parse.parseText();
        if (chars[22] == '1') this.text2 = parse.parseText();
        if (chars[23] == '1') this.text3 = parse.parseText();
        if (chars[24] == '1') this.text4 = parse.parseText();
        if (chars[25] == '1') this.text5 = parse.parseText();
        if (chars[26] == '1') this.text6 = parse.parseText();
        if (chars[27] == '1') this.text7 = parse.parseText();
        if (chars[28] == '1') {
            this.taxType = parse.parse1Bytes();
            this.taxExtreme = parse.parse4Bytes();
        }
        if (chars[29] == '1') this.picNo = parse.parse2Bytes();
        if (chars[30] == '1') {
            this.saleDatePut = parse.parse1Bytes();
            this.saleDateData = parse.parse2Bytes();
        }
        if (chars[31] == '1') {
            this.saleTimePut = parse.parse1Bytes();
            this.saleTimeData = parse.parse2Bytes();
        }
        if (chars[32] == '1') {
            this.packDatePut = parse.parse1Bytes();
            this.packDateData = parse.parse2Bytes();
        }
        if (chars[33] == '1') {
            this.packTimePut = parse.parse1Bytes();
            this.packTimeData = parse.parse2Bytes();
        }
        if (chars[34] == '1') {
            this.manualDiscountLower = parse.parse1Bytes();
            this.manualDiscountLowerValue = parse.parseBigDecimal();
        }
        if (chars[35] == '1') {
            this.manualDiscountUpper = parse.parse1Bytes();
            this.manualDiscountUpperValue = parse.parseBigDecimal();
        }
        if (chars[36] == '1') {
            this.customDiscount0Type = parse.parse1Bytes();
            this.customDiscount0UseDate = parse.parse1Bytes();
            this.customDiscount0Lower = parse.parseBigDecimal();
            this.customDiscount0Upper = parse.parseBigDecimal();
            this.customDiscount0Value = parse.parseBigDecimal();
        }
        if (chars[37] == '1') {
            this.customDiscount1Type = parse.parse1Bytes();
            this.customDiscount1UseDate = parse.parse1Bytes();
            this.customDiscount1Lower = parse.parseBigDecimal();
            this.customDiscount1Upper = parse.parseBigDecimal();
            this.customDiscount1Value = parse.parseBigDecimal();
        }
        if (chars[38] == '1') {
            this.customDiscount2Type = parse.parse1Bytes();
            this.customDiscount2UseDate = parse.parse1Bytes();
            this.customDiscount2Lower = parse.parseBigDecimal();
            this.customDiscount2Upper = parse.parseBigDecimal();
            this.customDiscount2Value = parse.parseBigDecimal();
        }
        if (chars[39] == '1') {
            this.customDiscount3Type = parse.parse1Bytes();
            this.customDiscount3UseDate = parse.parse1Bytes();
            this.customDiscount3Lower = parse.parseBigDecimal();
            this.customDiscount3Upper = parse.parseBigDecimal();
            this.customDiscount3Value = parse.parseBigDecimal();
        }
        if (chars[40] == '1') this.sspValue1 = parse.parse4Integer();
        if (chars[41] == '1') this.sspValue2 = parse.parse4Integer();
        if (chars[42] == '1') this.sspValue3 = parse.parse4Integer();
        if (chars[43] == '1') this.sspValue4 = parse.parse4Integer();
        if (chars[44] == '1') this.pluType = parse.parse1Bytes();
        if (chars[45] == '1') this.pluSign = parse.parse2Bytes();
        if (chars[46] == '1') this.pluSignValue = parse.parse4Bytes();
        if (chars[47] == '1') this.pingYinSearch = parse.parseText();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getIndexBar() {
        return indexBar;
    }

    public void setIndexBar(String indexBar) {
        this.indexBar = indexBar;
    }

    public String getUseDatePut() {
        return useDatePut;
    }

    public void setUseDatePut(String useDatePut) {
        this.useDatePut = useDatePut;
    }

    public String getUseDateData() {
        return useDateData;
    }

    public void setUseDateData(String useDateData) {
        this.useDateData = useDateData;
    }

    public String getCostTrade() {
        return costTrade;
    }

    public void setCostTrade(String costTrade) {
        this.costTrade = costTrade;
    }

    public String getTrae() {
        return trae;
    }

    public void setTrae(String trae) {
        this.trae = trae;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getPutType1() {
        return putType1;
    }

    public void setPutType1(String putType1) {
        this.putType1 = putType1;
    }

    public String getBarNo1() {
        return barNo1;
    }

    public void setBarNo1(String barNo1) {
        this.barNo1 = barNo1;
    }

    public String getBarType1() {
        return barType1;
    }

    public void setBarType1(String barType1) {
        this.barType1 = barType1;
    }

    public String getPutType2() {
        return putType2;
    }

    public void setPutType2(String putType2) {
        this.putType2 = putType2;
    }

    public String getBarNo2() {
        return barNo2;
    }

    public void setBarNo2(String barNo2) {
        this.barNo2 = barNo2;
    }

    public String getBarType2() {
        return barType2;
    }

    public void setBarType2(String barType2) {
        this.barType2 = barType2;
    }

    public String getText1() {
        return text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    public String getText2() {
        return text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    public String getText3() {
        return text3;
    }

    public void setText3(String text3) {
        this.text3 = text3;
    }

    public String getText4() {
        return text4;
    }

    public void setText4(String text4) {
        this.text4 = text4;
    }

    public String getText5() {
        return text5;
    }

    public void setText5(String text5) {
        this.text5 = text5;
    }

    public String getText6() {
        return text6;
    }

    public void setText6(String text6) {
        this.text6 = text6;
    }

    public String getText7() {
        return text7;
    }

    public void setText7(String text7) {
        this.text7 = text7;
    }

    public String getTaxType() {
        return taxType;
    }

    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }

    public String getTaxExtreme() {
        return taxExtreme;
    }

    public void setTaxExtreme(String taxExtreme) {
        this.taxExtreme = taxExtreme;
    }

    public String getPicNo() {
        return picNo;
    }

    public void setPicNo(String picNo) {
        this.picNo = picNo;
    }

    public String getSaleDatePut() {
        return saleDatePut;
    }

    public void setSaleDatePut(String saleDatePut) {
        this.saleDatePut = saleDatePut;
    }

    public String getSaleDateData() {
        return saleDateData;
    }

    public void setSaleDateData(String saleDateData) {
        this.saleDateData = saleDateData;
    }

    public String getSaleTimePut() {
        return saleTimePut;
    }

    public void setSaleTimePut(String saleTimePut) {
        this.saleTimePut = saleTimePut;
    }

    public String getSaleTimeData() {
        return saleTimeData;
    }

    public void setSaleTimeData(String saleTimeData) {
        this.saleTimeData = saleTimeData;
    }

    public String getPackDatePut() {
        return packDatePut;
    }

    public void setPackDatePut(String packDatePut) {
        this.packDatePut = packDatePut;
    }

    public String getPackDateData() {
        return packDateData;
    }

    public void setPackDateData(String packDateData) {
        this.packDateData = packDateData;
    }

    public String getPackTimePut() {
        return packTimePut;
    }

    public void setPackTimePut(String packTimePut) {
        this.packTimePut = packTimePut;
    }

    public String getPackTimeData() {
        return packTimeData;
    }

    public void setPackTimeData(String packTimeData) {
        this.packTimeData = packTimeData;
    }

    public String getManualDiscountLower() {
        return manualDiscountLower;
    }

    public void setManualDiscountLower(String manualDiscountLower) {
        this.manualDiscountLower = manualDiscountLower;
    }

    public String getManualDiscountLowerValue() {
        return manualDiscountLowerValue;
    }

    public void setManualDiscountLowerValue(String manualDiscountLowerValue) {
        this.manualDiscountLowerValue = manualDiscountLowerValue;
    }

    public String getManualDiscountUpper() {
        return manualDiscountUpper;
    }

    public void setManualDiscountUpper(String manualDiscountUpper) {
        this.manualDiscountUpper = manualDiscountUpper;
    }

    public String getManualDiscountUpperValue() {
        return manualDiscountUpperValue;
    }

    public void setManualDiscountUpperValue(String manualDiscountUpperValue) {
        this.manualDiscountUpperValue = manualDiscountUpperValue;
    }

    public String getCustomDiscount0Type() {
        return customDiscount0Type;
    }

    public void setCustomDiscount0Type(String customDiscount0Type) {
        this.customDiscount0Type = customDiscount0Type;
    }

    public String getCustomDiscount0UseDate() {
        return customDiscount0UseDate;
    }

    public void setCustomDiscount0UseDate(String customDiscount0UseDate) {
        this.customDiscount0UseDate = customDiscount0UseDate;
    }

    public String getCustomDiscount0Lower() {
        return customDiscount0Lower;
    }

    public void setCustomDiscount0Lower(String customDiscount0Lower) {
        this.customDiscount0Lower = customDiscount0Lower;
    }

    public String getCustomDiscount0Upper() {
        return customDiscount0Upper;
    }

    public void setCustomDiscount0Upper(String customDiscount0Upper) {
        this.customDiscount0Upper = customDiscount0Upper;
    }

    public String getCustomDiscount0Value() {
        return customDiscount0Value;
    }

    public void setCustomDiscount0Value(String customDiscount0Value) {
        this.customDiscount0Value = customDiscount0Value;
    }

    public String getCustomDiscount1Type() {
        return customDiscount1Type;
    }

    public void setCustomDiscount1Type(String customDiscount1Type) {
        this.customDiscount1Type = customDiscount1Type;
    }

    public String getCustomDiscount1UseDate() {
        return customDiscount1UseDate;
    }

    public void setCustomDiscount1UseDate(String customDiscount1UseDate) {
        this.customDiscount1UseDate = customDiscount1UseDate;
    }

    public String getCustomDiscount1Lower() {
        return customDiscount1Lower;
    }

    public void setCustomDiscount1Lower(String customDiscount1Lower) {
        this.customDiscount1Lower = customDiscount1Lower;
    }

    public String getCustomDiscount1Upper() {
        return customDiscount1Upper;
    }

    public void setCustomDiscount1Upper(String customDiscount1Upper) {
        this.customDiscount1Upper = customDiscount1Upper;
    }

    public String getCustomDiscount1Value() {
        return customDiscount1Value;
    }

    public void setCustomDiscount1Value(String customDiscount1Value) {
        this.customDiscount1Value = customDiscount1Value;
    }

    public String getCustomDiscount2Type() {
        return customDiscount2Type;
    }

    public void setCustomDiscount2Type(String customDiscount2Type) {
        this.customDiscount2Type = customDiscount2Type;
    }

    public String getCustomDiscount2UseDate() {
        return customDiscount2UseDate;
    }

    public void setCustomDiscount2UseDate(String customDiscount2UseDate) {
        this.customDiscount2UseDate = customDiscount2UseDate;
    }

    public String getCustomDiscount2Lower() {
        return customDiscount2Lower;
    }

    public void setCustomDiscount2Lower(String customDiscount2Lower) {
        this.customDiscount2Lower = customDiscount2Lower;
    }

    public String getCustomDiscount2Upper() {
        return customDiscount2Upper;
    }

    public void setCustomDiscount2Upper(String customDiscount2Upper) {
        this.customDiscount2Upper = customDiscount2Upper;
    }

    public String getCustomDiscount2Value() {
        return customDiscount2Value;
    }

    public void setCustomDiscount2Value(String customDiscount2Value) {
        this.customDiscount2Value = customDiscount2Value;
    }

    public String getCustomDiscount3Type() {
        return customDiscount3Type;
    }

    public void setCustomDiscount3Type(String customDiscount3Type) {
        this.customDiscount3Type = customDiscount3Type;
    }

    public String getCustomDiscount3UseDate() {
        return customDiscount3UseDate;
    }

    public void setCustomDiscount3UseDate(String customDiscount3UseDate) {
        this.customDiscount3UseDate = customDiscount3UseDate;
    }

    public String getCustomDiscount3Lower() {
        return customDiscount3Lower;
    }

    public void setCustomDiscount3Lower(String customDiscount3Lower) {
        this.customDiscount3Lower = customDiscount3Lower;
    }

    public String getCustomDiscount3Upper() {
        return customDiscount3Upper;
    }

    public void setCustomDiscount3Upper(String customDiscount3Upper) {
        this.customDiscount3Upper = customDiscount3Upper;
    }

    public String getCustomDiscount3Value() {
        return customDiscount3Value;
    }

    public void setCustomDiscount3Value(String customDiscount3Value) {
        this.customDiscount3Value = customDiscount3Value;
    }

    public Integer getSspValue1() {
        return sspValue1;
    }

    public void setSspValue1(Integer sspValue1) {
        this.sspValue1 = sspValue1;
    }

    public Integer getSspValue2() {
        return sspValue2;
    }

    public void setSspValue2(Integer sspValue2) {
        this.sspValue2 = sspValue2;
    }

    public Integer getSspValue3() {
        return sspValue3;
    }

    public void setSspValue3(Integer sspValue3) {
        this.sspValue3 = sspValue3;
    }

    public Integer getSspValue4() {
        return sspValue4;
    }

    public void setSspValue4(Integer sspValue4) {
        this.sspValue4 = sspValue4;
    }

    public String getPluType() {
        return pluType;
    }

    public void setPluType(String pluType) {
        this.pluType = pluType;
    }

    public String getPluSign() {
        return pluSign;
    }

    public void setPluSign(String pluSign) {
        this.pluSign = pluSign;
    }

    public String getPluSignValue() {
        return pluSignValue;
    }

    public void setPluSignValue(String pluSignValue) {
        this.pluSignValue = pluSignValue;
    }

    public String getPingYinSearch() {
        return pingYinSearch;
    }

    public void setPingYinSearch(String pingYinSearch) {
        this.pingYinSearch = pingYinSearch;
    }

    @Override
    public List<String> gtCollectList() {
        collectionList.add(number);
        collectionList.add(indexBar);
        collectionList.add(gtFloatPart(useDatePut, useDateData));
        collectionList.add(costTrade);
        collectionList.add(trae);
        collectionList.add(group);
        collectionList.add(putType1);
        collectionList.add(barNo1);
        collectionList.add(barType1);
        collectionList.add(putType2);
        collectionList.add(barNo2);
        collectionList.add(barType2);
        collectionList.add(text1);
        collectionList.add(text2);
        collectionList.add(text3);
        collectionList.add(text4);
        collectionList.add(text5);
        collectionList.add(text6);
        collectionList.add(text7);
        collectionList.add(gtFloatPart(taxType, taxExtreme));
        collectionList.add(picNo);
        collectionList.add(gtFloatPart(saleDatePut, saleDateData));
        collectionList.add(gtFloatPart(saleTimePut, saleTimeData));
        collectionList.add(gtFloatPart(packDatePut, packDateData));
        collectionList.add(gtFloatPart(packTimePut, packTimeData));
        collectionList.add(gtFloatPart(manualDiscountLower, manualDiscountLowerValue));
        collectionList.add(gtFloatPart(manualDiscountUpper, manualDiscountUpperValue));
        collectionList.add(gtFloatPart(customDiscount0Type, customDiscount0UseDate, customDiscount0Lower, customDiscount0Upper, customDiscount0Value));
        collectionList.add(gtFloatPart(customDiscount1Type, customDiscount1UseDate, customDiscount1Lower, customDiscount1Upper, customDiscount1Value));
        collectionList.add(gtFloatPart(customDiscount2Type, customDiscount2UseDate, customDiscount2Lower, customDiscount2Upper, customDiscount2Value));
        collectionList.add(gtFloatPart(customDiscount3Type, customDiscount3UseDate, customDiscount3Lower, customDiscount3Upper, customDiscount3Value));
        collectionList.add(Objects.nonNull(sspValue1) ? sspValue1.toString() : null);
        collectionList.add(Objects.nonNull(sspValue2) ? sspValue2.toString() : null);
        collectionList.add(Objects.nonNull(sspValue3) ? sspValue3.toString() : null);
        collectionList.add(Objects.nonNull(sspValue4) ? sspValue4.toString() : null);
        collectionList.add(pluType);
        collectionList.add(pluSign);
        collectionList.add(pluSignValue);
        collectionList.add(pingYinSearch);
        return collectionList;
    }

    @Override
    public String gtDData(String charter) {
        ContentAssembler assembler = new ContentAssembler(charter)
                .appendText(this.name)
                .append1Bytes(this.weight)
                .appendBigDecimal(this.price)
                .append(gtFloat());

        if (StringUtils.isNotBlank(this.number))
            assembler.append4Bytes(this.number);
        if (StringUtils.isNotBlank(this.indexBar))
            assembler.appendText(this.indexBar);
        if (StringUtils.isNotBlank(this.useDatePut))
            assembler.append1Bytes(this.useDatePut);
        if (StringUtils.isNotBlank(this.useDateData))
            assembler.append2Bytes(this.useDateData);
        if (StringUtils.isNotBlank(this.costTrade))
            assembler.appendBigDecimal(this.costTrade);
        if (StringUtils.isNotBlank(this.trae))
            assembler.appendBigDecimal(this.trae);
        if (StringUtils.isNotBlank(this.group))
            assembler.append2Bytes(this.group);
        if (StringUtils.isNotBlank(this.putType1))
            assembler.append2Bytes(this.putType1);
        if (StringUtils.isNotBlank(this.barNo1))
            assembler.append2Bytes(this.barNo1);
        if (StringUtils.isNotBlank(this.barType1))
            assembler.append2Bytes(this.barType1);
        if (StringUtils.isNotBlank(this.putType2))
            assembler.append2Bytes(this.putType2);
        if (StringUtils.isNotBlank(this.barNo2))
            assembler.append2Bytes(this.barNo2);
        if (StringUtils.isNotBlank(this.barType2))
            assembler.append2Bytes(this.barType2);
        if (StringUtils.isNotBlank(this.text1))
            assembler.appendText(this.text1);
        if (StringUtils.isNotBlank(this.text2))
            assembler.appendText(this.text2);
        if (StringUtils.isNotBlank(this.text3))
            assembler.appendText(this.text3);
        if (StringUtils.isNotBlank(this.text4))
            assembler.appendText(this.text4);
        if (StringUtils.isNotBlank(this.text5))
            assembler.appendText(this.text5);
        if (StringUtils.isNotBlank(this.text6))
            assembler.appendText(this.text6);
        if (StringUtils.isNotBlank(this.text7))
            assembler.appendText(this.text7);
        if (StringUtils.isNotBlank(this.taxType))
            assembler.append1Bytes(this.taxType);
        if (StringUtils.isNotBlank(this.taxExtreme))
            assembler.append4Bytes(this.taxExtreme);//万分比是不是就是特殊浮点还是就是4字节
        if (StringUtils.isNotBlank(this.picNo))
            assembler.append2Bytes(this.picNo);
        if (StringUtils.isNotBlank(this.saleDatePut))
            assembler.append1Bytes(this.saleDatePut);
        if (StringUtils.isNotBlank(this.saleDateData))
            assembler.append2Bytes(this.saleDateData);
        if (StringUtils.isNotBlank(this.saleTimePut))
            assembler.append1Bytes(this.saleTimePut);
        if (StringUtils.isNotBlank(this.saleTimeData))
            assembler.append2Bytes(this.saleTimeData);
        if (StringUtils.isNotBlank(this.packDatePut))
            assembler.append1Bytes(this.packDatePut);
        if (StringUtils.isNotBlank(this.packDateData))
            assembler.append2Bytes(this.packDateData);
        if (StringUtils.isNotBlank(this.packTimePut))
            assembler.append1Bytes(this.packTimePut);
        if (StringUtils.isNotBlank(this.packTimeData))
            assembler.append2Bytes(this.packTimeData);
        if (StringUtils.isNotBlank(this.manualDiscountLower))
            assembler.append1Bytes(this.manualDiscountLower);
        if (StringUtils.isNotBlank(this.manualDiscountLowerValue))
            assembler.appendBigDecimal(this.manualDiscountLowerValue);
        if (StringUtils.isNotBlank(this.manualDiscountUpper))
            assembler.append1Bytes(this.manualDiscountUpper);
        if (StringUtils.isNotBlank(this.manualDiscountUpperValue))
            assembler.appendBigDecimal(this.manualDiscountUpperValue);
        if (StringUtils.isNotBlank(this.customDiscount0Type))
            assembler.append1Bytes(this.customDiscount0Type);
        if (StringUtils.isNotBlank(this.customDiscount0UseDate))
            assembler.append1Bytes(this.customDiscount0UseDate);
        if (StringUtils.isNotBlank(this.customDiscount0Lower))
            assembler.appendBigDecimal(this.customDiscount0Lower);
        if (StringUtils.isNotBlank(this.customDiscount0Upper))
            assembler.appendBigDecimal(this.customDiscount0Upper);
        if (StringUtils.isNotBlank(this.customDiscount0Value))
            assembler.appendBigDecimal(this.customDiscount0Value);
        if (StringUtils.isNotBlank(this.customDiscount1Type))
            assembler.append1Bytes(this.customDiscount1Type);
        if (StringUtils.isNotBlank(this.customDiscount1UseDate))
            assembler.append1Bytes(this.customDiscount1UseDate);
        if (StringUtils.isNotBlank(this.customDiscount1Lower))
            assembler.appendBigDecimal(this.customDiscount1Lower);
        if (StringUtils.isNotBlank(this.customDiscount1Upper))
            assembler.appendBigDecimal(this.customDiscount1Upper);
        if (StringUtils.isNotBlank(this.customDiscount1Value))
            assembler.appendBigDecimal(this.customDiscount1Value);
        if (StringUtils.isNotBlank(this.customDiscount2Type))
            assembler.append1Bytes(this.customDiscount2Type);
        if (StringUtils.isNotBlank(this.customDiscount2UseDate))
            assembler.append1Bytes(this.customDiscount2UseDate);
        if (StringUtils.isNotBlank(this.customDiscount2Lower))
            assembler.appendBigDecimal(this.customDiscount2Lower);
        if (StringUtils.isNotBlank(this.customDiscount2Upper))
            assembler.appendBigDecimal(this.customDiscount2Upper);
        if (StringUtils.isNotBlank(this.customDiscount2Value))
            assembler.appendBigDecimal(this.customDiscount2Value);
        if (StringUtils.isNotBlank(this.customDiscount3Type))
            assembler.append1Bytes(this.customDiscount3Type);
        if (StringUtils.isNotBlank(this.customDiscount3UseDate))
            assembler.append1Bytes(this.customDiscount3UseDate);
        if (StringUtils.isNotBlank(this.customDiscount3Lower))
            assembler.appendBigDecimal(this.customDiscount3Lower);
        if (StringUtils.isNotBlank(this.customDiscount3Upper))
            assembler.appendBigDecimal(this.customDiscount3Upper);
        if (StringUtils.isNotBlank(this.customDiscount3Value))
            assembler.appendBigDecimal(this.customDiscount3Value);
        if (Objects.nonNull(this.sspValue1)) assembler.append4Integer(this.sspValue1);
        if (Objects.nonNull(this.sspValue2)) assembler.append4Integer(this.sspValue2);
        if (Objects.nonNull(this.sspValue3)) assembler.append4Integer(this.sspValue3);
        if (Objects.nonNull(this.sspValue4)) assembler.append4Integer(this.sspValue4);
        if (StringUtils.isNotBlank(this.pluType)) assembler.appendConvert(this.pluType);
        if (StringUtils.isNotBlank(this.pluSign)) assembler.appendConvert(this.pluSign);
        if (StringUtils.isNotBlank(this.pluSignValue)) assembler.appendConvert(this.pluSignValue);
        if (StringUtils.isNotBlank(this.pingYinSearch)) assembler.appendText(this.pingYinSearch);
        return assembler.over();
    }

    /**
     * @description: 数据同步类型key 如  PLU、CLS、SAL
     **/
    @Override
    public String dataKey() {
        return SyncDataType.PLU.getType();
    }

    /**
     * @description: 对象转换
     **/
    @Override
    public DataJSONModel toDData() {
        DPLUV5 plu = new DPLUV5<DPLUV5>()
                .setNo(this.did())
                .setItemCode(StringUtils.isNotBlank(this.number) ? Integer.parseInt(this.number) : null)
                .setIndexBar(this.indexBar)
                .setUnit(StringUtils.isNotBlank(this.weight) ? Integer.parseInt(this.weight) : UnitEnum.计件.val())
                .setPrint(new DPrintWithBitMapV1()
                        .setType1(StringUtils.isNotBlank(this.putType1) ? Integer.parseInt(this.putType1) : ZERO)
                        .setBarcode1(StringUtils.isNotBlank(this.barNo1) ? Integer.parseInt(this.barNo1) : ZERO)
                        .setSign1(StringUtils.isNotBlank(this.barType1) ? Integer.parseInt(this.barType1) : ZERO)
                        .setType2(StringUtils.isNotBlank(this.putType2) ? Integer.parseInt(this.putType2) : ZERO)
                        .setBarcode2(StringUtils.isNotBlank(this.barNo2) ? Integer.parseInt(this.barNo2) : ZERO)
                        .setSign2(StringUtils.isNotBlank(this.barType2) ? Integer.parseInt(this.barType2) : ZERO)
                        .setBitmap(StringUtils.isNotBlank(this.picNo) ? Integer.parseInt(this.picNo) : ZERO)
                )
                .setCategory(StringUtils.isNotBlank(this.group) ? Integer.parseInt(this.group) : DConstant.DEFAULT_DEPT)
                .setName(this.name)
                .setText(new DTextV1()
                        .addTexts(this.text1, this.text2, this.text3,
                                this.text4, this.text5, this.text6, this.text7)
                )
                .setTime(new DTimeV2()
                        .setUseDatePS(StringUtils.isNotBlank(this.useDatePut) ? Integer.parseInt(this.useDatePut) : ZERO)
                        .setUseDatePC(StringUtils.isNotBlank(this.useDateData) ? Integer.parseInt(this.useDateData) : ZERO)
                        .setSaleDatePS(StringUtils.isNotBlank(this.saleDatePut) ? Integer.parseInt(this.saleDatePut) : ZERO)
                        .setSaleDatePC(StringUtils.isNotBlank(this.saleDateData) ? Integer.parseInt(this.saleDateData) : ZERO)
                        .setSaleTimePS(StringUtils.isNotBlank(this.saleTimePut) ? Integer.parseInt(this.saleTimePut) : ZERO)
                        .setSaleTimePC(StringUtils.isNotBlank(this.saleTimeData) ? Integer.parseInt(this.saleTimeData) : ZERO)
                        .setPackDatePS(StringUtils.isNotBlank(this.packDatePut) ? Integer.parseInt(this.packDatePut) : ZERO)
                        .setPackDatePC(StringUtils.isNotBlank(this.packDateData) ? Integer.parseInt(this.packDateData) : ZERO)
                        .setPackTimePS(StringUtils.isNotBlank(this.packTimePut) ? Integer.parseInt(this.packTimePut) : ZERO)
                        .setPackTimePC(StringUtils.isNotBlank(this.packTimeData) ? Integer.parseInt(this.packTimeData) : ZERO)
                )
                .setPrice(new DPriceV2()
                        .setPrice(StringUtils.isNotBlank(this.price) ? new BigDecimal(this.price) : BigDecimal.ZERO)
                        .addManualDiscounts(
                                new DManualDiscount.DLowerManualDiscount()
                                        .setType(StringUtils.isNotBlank(this.manualDiscountLower) ? Integer.parseInt(this.manualDiscountLower) : ZERO)
                                        .setDiscount(StringUtils.isNotBlank(this.manualDiscountLowerValue) ? new BigDecimal(this.manualDiscountLowerValue) : BigDecimal.ZERO),
                                new DManualDiscount.DUpperManualDiscount()
                                        .setType(StringUtils.isNotBlank(this.manualDiscountUpper) ? Integer.parseInt(this.manualDiscountUpper) : ZERO)
                                        .setDiscount(StringUtils.isNotBlank(this.manualDiscountUpperValue) ? new BigDecimal(this.manualDiscountUpperValue) : BigDecimal.ZERO)
                        )
                        .addAutoDiscounts(
                                new DAutoDiscountV2()
                                        .setType(StringUtils.isNotBlank(this.customDiscount0Type) ? Integer.parseInt(this.customDiscount0Type) : ZERO)
                                        .setDate(StringUtils.isNoneBlank(this.customDiscount0UseDate) ? Integer.parseInt(this.customDiscount0UseDate) : 127)
                                        .setLower(StringUtils.isNotBlank(this.customDiscount0Lower) ? new BigDecimal(this.customDiscount0Lower) : BigDecimal.ZERO)
                                        .setUpper(StringUtils.isNotBlank(this.customDiscount0Upper) ? new BigDecimal(this.customDiscount0Upper) : BigDecimal.ZERO)
                                        .setDiscount(StringUtils.isNotBlank(this.customDiscount0Value) ? new BigDecimal(this.customDiscount0Value) : BigDecimal.ZERO),
                                new DAutoDiscountV2()
                                        .setType(StringUtils.isNotBlank(this.customDiscount1Type) ? Integer.parseInt(this.customDiscount1Type) : ZERO)
                                        .setDate(StringUtils.isNoneBlank(this.customDiscount1UseDate) ? Integer.parseInt(this.customDiscount1UseDate) : 127)
                                        .setLower(StringUtils.isNotBlank(this.customDiscount1Lower) ? new BigDecimal(this.customDiscount1Lower) : BigDecimal.ZERO)
                                        .setUpper(StringUtils.isNotBlank(this.customDiscount1Upper) ? new BigDecimal(this.customDiscount1Upper) : BigDecimal.ZERO)
                                        .setDiscount(StringUtils.isNotBlank(this.customDiscount1Value) ? new BigDecimal(this.customDiscount1Value) : BigDecimal.ZERO),
                                new DAutoDiscountV2()
                                        .setType(StringUtils.isNotBlank(this.customDiscount2Type) ? Integer.parseInt(this.customDiscount2Type) : ZERO)
                                        .setDate(StringUtils.isNoneBlank(this.customDiscount2UseDate) ? Integer.parseInt(this.customDiscount2UseDate) : 127)
                                        .setLower(StringUtils.isNotBlank(this.customDiscount2Lower) ? new BigDecimal(this.customDiscount2Lower) : BigDecimal.ZERO)
                                        .setUpper(StringUtils.isNotBlank(this.customDiscount2Upper) ? new BigDecimal(this.customDiscount2Upper) : BigDecimal.ZERO)
                                        .setDiscount(StringUtils.isNotBlank(this.customDiscount2Value) ? new BigDecimal(this.customDiscount2Value) : BigDecimal.ZERO),
                                new DAutoDiscountV2()
                                        .setType(StringUtils.isNotBlank(this.customDiscount3Type) ? Integer.parseInt(this.customDiscount3Type) : ZERO)
                                        .setDate(StringUtils.isNoneBlank(this.customDiscount3UseDate) ? Integer.parseInt(this.customDiscount3UseDate) : 127)
                                        .setLower(StringUtils.isNotBlank(this.customDiscount3Lower) ? new BigDecimal(this.customDiscount3Lower) : BigDecimal.ZERO)
                                        .setUpper(StringUtils.isNotBlank(this.customDiscount3Upper) ? new BigDecimal(this.customDiscount3Upper) : BigDecimal.ZERO)
                                        .setDiscount(StringUtils.isNotBlank(this.customDiscount3Value) ? new BigDecimal(this.customDiscount3Value) : BigDecimal.ZERO)
                        )
                )
                .setTaxType(StringUtils.isNotBlank(this.taxType) ? Integer.parseInt(this.taxType) : ZERO)
                .setTaxRate(StringUtils.isNotBlank(this.taxExtreme) ? Integer.parseInt(this.taxExtreme) : ZERO)
                .setSspVale_0(this.sspValue1)
                .setSspVale_1(this.sspValue2)
                .setSspVale_2(this.sspValue3)
                .setSspVale_3(this.sspValue4)
                .setStype(this.pluType)
                .setSimple(this.pingYinSearch)
                .setCostTrade(StringUtils.isNotBlank(this.costTrade) ? new BigDecimal(this.costTrade) : null)
                .setSaveAsWeight(SAVE_WEIGHT_DISABLE);
        if (StringUtils.isNotBlank(this.pluSign)) {
            int pluSign = Integer.parseInt(this.pluSign);
            if (UnitType.计件.equals(UnitEnum.unit(this.weight).getType())) {
                if (pluSign == 1) {
                    plu.setUnitText(this.text7);
                    plu.getText().getTexts().set(6, null);
                } else if (pluSign == 2) {
                    plu.setSaveAsWeight(SAVE_WEIGHT_ENABLE);
                }
            } else {
                plu.setTare(StringUtils.isNotBlank(this.trae) ? new BigDecimal(this.trae) : BigDecimal.ZERO);
                if (pluSign == 2) {
                    plu.setFixedWeight(StringUtils.isNotBlank(this.pluSignValue) ? new BigDecimal(this.pluSignValue) : BigDecimal.ZERO);
                } else if (pluSign == 4) {
                    plu.setPercentTare(StringUtils.isNotBlank(this.pluSignValue) ? new BigDecimal(this.pluSignValue) : BigDecimal.ZERO);
                }
            }
        }
        return plu;
    }
}
