package com.jhscale.meter.wifi.entity;

import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.wifi.constant.CMDConstant;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: Put
 * @projectName jhscale-agreement
 * @description: 打印格式
 * @date 2019/9/1612:22
 */
public class Put extends Content {

    private static final String dSort = "06";

    private String name;
    private String type;
    private String fontMode;
    private String high;
    private String width;
    private String sonCount;

    private String text0;
    private String text1;
    private String text2;
    private String text3;
    private String text4;
    private String text5;
    private String text6;
    private String text7;
    private String text8;
    private String text9;
    private String text10;
    private String text11;
    private String text12;
    private String text13;
    private String text14;
    private String text15;
    private String text16;
    private String text17;
    private String text18;
    private String text19;
    private String text20;
    private String text21;
    private String text22;
    private String text23;
    private String text24;
    private String text25;
    private String text26;
    private String text27;
    private String text28;
    private String text29;
    private String text30;
    private String text31;

    private List<PutSon> putSons;

    /**
     * @param charter 字符集
     * @param dCmd    指令类型
     * @param dId     编号
     * @description: 带字符集有参构造指令类型
     */
    public Put(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    /**
     * @param dCmd 指令类型
     * @param dId  编号
     * @description: 默认字符集有参构造指令类型
     */
    public Put(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    /**
     * @description: 默认构造 回收指令
     **/
    public Put() {
        super("", CMDConstant.REQ, dSort, CMDConstant.RECOVER_DID);
    }

    /**
     * @description: 数据解析
     **/
    public Put(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) Base64Utils.ungzipString(dData);
        ContentParse parse = new ContentParse(dData, charter);
        this.name = parse.parseText();
        this.type = parse.parse1Bytes();
        this.fontMode = parse.parse1Bytes();
        this.high = parse.parse1Bytes();
        this.width = parse.parse1Bytes();
        this.sonCount = parse.parse1Bytes();
        char[] chars = parse.parsefloatData();
        parseFload(chars, parse);

        List<PutSon> putSons = new ArrayList<>();
        for (int i = 0; i < Integer.parseInt(this.sonCount); i++) {
            putSons.add(new PutSon(parse));
        }
        this.putSons = putSons;
    }

    private void parseFload(char[] chars, ContentParse parse) {
        if (chars[0] == '1') this.text0 = parse.parseText();
        if (chars[1] == '1') this.text1 = parse.parseText();
        if (chars[2] == '1') this.text2 = parse.parseText();
        if (chars[3] == '1') this.text3 = parse.parseText();
        if (chars[4] == '1') this.text4 = parse.parseText();
        if (chars[5] == '1') this.text5 = parse.parseText();
        if (chars[6] == '1') this.text6 = parse.parseText();
        if (chars[16] == '1') this.text7 = parse.parseText();
        if (chars[17] == '1') this.text8 = parse.parseText();
        if (chars[18] == '1') this.text9 = parse.parseText();
        if (chars[19] == '1') this.text10 = parse.parseText();
        if (chars[20] == '1') this.text11 = parse.parseText();
        if (chars[21] == '1') this.text12 = parse.parseText();
        if (chars[22] == '1') this.text13 = parse.parseText();
        if (chars[23] == '1') this.text14 = parse.parseText();
        if (chars[24] == '1') this.text15 = parse.parseText();
        if (chars[25] == '1') this.text16 = parse.parseText();
        if (chars[26] == '1') this.text17 = parse.parseText();
        if (chars[27] == '1') this.text18 = parse.parseText();
        if (chars[28] == '1') this.text19 = parse.parseText();
        if (chars[29] == '1') this.text20 = parse.parseText();
        if (chars[30] == '1') this.text21 = parse.parseText();
        if (chars[31] == '1') this.text22 = parse.parseText();
        if (chars[32] == '1') this.text23 = parse.parseText();
        if (chars[33] == '1') this.text24 = parse.parseText();
        if (chars[34] == '1') this.text25 = parse.parseText();
        if (chars[35] == '1') this.text26 = parse.parseText();
        if (chars[36] == '1') this.text27 = parse.parseText();
        if (chars[37] == '1') this.text28 = parse.parseText();
        if (chars[38] == '1') this.text29 = parse.parseText();
        if (chars[39] == '1') this.text30 = parse.parseText();
        if (chars[40] == '1') this.text31 = parse.parseText();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFontMode() {
        return fontMode;
    }

    public void setFontMode(String fontMode) {
        this.fontMode = fontMode;
    }

    public String getHigh() {
        return high;
    }

    public void setHigh(String high) {
        this.high = high;
    }

    public String getWidth() {
        return width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getSonCount() {
        return sonCount;
    }

    public void setSonCount(String sonCount) {
        this.sonCount = sonCount;
    }

    public String getText0() {
        return text0;
    }

    public void setText0(String text0) {
        this.text0 = text0;
    }

    public String getText1() {
        return text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    public String getText2() {
        return text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    public String getText3() {
        return text3;
    }

    public void setText3(String text3) {
        this.text3 = text3;
    }

    public String getText4() {
        return text4;
    }

    public void setText4(String text4) {
        this.text4 = text4;
    }

    public String getText5() {
        return text5;
    }

    public void setText5(String text5) {
        this.text5 = text5;
    }

    public String getText6() {
        return text6;
    }

    public void setText6(String text6) {
        this.text6 = text6;
    }

    public String getText7() {
        return text7;
    }

    public void setText7(String text7) {
        this.text7 = text7;
    }

    public String getText8() {
        return text8;
    }

    public void setText8(String text8) {
        this.text8 = text8;
    }

    public String getText9() {
        return text9;
    }

    public void setText9(String text9) {
        this.text9 = text9;
    }

    public String getText10() {
        return text10;
    }

    public void setText10(String text10) {
        this.text10 = text10;
    }

    public String getText11() {
        return text11;
    }

    public void setText11(String text11) {
        this.text11 = text11;
    }

    public String getText12() {
        return text12;
    }

    public void setText12(String text12) {
        this.text12 = text12;
    }

    public String getText13() {
        return text13;
    }

    public void setText13(String text13) {
        this.text13 = text13;
    }

    public String getText14() {
        return text14;
    }

    public void setText14(String text14) {
        this.text14 = text14;
    }

    public String getText15() {
        return text15;
    }

    public void setText15(String text15) {
        this.text15 = text15;
    }

    public String getText16() {
        return text16;
    }

    public void setText16(String text16) {
        this.text16 = text16;
    }

    public String getText17() {
        return text17;
    }

    public void setText17(String text17) {
        this.text17 = text17;
    }

    public String getText18() {
        return text18;
    }

    public void setText18(String text18) {
        this.text18 = text18;
    }

    public String getText19() {
        return text19;
    }

    public void setText19(String text19) {
        this.text19 = text19;
    }

    public String getText20() {
        return text20;
    }

    public void setText20(String text20) {
        this.text20 = text20;
    }

    public String getText21() {
        return text21;
    }

    public void setText21(String text21) {
        this.text21 = text21;
    }

    public String getText22() {
        return text22;
    }

    public void setText22(String text22) {
        this.text22 = text22;
    }

    public String getText23() {
        return text23;
    }

    public void setText23(String text23) {
        this.text23 = text23;
    }

    public String getText24() {
        return text24;
    }

    public void setText24(String text24) {
        this.text24 = text24;
    }

    public String getText25() {
        return text25;
    }

    public void setText25(String text25) {
        this.text25 = text25;
    }

    public String getText26() {
        return text26;
    }

    public void setText26(String text26) {
        this.text26 = text26;
    }

    public String getText27() {
        return text27;
    }

    public void setText27(String text27) {
        this.text27 = text27;
    }

    public String getText28() {
        return text28;
    }

    public void setText28(String text28) {
        this.text28 = text28;
    }

    public String getText29() {
        return text29;
    }

    public void setText29(String text29) {
        this.text29 = text29;
    }

    public String getText30() {
        return text30;
    }

    public void setText30(String text30) {
        this.text30 = text30;
    }

    public String getText31() {
        return text31;
    }

    public void setText31(String text31) {
        this.text31 = text31;
    }

    public List<PutSon> getPutSons() {
        return putSons;
    }

    public void setPutSons(List<PutSon> putSons) {
        this.putSons = putSons;
    }

    @Override
    public List<String> gtCollectList() {
        collectionList.add(text0);
        collectionList.add(text1);
        collectionList.add(text2);
        collectionList.add(text3);
        collectionList.add(text4);
        collectionList.add(text5);
        collectionList.add(text6);
        collectionList.add(text7);
        collectionList.add(text8);
        collectionList.add(text9);
        collectionList.add(text10);
        collectionList.add(text11);
        collectionList.add(text12);
        collectionList.add(text13);
        collectionList.add(text14);
        collectionList.add(text15);
        collectionList.add(text16);
        collectionList.add(text17);
        collectionList.add(text18);
        collectionList.add(text19);
        collectionList.add(text20);
        collectionList.add(text21);
        collectionList.add(text22);
        collectionList.add(text23);
        collectionList.add(text24);
        collectionList.add(text25);
        collectionList.add(text26);
        collectionList.add(text27);
        collectionList.add(text28);
        collectionList.add(text29);
        collectionList.add(text30);
        collectionList.add(text31);
        return collectionList;
    }

    @Override
    public String gtDData(String charter) {
        ContentAssembler assembler = new ContentAssembler(charter)
                .appendText(this.name)
                .append1Bytes(this.type)
                .append1Bytes(this.fontMode)
                .append1Bytes(this.high)
                .append1Bytes(this.width)
                .append1Bytes(this.sonCount)
                .append(gtFloat());

        if (StringUtils.isNotBlank(text0))
            assembler.append(this.text0);
        if (StringUtils.isNotBlank(text1))
            assembler.append(this.text1);
        if (StringUtils.isNotBlank(text2))
            assembler.append(this.text2);
        if (StringUtils.isNotBlank(text3))
            assembler.append(this.text3);
        if (StringUtils.isNotBlank(text4))
            assembler.append(this.text4);
        if (StringUtils.isNotBlank(text5))
            assembler.append(this.text5);
        if (StringUtils.isNotBlank(text6))
            assembler.append(this.text6);
        if (StringUtils.isNotBlank(text7))
            assembler.append(this.text7);
        if (StringUtils.isNotBlank(text8))
            assembler.append(this.text8);
        if (StringUtils.isNotBlank(text9))
            assembler.append(this.text9);
        if (StringUtils.isNotBlank(text10))
            assembler.append(this.text10);
        if (StringUtils.isNotBlank(text11))
            assembler.append(this.text11);
        if (StringUtils.isNotBlank(text12))
            assembler.append(this.text12);
        if (StringUtils.isNotBlank(text13))
            assembler.append(this.text13);
        if (StringUtils.isNotBlank(text14))
            assembler.append(this.text14);
        if (StringUtils.isNotBlank(text15))
            assembler.append(this.text15);
        if (StringUtils.isNotBlank(text16))
            assembler.append(this.text16);
        if (StringUtils.isNotBlank(text17))
            assembler.append(this.text17);
        if (StringUtils.isNotBlank(text18))
            assembler.append(this.text18);
        if (StringUtils.isNotBlank(text19))
            assembler.append(this.text19);
        if (StringUtils.isNotBlank(text20))
            assembler.append(this.text20);
        if (StringUtils.isNotBlank(text21))
            assembler.append(this.text21);
        if (StringUtils.isNotBlank(text22))
            assembler.append(this.text22);
        if (StringUtils.isNotBlank(text23))
            assembler.append(this.text23);
        if (StringUtils.isNotBlank(text24))
            assembler.append(this.text24);
        if (StringUtils.isNotBlank(text25))
            assembler.append(this.text25);
        if (StringUtils.isNotBlank(text26))
            assembler.append(this.text26);
        if (StringUtils.isNotBlank(text27))
            assembler.append(this.text27);
        if (StringUtils.isNotBlank(text28))
            assembler.append(this.text28);
        if (StringUtils.isNotBlank(text29))
            assembler.append(this.text29);
        if (StringUtils.isNotBlank(text30))
            assembler.append(this.text30);
        if (StringUtils.isNotBlank(text31))
            assembler.append(this.text31);

        if (putSons != null && !putSons.isEmpty()) {
            for (PutSon putSon : putSons) {
                assembler.append1Bytes(putSon.getNumber())
                        .append1Bytes(putSon.getSgin0())
                        .append1Bytes(putSon.getSgin1())
                        .append1Bytes(putSon.getSgin2())
                        .append1Bytes(putSon.getTerm())
                        .append1Bytes(putSon.getAngle())
                        .append1Bytes(putSon.getAlign())
                        .append1Bytes(putSon.getFontNum())
                        .append4Bytes(putSon.getHorizontal())
                        .append4Bytes(putSon.getVertical())
                        .append4Bytes(putSon.getWidth())
                        .append4Bytes(putSon.getHigh());
            }
        }
        return assembler.over();
    }
}
