package com.jhscale.meter.wifi.entity;

import com.jhscale.common.model.device.text_parameter.DTextParameterV1;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.wifi.constant.CMDConstant;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

import static com.jhscale.common.model.device.DConstant.TMT;

/**
 * @author lie_w
 * @title: Text
 * @projectName jhscale-agreement
 * @description: 文本参数
 * @date 2019/9/1612:26
 */
public class Text extends Content {

    private static final String dSort = "09";

    private String value;

    /**
     * @param charter 字符集
     * @param dCmd    指令类型
     * @param dId     编号
     * @description: 带字符集有参构造指令类型
     */
    public Text(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    /**
     * @param dCmd 指令类型
     * @param dId  编号
     * @description: 默认字符集有参构造指令类型
     */
    public Text(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    /**
     * @description: 默认构造 回收指令
     **/
    public Text() {
        super("", CMDConstant.REQ, dSort, CMDConstant.RECOVER_DID);
    }

    /**
     * @description: 数据解析
     **/
    public Text(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) Base64Utils.ungzipString(dData);
        ContentParse parse = new ContentParse(dData, charter);
        this.value = parse.parseText();
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public List<String> gtCollectList() {
        return new ArrayList<>();
    }

    @Override
    public String gtDData(String charter) {
        return new ContentAssembler(charter).appendText(this.value).over();
    }

//    @Override
//    public boolean canAdd() {
//        return super.canAdd() && StringUtils.isBlank(this.value) ? false : true;
//    }


    /**
     * @description: 数据同步类型key 如  PLU、CLS、SAL
     **/
    @Override
    public String dataKey() {
        return TMT;
    }

    /**
     * @description: 对象转换
     **/
    @Override
    public DataJSONModel toDData() {
        return new DTextParameterV1<>()
                .setNo(this.did())
                .setValue(StringUtils.isNotBlank(this.value) ? this.value : "");
    }
}
