package com.jhscale.meter.wifi.model;

import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.Constant;
import com.jhscale.meter.wifi.constant.CMDConstant;
import com.jhscale.meter.wifi.entity.JHObject;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName: AbstractData
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/3/27 12:58
 * @Version: V1.0.0
 */
public abstract class Content extends JHObject {

    private String charter;

    private String dCmd;

    private String dSort;

    private String dId;

    protected List<String> collectionList;

    public Content() {
    }

    public Content(String charter, String dCmd, String dSort, String dId) {
        if (StringUtils.isBlank(charter)) charter = Constant.DEFAULT_CHARSET;
        this.charter = charter;
        this.dCmd = dCmd;
        this.dSort = dSort;
        this.dId = dId;
        collectionList = new ArrayList<>();
    }

    public String gtDSort() {
        return ByteUtils.covert102Hex(this.dSort);
    }

    public String gtDId() {
        return ByteUtils.covert102Hex(this.dId);
    }

    public void stDid(String dId) {
        this.dId = String.valueOf(Integer.parseInt(ByteUtils.convert(dId), 16));
    }

    public Integer did() {
        try {
            return StringUtils.isNotBlank(this.dId) ? Integer.parseInt(this.dId) : 0;
        } catch (NumberFormatException e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * @description: 浮动标志集合
     **/
    public abstract List<String> gtCollectList();

    /**
     * @description: 数据包
     **/
    public abstract String gtDData(String charter);

    protected String gtFloat() {
        List<Character> chars1 = new ArrayList<>();
        List<Character> chars2 = new ArrayList<>();
        List<Character> chars3 = new ArrayList<>();
        List<Character> chars4 = new ArrayList<>();
        List<Character> chars5 = new ArrayList<>();
        List<Character> chars6 = new ArrayList<>();
        List<Character> chars7 = new ArrayList<>();
        List<Character> chars8 = new ArrayList<>();
        List<Character> chars9 = new ArrayList<>();
        List<String> collectList = gtCollectList();
        for (int i = 0; i < 63; i++) {
            if (i < 7) {
                gtFloatPart(chars1, collectList, i);
            }
            if (i >= 7 && i < 15) {
                gtFloatPart(chars3, collectList, i);
            }
            if (i >= 15 && i < 23) {
                gtFloatPart(chars4, collectList, i);
            }
            if (i >= 23 && i < 31) {
                gtFloatPart(chars5, collectList, i);
            }
            if (i >= 31 && i < 39) {
                gtFloatPart(chars6, collectList, i);
            }
            if (i >= 39 && i < 47) {
                gtFloatPart(chars7, collectList, i);
            }
            if (i >= 47 && i < 55) {
                gtFloatPart(chars8, collectList, i);
            }
            if (i >= 55) {
                gtFloatPart(chars9, collectList, i);
            }
        }
        gtCollect(chars2, chars3);
        gtCollect(chars2, chars4);
        gtCollect(chars2, chars5);
        gtCollect(chars2, chars6);
        gtCollect(chars2, chars7);
        gtCollect(chars2, chars8);
        gtCollect(chars2, chars9);
        chars2.add('0');
        gtCollect(chars1, chars2);

        StringBuffer sb = new StringBuffer();
        sb.append(ByteUtils.dataFormat(listToString(chars1)));
        if (chars2.contains('1')) {
            sb.append(ByteUtils.dataFormat(listToString(chars2)));
        }

        if (chars3.contains('1')) {
            sb.append(ByteUtils.dataFormat(listToString(chars3)));
        }

        if (chars4.contains('1')) {
            sb.append(ByteUtils.dataFormat(listToString(chars4)));
        }

        if (chars5.contains('1')) {
            sb.append(ByteUtils.dataFormat(listToString(chars5)));
        }

        if (chars6.contains('1')) {
            sb.append(ByteUtils.dataFormat(listToString(chars6)));
        }

        if (chars7.contains('1')) {
            sb.append(ByteUtils.dataFormat(listToString(chars7)));
        }

        if (chars8.contains('1')) {
            sb.append(ByteUtils.dataFormat(listToString(chars8)));
        }

        if (chars9.contains('1')) {
            sb.append(ByteUtils.dataFormat(listToString(chars9)));
        }

        return sb.toString();
    }

    protected String gtFloatPart(String... floatParts) {
        StringBuffer stringBuffer = new StringBuffer();
        if (floatParts != null && floatParts.length != 0) {
            for (String floatPart : floatParts) {
                if (StringUtils.isNotBlank(floatPart)) {
                    stringBuffer.append(floatPart);
                }
            }
        }
        String res = stringBuffer.toString();
        if (StringUtils.isNotBlank(res)) {
            return res;
        } else {
            return null;
        }
    }

    private static String listToString(List<Character> list) {
        StringBuffer sb = new StringBuffer();
        if (list != null && !list.isEmpty()) {
            for (int i = list.size(); i > 0; i--)
                sb.append(list.get(i - 1));
        }
        return sb.toString();
    }

    private void gtCollect(List<Character> chars2, List<Character> chars) {
        if (chars.contains('1')) {
            chars2.add('1');
        } else {
            chars2.add('0');
        }
    }

    private void gtFloatPart(List<Character> chars, List<String> collectList, int i) {
        try {
            if (StringUtils.isNotBlank(collectList.get(i))) {
                chars.add('1');
            } else {
                chars.add('0');
            }
        } catch (Exception e) {
            chars.add('0');
        }
    }

    /**
     * @description: 能否添加判断
     **/
    public boolean canAdd() {
        return CMDConstant.REQ.equals(this.dCmd) ? true : ((StringUtils.isNotBlank(this.dId) && !CMDConstant.RECOVER_DID.equals(this.dId)) ? true : false);
    }

    public String getCharter() {
        return charter;
    }

    public void setCharter(String charter) {
        this.charter = charter;
    }

    public String getdCmd() {
        return dCmd;
    }

    public void setdCmd(String dCmd) {
        this.dCmd = dCmd;
    }

    public String getdSort() {
        return dSort;
    }

    public void setdSort(String dSort) {
        this.dSort = dSort;
    }

    public String getdId() {
        return dId;
    }

    public void setdId(String dId) {
        this.dId = dId;
    }

    /**
     * @description: 数据同步类型key 如  PLU、CLS、SAL
     **/
    public String dataKey() {
        return null;
    }

    /**
     * @description: 对象转换
     **/
    public DataJSONModel toDData() {
        return null;
    }
}
