package com.jhscale.meter.wifi.model;

import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.Constant;
import org.apache.commons.lang3.StringUtils;

import java.nio.charset.Charset;
import java.util.Date;

/**
 * @author lie_w
 * @title: ContentParse
 * @projectName jhscale-agreement
 * @description: Content 解析
 * @date 2019/9/1614:20
 */
public class ContentParse {

    // 解析数据 默认已经解压缩的
    private String data;

    // 字符集
    private Charset charset;

    public ContentParse(String data, String charset) {
        this.data = data;
        if (StringUtils.isBlank(charset))
            charset = Constant.DEFAULT_CHARSET;
        this.charset = Charset.forName(charset);
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Charset getCharset() {
        return charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    /**
     * @description: 浮动字段解析
     **/
    public char[] parsefloatData() {
        char[] chars = {'0', '0', '0', '0', '0', '0', '0', '0',
                '0', '0', '0', '0', '0', '0', '0', '0',
                '0', '0', '0', '0', '0', '0', '0', '0',
                '0', '0', '0', '0', '0', '0', '0', '0',
                '0', '0', '0', '0', '0', '0', '0', '0',
                '0', '0', '0', '0', '0', '0', '0', '0',
                '0', '0', '0', '0', '0', '0', '0', '0',
                '0', '0', '0', '0', '0', '0', '0', '0',
                '0', '0', '0', '0', '0', '0', '0', '0'};
        String floatB0 = ByteUtils.formatData(this.data.substring(0, 2));
        for (int i = 0; i < floatB0.length(); i++) {
            chars[i] = floatB0.charAt(i);
        }

        if (floatB0.charAt(floatB0.length() - 1) != '1') {
            this.data = this.data.substring(2);
        } else {
            String floatB1 = ByteUtils.formatData(data.substring(2, 4));
            int count = 0;
            for (int i = 0; i < floatB1.length(); i++) {
                if (floatB1.charAt(i) == '1') {
                    String floatB = ByteUtils.formatData(this.data.substring(4 + count * 2, 6 + count * 2));
                    for (int j = 0; j < floatB.length(); j++) {
                        chars[8 * (i + 2) + j] = floatB.charAt(j);
                    }
                    count++;
                }
            }
            this.data = this.data.substring(4 + count * 2);
        }
        return chars;
    }

    /**
     * @description: 解析HEX 数据参数 快捷键使用
     **/
    public String parseHex() {
        return String.valueOf(Integer.parseInt(ByteUtils.convert(this.data), 16));
    }

    /**
     * @description: 4 字节解析
     **/
    public String parse4Bytes(String... val) {
        String res = "";
        try {
            res = String.valueOf(Integer.parseInt(ByteUtils.convert(this.data.substring(0, 8)), 16));
        } catch (NumberFormatException e) {
            if (val != null && val.length > 0) res = val[0];
        }
        this.data = data.substring(8);
        return res;
    }

    /**
     * @description: 4 字节解析
     **/
    public Integer parse4Integer(Integer... val) {
        Integer res = null;
        try {
            res = Integer.parseInt(ByteUtils.convert(this.data.substring(0, 8)), 16);
        } catch (NumberFormatException e) {
            if (val != null && val.length > 0) res = val[0];
        }
        this.data = data.substring(8);
        return res;
    }

    /**
     * @description: 2 字节解析
     **/
    public String parse2Bytes(String... val) {
        String res = "";
        try {
            res = String.valueOf(Integer.parseInt(ByteUtils.convert(this.data.substring(0, 4)), 16));
        } catch (NumberFormatException e) {
            e.printStackTrace();
            if (val != null && val.length > 0) res = val[0];
        }
        this.data = data.substring(4);
        return res;
    }

    /**
     * @description: 1 字节解析
     **/
    public String parse1Bytes(String... val) {
        String res = "";
        try {
            res = String.valueOf(Integer.parseInt(ByteUtils.convert(this.data.substring(0, 2)), 16));
        } catch (NumberFormatException e) {
            e.printStackTrace();
            if (val != null && val.length > 0) res = val[0];
        }
        this.data = data.substring(2);
        return res;
    }

    /**
     * @description: 金额解析
     **/
    public String parseBigDecimal() {
        String res = ByteUtils.convertBigDecimal(this.data.substring(0, 8)).toString();
        this.data = data.substring(8);
        return res;
    }

    /**
     * @description: 文本解析
     **/
    public String parseText() {
        int index = ByteUtils.indexOf(this.data, "00");
        String hexText = this.data.substring(0, index);
        this.data = data.substring(index + 2);
        return new String(ByteUtils.fromHexAscii(hexText), charset);
    }

    /**
     * @description: 时间解析
     **/
    public Date parseDate() {
        Date res = ByteUtils.convertTime(this.data.substring(0, 8));
        this.data = data.substring(8);
        return res;
    }

    /**
     * @description: Mark解析
     **/
    public String paeseMark() {
        String res = ByteUtils.formatMark(this.data.substring(0, 2));
        this.data = data.substring(2);
        return res;
    }
}
