package com.jhscale.meter.wifi.model;

import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.wifi.constant.CommandType;

/**
 * @author lie_w
 * @title: PackageMark
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2020/6/1714:05
 */
public class PackageMark {

    // 包Mark
    private String mark;

    // 加密应答
    private boolean encrypt;

    // 应答
    private boolean ack;

    // 预留
    private String remark;

    // 指令类型
    private String cd;

    // 内容长度
    private int lenBytes;

    public PackageMark() {
    }

    public PackageMark(byte mark) {
        this.mark = ByteUtils.formatMark(ByteUtils.toHexAscii(mark));
        this.encrypt = '1' == this.mark.charAt(0);
        this.ack = '1' == this.mark.charAt(1);
        this.remark = this.mark.substring(2, 4);
        this.cd = this.mark.substring(4, 6);
        this.lenBytes = Integer.parseInt(this.mark.substring(6, 8), 2);
    }

    public PackageMark(boolean encrypt, boolean ack, String remark, CommandType type, int lenBytes) {
        this.encrypt = encrypt;
        this.ack = ack;
        this.remark = remark;
        this.cd = type.getCd();
        this.lenBytes = lenBytes;
    }

    /**
     * @description: 构建包Mark
     **/
    public String bulidMark() {
        String mark = "";
        mark += this.encrypt ? "1" : "0";
        mark += this.ack ? "1" : "0";
        mark += "00";
        mark += this.getCd();
        int hexLength = Integer.toHexString(this.lenBytes / 2).length();
        mark += ByteUtils.toBinary(hexLength % 2 == 0 ? hexLength / 2 : hexLength / 2 + 1);
        mark = Integer.toString(Integer.parseInt(mark, 2), 16);
        if (mark.length() % 2 != 0) mark = "0" + mark;
        return mark;
    }

    public String getMark() {
        return mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public boolean isEncrypt() {
        return encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public boolean isAck() {
        return ack;
    }

    public void setAck(boolean ack) {
        this.ack = ack;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCd() {
        return cd;
    }

    public void setCd(String cd) {
        this.cd = cd;
    }

    public int getLenBytes() {
        return lenBytes;
    }

    public void setLenBytes(int lenBytes) {
        this.lenBytes = lenBytes;
    }
}
