package com.jhscale.meter.wifi.service;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.wifi.entity.CMD;
import com.jhscale.meter.wifi.entity.CommandRequest;
import com.jhscale.meter.wifi.entity.JHObject;
import com.jhscale.meter.wifi.model.Content;

import java.util.List;

/**
 * @author lie_w
 * @title: IHexCmd
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2019/9/1819:38
 */
public interface IHexCmd {

    /**
     * 组装 命令数据
     *
     * @param handler 操作者
     * @param objects 下发数据可变数组
     * @return
     */
    CMD assembler(String handler, JHObject... objects);

    /**
     * @param objects 下发数据可变数组
     * @description: 拼装Content 信息
     **/
    String assembler(JHObject... objects);

    /**
     * @description: 内容直接拼装CMD
     **/
    CMD assemblerContentCmd(String handler, String data);

    /**
     * @description: CMD 响应信息拼装
     **/
    String cmdResponseAssembler(CommandRequest request, String aeskey) throws MeterException;

    /**
     * @description: CMD 响应信息拼装 不做AES
     **/
    String cmdResponseAssembler(CommandRequest request);

    /**
     * 解析
     *
     * @param data    待解析数据
     * @param charter 字符集
     * @param base64  是否Base64
     * @return
     */
    @Deprecated
    List<Content> parse(String data, String charter, boolean base64);

    /**
     * @description: 内容解析
     **/
    List<Content> contentParse(byte[] bytes, String charter);

    /**
     * 解析
     *
     * @param data    待解析数据
     * @param charter 字符集
     * @param base64  是否Base64
     * @return
     */
    List<Content> contentParse(String data, String charter, boolean base64);

    /**
     * @description: 解析 默认未压缩
     **/
    List<Content> contentParse(String data, String charter);

    /**
     * CMD AES解密
     *
     * @param aeskey
     * @return
     */
    CommandRequest cmdParse(byte[] bytes, String aeskey) throws MeterException;

    /**
     * CMD AES解密
     *
     * @param cmd
     * @param aeskey
     * @return
     */
    CommandRequest cmdParse(String cmd, String aeskey) throws MeterException;
}
