package com.jhscale.meter.wifi.service.impl;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.wifi.entity.CMD;
import com.jhscale.meter.wifi.entity.CommandRequest;
import com.jhscale.meter.wifi.entity.JHObject;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.WifiCmdUtils;
import com.jhscale.meter.wifi.service.IHexCmd;

import java.util.List;

/**
 * @author lie_w
 * @title: HexCmd
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2019/9/1819:40
 */
public class HexCmd implements IHexCmd {

    /**
     * 组装
     *
     * @param handler 操作者
     * @param objects 下发数据可变数组
     * @return
     */
    @Override
    public CMD assembler(String handler, JHObject... objects) {
        return WifiCmdUtils.assembler(handler, objects);
    }

    /**
     * @param objects 下发数据可变数组
     * @description: 拼装Content 信息
     **/
    @Override
    public String assembler(JHObject... objects) {
        return WifiCmdUtils.assembler(objects);
    }

    /**
     * @param handler
     * @param data
     * @description: 内容直接拼装CMD
     */
    @Override
    public CMD assemblerContentCmd(String handler, String data) {
        return WifiCmdUtils.assemblerByContent(handler, data);
    }

    /**
     * @param request
     * @param aeskey
     * @description: CMD 响应信息拼装
     */
    @Override
    public String cmdResponseAssembler(CommandRequest request, String aeskey) throws MeterException {
        return WifiCmdUtils.response(request, aeskey);
    }

    /**
     * @param request
     * @description: CMD 响应信息拼装 不做AES
     */
    @Override
    public String cmdResponseAssembler(CommandRequest request) {
        request.getPackageMark().setEncrypt(false);
        try {
            return WifiCmdUtils.response(request, null);
        } catch (MeterException e) {
            return null;
        }
    }

    /**
     * 解析
     *
     * @param data    待解析数据
     * @param charter 字符集
     * @param base64  是否Base64
     * @return
     */
    @Override
    public List<Content> parse(String data, String charter, boolean base64) {
        return WifiCmdUtils.parse(data, charter, base64);
    }

    /**
     * @param bytes
     * @param charter
     * @description: 内容解析
     */
    @Override
    public List<Content> contentParse(byte[] bytes, String charter) {
        return WifiCmdUtils.contentParse(bytes, charter);
    }

    /**
     * 解析
     *
     * @param data    待解析数据
     * @param charter 字符集
     * @param base64  是否Base64
     * @return
     */
    @Override
    public List<Content> contentParse(String data, String charter, boolean base64) {
        return WifiCmdUtils.contentParse(data, charter, base64);
    }

    /**
     * @param data
     * @param charter
     * @description: 解析 默认未压缩
     */
    @Override
    public List<Content> contentParse(String data, String charter) {
        return WifiCmdUtils.contentParse(data, charter);
    }

    /**
     * CMD AES解密
     *
     * @param bytes
     * @param aeskey
     * @return
     */
    @Override
    public CommandRequest cmdParse(byte[] bytes, String aeskey) throws MeterException {
        return WifiCmdUtils.cmdParse(bytes, aeskey);
    }

    /**
     * CMD AES解密
     *
     * @param cmd
     * @param aeskey
     * @return
     */
    @Override
    public CommandRequest cmdParse(String cmd, String aeskey) throws MeterException {
        return WifiCmdUtils.cmdParse(cmd, aeskey);
    }
}
