package com.jhscale.test.auncel;

import com.jhscale.meter.auncel.AuncelManager;
import com.jhscale.meter.auncel.AuncelNotify;
import com.jhscale.meter.auncel.cmd.*;
import com.jhscale.meter.auncel.em.CPT;
import com.jhscale.meter.auncel.entity.AuncelResponse;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.utils.ScannerUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title AuncelTest
 * @description
 * @create 2024/1/3 13:39
 */
public class AuncelTest {

    public static void main(String[] args) throws MeterException {
        /**
         * @description: 指令组装解析测试
         **/
        // command_test();

        /**
         * @description: 串口测试
         **/
        serialPort_test();
    }

    /**
     * @description: 串口测试
     **/
    private static void serialPort_test() throws MeterException {
        boolean com3 = AuncelManager.getInstance().Init_Manager(new WSerialPortControl(),
                new SerialDevice("COM3", 115200),
                new AuncelNotify() {
                    /**
                     * @param response
                     * @description: 结果通知
                     */
                    @Override
                    public void notify(AuncelResponse response) {
                        System.out.printf("notify：%s%n", response.toJSON());
                    }

                    /**
                     * @param exception
                     * @description: 异常错误信息
                     */
                    @Override
                    public void exp(MeterException exception) {

                    }
                });
        System.out.printf("Serial Port Open: %s%n", com3);

//        KVM kvm = ScannerUtils.scanner("输入指令编号并回车执行指令", Arrays.asList(
//                new KVM(1, "登录 05"),
//                new KVM(2, "登出 06"),
//                new KVM(3, "修改密码 07"),
//                new KVM(4, "只读 08"),
//                new KVM(5, "只写 09"),
//                new KVM(6, "写入读写内容 0A"),
//                new KVM(7, "读取读写内容 0F"),
//                new KVM(8, "读重量 0B"),
//                new KVM(9, "读皮重 0C"),
//                new KVM(10, "去皮 0D"),
//                new KVM(11, "置零 0E")
//        ));
//
//        if (kvm != null) {
//            System.out.println(kvm.toJSON());
//
//            switch (kvm.getNum()) {
//                case 1:
//                    C_AL_05_Login();
//                    break;
//                case 2:
//                    C_AL_06_Logout();
//                    break;
//                case 3:
//                    C_AL_07_EditPWD();
//                    break;
//                case 4:
//                    C_AL_08_ReadOnly();
//                    break;
//                case 5:
//                    C_AL_09_WriteOnly();
//                    break;
//                case 6:
//                    C_AL_0A_WriteRW();
//                    break;
//                case 7:
//                    C_AL_0F_ReadRW();
//                    break;
//                case 8:
//                    C_AL_0B_ReadWeight();
//                    break;
//                case 9:
//                    C_AL_0C_ReadTare();
//                    break;
//                case 10:
//                    C_AL_0D_SetTare();
//                    break;
//                case 11:
//                    C_AL_0E_SetZero();
//                    break;
//                default:
//                    System.out.println(kvm.toJSON());
//                    break;
//            }
//        }
    }

    private static void C_AL_0E_SetZero() throws MeterException {
        AL_0E_SetZeroResponse response = AuncelManager.getInstance().execute(new AL_0E_SetZeroRequest());
        System.out.printf("C_AL_0E_SetZero 响应内容 %s%n", response.toJSONParse());
    }

    private static void C_AL_0D_SetTare() throws MeterException {
        AL_0D_SetTareResponse response = AuncelManager.getInstance().execute(new AL_0D_SetTareRequest());
        System.out.printf("C_AL_0D_SetTare 响应内容 %s%n", response.toJSONParse());
    }

    private static void C_AL_0C_ReadTare() throws MeterException {
        AL_0C_ReadTareResponse response = AuncelManager.getInstance().execute(new AL_0C_ReadTareRequest());
        System.out.printf("C_AL_0C_ReadTare 响应内容 %s%n", response.toJSONParse());
    }

    private static void C_AL_0B_ReadWeight() throws MeterException {
        AL_0B_ReadWeightResponse response = AuncelManager.getInstance().execute(new AL_0B_ReadWeightRequest());
        System.out.printf("C_AL_0C_ReadTare 响应内容 %s%n", response.toJSONParse());
    }

    private static void C_AL_0F_ReadRW() throws MeterException {
        AL_0F_ReadRWResponse response = AuncelManager.getInstance().execute(new AL_0F_ReadRWRequest());
        System.out.printf("C_AL_0B_ReadWeight 响应内容 %s%n", response.toJSONParse());
    }

    private static void C_AL_0A_WriteRW() throws MeterException {
        AL_0A_WriteRWResponse response = AuncelManager.getInstance().execute(new AL_0A_WriteRWRequest().setBapPara(2));
        System.out.printf("C_AL_0F_ReadRW 响应内容 %s%n", response.toJSONParse());
    }

    private static void C_AL_09_WriteOnly() throws MeterException {
        AL_09_WriteOnlyResponse response = AuncelManager.getInstance().execute(new AL_09_WriteOnlyRequest().setWeightProfile(1).setPrintProfile(2));
        System.out.printf("C_AL_09_WriteOnly 响应内容 %s%n", response.toJSONParse());
    }

    private static void C_AL_08_ReadOnly() throws MeterException {
        AL_08_ReadOnlyResponse response = AuncelManager.getInstance().execute(new AL_08_ReadOnlyRequest());
        System.out.printf("C_AL_08_ReadOnly 响应内容 %s%n", response.toJSONParse());
    }

    private static void C_AL_07_EditPWD() throws MeterException {
        AL_07_EditPWDResponse response = AuncelManager.getInstance().execute(new AL_07_EditPWDRequest().setId(2).setOldPwd("1234").setNewPwd("5678"));
        System.out.printf("C_AL_07_EditPWD 响应内容 %s%n", response.toJSONParse());
    }

    private static void C_AL_06_Logout() throws MeterException {
        AL_06_LogoutResponse response = AuncelManager.getInstance().execute(new AL_06_LogoutRequest().setId(2));
        System.out.printf("C_AL_06_Logout 响应内容 %s%n", response.toJSONParse());
    }

    private static void C_AL_05_Login() throws MeterException {
        AL_05_LoginResponse response = AuncelManager.getInstance().execute(new AL_05_LoginRequest().setId(2).setPwd("123456"));
        System.out.printf("C_AL_05_Login 响应内容 %s%n", response.toJSONParse());
    }

    private static void command_test() throws MeterException {
        // Handle1();
        Handle2();
        // AL_05_Login();
        // AL_06_Logout();
        // AL_07_EditPWD();
        // AL_08_ReadOnly();
        // AL_09_WriteOnly();
        // AL_0A_WriteRW();
        // AL_0F_ReadRW();
        // AL_0B_ReadWeight();
        // AL_0C_ReadTare();
        // AL_0D_SetTare();
        // AL_0E_SetZero();
    }

    private static void AL_0E_SetZero() throws MeterException {
        AL_0E_SetZeroRequest request = new AL_0E_SetZeroRequest().execute();
        System.out.println(String.format("AL_0E_SetZero 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("AL_0E_SetZero 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        AL_0E_SetZeroResponse response = new AL_0E_SetZeroResponse(request, scanner).execute();
        System.out.println(String.format("AL_0E_SetZero 响应内容 %s", response.toJSONParse()));
    }

    private static void AL_0D_SetTare() throws MeterException {
        AL_0D_SetTareRequest request = new AL_0D_SetTareRequest().execute();
        System.out.println(String.format("AL_0D_SetTare 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("AL_0D_SetTare 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        AL_0D_SetTareResponse response = new AL_0D_SetTareResponse(request, scanner).execute();
        System.out.println(String.format("AL_0D_SetTare 响应内容 %s", response.toJSONParse()));
    }

    private static void AL_0C_ReadTare() throws MeterException {
        AL_0C_ReadTareRequest request = new AL_0C_ReadTareRequest().execute();
        System.out.println(String.format("AL_0C_ReadTare 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("AL_0C_ReadTare 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        AL_0C_ReadTareResponse response = new AL_0C_ReadTareResponse(request, scanner).execute();
        System.out.println(String.format("AL_0C_ReadTare 响应内容 %s", response.toJSONParse()));
    }

    private static void AL_0B_ReadWeight() throws MeterException {
        AL_0B_ReadWeightRequest request = new AL_0B_ReadWeightRequest().execute();
        System.out.println(String.format("AL_0B_ReadWeight 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("AL_0B_ReadWeight 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        AL_0B_ReadWeightResponse response = new AL_0B_ReadWeightResponse(request, scanner).execute();
        System.out.println(String.format("AL_0B_ReadWeight 响应内容 %s", response.toJSONParse()));
    }

    private static void AL_0F_ReadRW() throws MeterException {
        AL_0F_ReadRWRequest request = new AL_0F_ReadRWRequest().execute();
        System.out.println(String.format("AL_0F_ReadRW 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("AL_0F_ReadRW 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        AL_0F_ReadRWResponse response = new AL_0F_ReadRWResponse(request, scanner).execute();
        System.out.println(String.format("AL_0F_ReadRW 响应内容 %s", response.toJSONParse()));
    }

    private static void AL_0A_WriteRW() throws MeterException {
        AL_0A_WriteRWRequest request = new AL_0A_WriteRWRequest().setBapPara(2).execute();
        System.out.println(String.format("AL_0A_WriteRW 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("AL_0A_WriteRW 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        AL_0A_WriteRWResponse response = new AL_0A_WriteRWResponse(request, scanner).execute();
        System.out.println(String.format("AL_0A_WriteRW 响应内容 %s", response.toJSONParse()));
    }

    private static void AL_09_WriteOnly() throws MeterException {
        AL_09_WriteOnlyRequest request = new AL_09_WriteOnlyRequest().setWeightProfile(1).setPrintProfile(2).execute();
        System.out.println(String.format("AL_09_WriteOnly 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("AL_09_WriteOnly 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        AL_09_WriteOnlyResponse response = new AL_09_WriteOnlyResponse(request, scanner).execute();
        System.out.println(String.format("AL_09_WriteOnly 响应内容 %s", response.toJSONParse()));
    }

    private static void AL_08_ReadOnly() throws MeterException {
        AL_08_ReadOnlyRequest request = new AL_08_ReadOnlyRequest().execute();
        System.out.println(String.format("AL_08_ReadOnly 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("AL_08_ReadOnly 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        AL_08_ReadOnlyResponse response = new AL_08_ReadOnlyResponse(request, scanner).execute();
        System.out.println(String.format("AL_08_ReadOnly 响应内容 %s", response.toJSONParse()));
    }

    private static void AL_07_EditPWD() throws MeterException {
        AL_07_EditPWDRequest request = new AL_07_EditPWDRequest().setId(2).setOldPwd("1234").setNewPwd("5678").execute();
        System.out.println(String.format("AL_07_EditPWD 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("AL_07_EditPWD 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        AL_07_EditPWDResponse response = new AL_07_EditPWDResponse(request, scanner).execute();
        System.out.println(String.format("AL_07_EditPWD 响应内容 %s", response.toJSONParse()));
    }

    private static void AL_06_Logout() throws MeterException {
        AL_06_LogoutRequest request = new AL_06_LogoutRequest().setId(2).execute();
        System.out.println(String.format("AL_06_Logout 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("AL_06_Logout 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        AL_06_LogoutResponse response = new AL_06_LogoutResponse(request, scanner).execute();
        System.out.println(String.format("AL_06_Logout 响应内容 %s", response.toJSONParse()));
    }

    private static void AL_05_Login() throws MeterException {
        AL_05_LoginRequest request = new AL_05_LoginRequest().setId(2).setPwd("123456").execute();
        System.out.println(String.format("AL_05_Login 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("AL_05_Login 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        AL_05_LoginResponse response = new AL_05_LoginResponse(request, scanner).execute();
        System.out.println(String.format("AL_05_Login 响应内容 %s", response.toJSONParse()));
    }

    private static void Handle2() throws MeterException {
        Handle2Request request = new Handle2Request().setCpt(CPT.LCD_Panel).setSeed("0123456789ABCDEF0123456789ABCDEF").execute();
        System.out.println(String.format("Handle2 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("Handle2 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        Handle2Response response = new Handle2Response(request, scanner).execute();
        System.out.println(String.format("Handle2 响应内容 %s", response.toJSONParse()));
    }

    private static void Handle1() throws MeterException {
        Handle1Request request = new Handle1Request().execute();
        System.out.println(String.format("Handle1 请求内容 %s", request.toJSONParse()));
        String scanner = ScannerUtils.scanner("Handle1 请输入响应：");
        scanner = StringUtils.isBlank(scanner) ? request.over() : scanner;
        Handle1Response response = new Handle1Response(request, scanner).execute();
        System.out.println(String.format("Handle1 响应内容 %s", response.toJSONParse()));
    }


}
