package com.jhscale.test.command;

import com.jhscale.meter.em.WeighingMode;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ad.em.*;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;
import com.jhscale.meter.protocol.ad.entity.assembly.*;
import com.jhscale.meter.protocol.ad.entity.disassembly.*;
import com.jhscale.meter.protocol.ad.entity.inner.Flash_0;
import com.jhscale.meter.utils.ScannerUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author lie_w
 * @title: ADTest
 * @projectName meter-jar
 * @description: AD 协议测试(指令配合串口工具测试)
 * @date 2021/6/1015:50
 */
public class ADProtocolTest {

    public static void main(String[] args) throws MeterException {
        // OTHERS();
        // ADAssemblyTest();
        // ADDisassembly();

        // 基础命令
        basicCMD();

        // 温度命令
        // templateCMD();

        // 背灯命令
        // lightCMD();

        // Flash命令
        // flashCMD();
    }

    /**
     * @description: Flash 命令
     **/
    private static void flashCMD() throws MeterException {
        /**
         * @description: 写Flash命令
         **/
        // A0XC0();

        /**
         * @description: 读Flash命令
         **/
        B0XCO();
    }

    /**
     * @description: 读Flash命令
     **/
    private static void B0XCO() throws MeterException {
        ADPackAssemblyResponse execute = new FlashReadADPARequest().setFlash(Flash.Data_Unique).execute();
        System.out.println("A0XC0:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        FlashReadADPAResponse response = new ADPackDisassemblyRequest<FlashReadADPAResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 写Flash命令
     **/
    private static void A0XC0() throws MeterException {
        ADPackAssemblyResponse execute = new FlashWriteADPARequest()
                .Flash_0(new Flash_0()
                        .setEvent(new Date())
                        .setSerial("20140000000001"))
                .execute();
        System.out.println("A0XC0:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        FlashWriteADPAResponse response = new ADPackDisassemblyRequest<FlashWriteADPAResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 背灯命令
     **/
    private static void lightCMD() throws MeterException {
        /**
         * @description: 后显示设定命令
         **/
//        G0X80();

        /**
         * @description: 背光灯开关命令
         **/
//        H0X80();
        /**
         * @description: 后显示设定命令2
         **/
        J0X80();
    }

    /**
     * @description: 后显示设定命令2
     **/
    private static void J0X80() throws MeterException {
        List<String> vals = new ArrayList<>();
        vals.add("888888");
        vals.add("8888888");
        vals.add("88888888");

        ADPackAssemblyResponse execute = new SetBackDisplay2ADPARequest(vals, null).execute();
        System.out.println("J0X80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ADPackDisassemblyResponse response = new ADPackDisassemblyRequest<>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 后显示设定命令
     **/
    private static void G0X80() throws MeterException {
        List<BigDecimal> vals = new ArrayList<>();
        vals.add(new BigDecimal("0.45"));
        vals.add(new BigDecimal("2.00"));
        vals.add(new BigDecimal("0.90"));

        ADPackAssemblyResponse execute = new SetBackDisplayADPARequest(vals).execute();
        System.out.println("G0X80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ADPackDisassemblyResponse response = new ADPackDisassemblyRequest<>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 背光灯开关命令
     **/
    private static void H0X80() throws MeterException {
        BackLight backLight = ScannerUtils.scanner("请选择背光灯开关：", BackLight.values());

        ADPackAssemblyResponse execute = new OpenCloseBackLightADPARequest(backLight).execute();
        System.out.println("Z0X80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        OpenCloseBackLightADPDResponse response = new ADPackDisassemblyRequest<OpenCloseBackLightADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 温度命令
     **/
    private static void templateCMD() throws MeterException {
        /**
         * @description: 1）温度补偿使能关闭命令
         **/
        A0X80();

        /**
         * @description: 2）温度补偿使能状态读取命令
         **/
        B0X80();

        /**
         * @description: 3）当前温度读取命令
         **/
        C0X80();

        /**
         * @description: 4）进入退出温度补偿状态
         **/
        D0X80();

        /**
         * @description: 5）保存当前零点 
         **/
        E0X80();

        /**
         * @description: 6）保存当前满量程重量
         **/
        F0X80();
    }

    /**
     * @description: 6）保存当前满量程重量
     **/
    private static void F0X80() throws MeterException {
        ADPackAssemblyResponse execute = new SetTemperatureFullScaleADPARequest().execute();

        System.out.println("F0X80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetTemperatureFullScaleADPDResponse response = new ADPackDisassemblyRequest<SetTemperatureFullScaleADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 5）保存当前零点
     **/
    private static void E0X80() throws MeterException {
        ADPackAssemblyResponse execute = new SetTemperatureZeroADPARequest().execute();

        System.out.println("E0X80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetTemperatureZeroADPDResponse response = new ADPackDisassemblyRequest<SetTemperatureZeroADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 4）进入退出温度补偿状态
     **/
    private static void D0X80() throws MeterException {

        TemplatureInExistState inExistState = ScannerUtils.scanner("请选择温度补偿进出：", TemplatureInExistState.values());

        ADPackAssemblyResponse execute = new InExistTemperatureCompensationADPARequest(inExistState).execute();
        System.out.println("D0X80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        InExistTemperatureCompensationADPDResponse response = new ADPackDisassemblyRequest<InExistTemperatureCompensationADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 2）温度补偿使能状态读取命令
     **/
    private static void C0X80() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainTemperatureADPARequest().execute();
        System.out.println("C0X80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainTemperatureADPDResponse response = new ADPackDisassemblyRequest<ObtainTemperatureADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 2）温度补偿使能状态读取命令
     **/
    private static void B0X80() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainTemperatureCompensationADPARequest().execute();
        System.out.println("B0X80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainTemperatureCompensationADPDResponse response = new ADPackDisassemblyRequest<ObtainTemperatureCompensationADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 1）温度补偿使能关闭命令
     **/
    private static void A0X80() throws MeterException {
        TemplatureSwitchState switchState = ScannerUtils.scanner("请选择温度补偿开关：", TemplatureSwitchState.values());

        ADPackAssemblyResponse execute = new OpenCloseTemperatureCompensationADPARequest(switchState).execute();
        System.out.println("A0X80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        OpenCloseTemperatureCompensationADPDResponse response = new ADPackDisassemblyRequest<OpenCloseTemperatureCompensationADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 基础命令
     **/
    private static void basicCMD() throws MeterException {
        /**
         * @description: 发送模式
         **/
        // A();

        /**
         * @description: 模块唯一码读取
         **/
        // B();

        /**
         * @description: 固件升级命令
         **/
        // D();

        /**
         * @description: 置零命令
         **/
        E();

        /**
         * @description: 去皮命令
         **/
        // F();

        /**
         * @description: 版本号读取 暂无响应
         **/
        // G();

        /**
         * @description: 设定皮重命令
         **/
        // I();

        /**
         * @description: 分度值 暂不明白
         **/
        // I0X80();
        // J();

        /**
         * @description: 速率管理
         **/
        // K();
        // L();

        /**
         * @description: 开机零点
         **/
        // M();
        // N();

        /**
         * @description: 开机状态读取命令
         **/
        // O();

        /**
         * @description: 开机零点设定命令（将当前零点设定成新的开机零点，仅在开机超限时使用）
         **/
        // P();

        /**
         * @description: 滤波强度命令
         **/
        // Q();
        // R();

        /**
         * @description: 零点跟踪范围
         **/
        // S();
        // T();

        /**
         * @description: 进入、退出标定
         **/
        // V();

        /**
         * @description: 满量程读取命令
         **/
        // U();
        // W();

        /**
         * @description: 重量标定命令
         **/
        // X();

        /**
         * @description: 内码读取命令
         **/
        // Y();

        /**
         * @description: Ad 码读取命令
         **/
        // Z();

        /**
         * @description: 重力加速度系数设定命令
         **/
        // Z0X80();

        /**
         * @description: 重力加速度系数读取命令
         **/
        // Y0X80();

        /**
         * @description: 切换协议类型
         **/
        // switchProtocol();

        /**
         * @description: 背显强制复位
         **/
        // C0X40();

        /**
         * @description: 读取铅封状态
         * @date: 2024-08-16 09:11:28
         **/
        POX80();
    }

    /**
     * @description: 铅封状态
     * @date: 2024-08-16 09:11:41
     **/
    private static void POX80() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainLeadStatusADPARequest().execute();
        System.out.println("POX80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainLeadStatusADPDResponse response = new ADPackDisassemblyRequest<ObtainLeadStatusADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 背显强制复位
     **/
    private static void C0X40() throws MeterException {
        ADPackAssemblyResponse execute = new BackDisplayResetADPARequest().execute();
        System.out.println("C0X40:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        BackDisplayResetADPAResponse response = new ADPackDisassemblyRequest<BackDisplayResetADPAResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 变更协议
     **/
    private static void switchProtocol() throws MeterException {
        ADProtocol adProtocol = ScannerUtils.scanner("请选择协议版本：", ADProtocol.values());

        ADPackAssemblyResponse execute = new SwitchProtocolRequest(adProtocol).execute();

        System.out.println("switchProtocol:" + execute.toJSONParse());
    }

    /**
     * @description: 26）重力加速度系数设定命令
     **/
    private static void Y0X80() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainGACoefficientADPARequest().execute();
        System.out.println("Y0X80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainGACoefficientADPDResponse response = new ADPackDisassemblyRequest<ObtainGACoefficientADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 26）重力加速度系数设定命令
     **/
    private static void Z0X80() throws MeterException {
        String gacofficient = ScannerUtils.scanner("请输入重量系数[95000-105000]：");

        ADPackAssemblyResponse execute = new SetGACoefficientADPARequest(Integer.parseInt(gacofficient)).execute();
        System.out.println("Z0X80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetGACoefficientADPDResponse response = new ADPackDisassemblyRequest<SetGACoefficientADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 25）Ad 码读取命令
     **/
    private static void Z() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainADCodeADPARequest().execute();
        System.out.println("Z:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainADCodeADPDResponse response = new ADPackDisassemblyRequest<ObtainADCodeADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 24）内码读取命令
     **/
    private static void Y() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainInternalCodeADPARequest().execute();
        System.out.println("Y:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainInternalCodeADPDResponse response = new ADPackDisassemblyRequest<ObtainInternalCodeADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 23）重量标定命令
     **/
    private static void X() throws MeterException {
        String scale = ScannerUtils.scanner("请输入标定重量：");

        ADPackAssemblyResponse execute = new SetWeightScaleADPARequest(new BigDecimal(scale)).execute();
        System.out.println("X:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetWeightScaleADPDResponse response = new ADPackDisassemblyRequest<SetWeightScaleADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 21）进入、退出标定状态命令
     * 进入标定状态必须在模块上插上短路环，此后的命令都须在进入标定命令后执行
     **/
    private static void V() throws MeterException {
        Strandard strandard = ScannerUtils.scanner("请输入标定状态：", Strandard.values());

        ADPackAssemblyResponse execute = new OpenCloseStrandardADPARequest(strandard).execute();
        System.out.println("V:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        OpenCloseStrandardADPDResponse response = new ADPackDisassemblyRequest<OpenCloseStrandardADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 22）满量程设定命令
     **/
    private static void W() throws MeterException {
        String full_scale = ScannerUtils.scanner("请输入满量程[0-16777215]：");
        String double_division = ScannerUtils.scanner("请输入双分度[0-16777215]：");
        String floa = ScannerUtils.scanner("请输入小数点[0-3]：");
        Division division = ScannerUtils.scanner("请选择分度值：", Division.values());

        ADPackAssemblyResponse execute = new SetFullScaleADPARequest(
                Integer.parseInt(full_scale), Integer.parseInt(double_division), Integer.parseInt(floa), division).execute();
        System.out.println("W:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetFullScaleADPDResponse response = new ADPackDisassemblyRequest<SetFullScaleADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 20）满量程读取命令
     **/
    private static void U() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainFullScaleADPARequest().execute();
        System.out.println("U:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainFullScaleADPDResponse response = new ADPackDisassemblyRequest<ObtainFullScaleADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 19）零点跟踪范围读取命令
     **/
    private static void T() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainZeroTrackRangeADPARequest().execute();
        System.out.println("T:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainZeroTrackRangeADPDResponse response = new ADPackDisassemblyRequest<ObtainZeroTrackRangeADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 18）零点跟踪范围设定命令
     **/
    private static void S() throws MeterException {
        ZeroTrackRange trackRange = ScannerUtils.scanner("请选择零点跟踪范围：", ZeroTrackRange.values());

        ADPackAssemblyResponse execute = new SetZeroTrackRangeADPARequest(trackRange).execute();
        System.out.println("S:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetZeroTrackRangeADPDResponse response = new ADPackDisassemblyRequest<SetZeroTrackRangeADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 17）滤波强度读取命令
     **/
    private static void R() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainFilterStrengthADPARequest().execute();
        System.out.println("R:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainFilterStrengthADPDResponse response = new ADPackDisassemblyRequest<ObtainFilterStrengthADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 16）滤波强度设定命令
     **/
    private static void Q() throws MeterException {
        String strength = ScannerUtils.scanner("请输入滤波强度：");

        ADPackAssemblyResponse execute = new SetFilterStrengthADPARequest(Integer.parseInt(strength)).execute();
        System.out.println("Q:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetFilterStrengthADPDResponse response = new ADPackDisassemblyRequest<SetFilterStrengthADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 15）开机零点设定命令（将当前零点设定成新的开机零点，仅在开机超限时使用）
     **/
    private static void P() throws MeterException {
        ADPackAssemblyResponse execute = new CheckBootZeroADPARequest().execute();
        System.out.println("P:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        CheckBootZeroADPDResponse response = new ADPackDisassemblyRequest<CheckBootZeroADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 14）开机状态读取命令
     **/
    private static void O() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainBootStateADPARequest().execute();
        System.out.println("O:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainBootStateADPDResponse response = new ADPackDisassemblyRequest<ObtainBootStateADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 13）开机零点范围读取命令
     **/
    private static void N() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainBootZeroRangeADPARequest().execute();
        System.out.println("N:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainBootZeroRangeADPDResponse response = new ADPackDisassemblyRequest<ObtainBootZeroRangeADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 12）开机零点范围设定命令
     **/
    private static void M() throws MeterException {
        String range = ScannerUtils.scanner("请输入开机零点范围：");

        ADPackAssemblyResponse execute = new SetBootZeroRangeADPARequest(Integer.parseInt(range)).execute();
        System.out.println("M:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetBootZeroRangeADPDResponse response = new ADPackDisassemblyRequest<SetBootZeroRangeADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 11）重量发送速率读取命令
     **/
    private static void L() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainWeighingSendSpeedADPARequest().execute();
        System.out.println("L:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainWeighingSendSpeedADPDResponse response = new ADPackDisassemblyRequest<ObtainWeighingSendSpeedADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 10）重量发送速率设定命令
     **/
    private static void K() throws MeterException {
        String speed = ScannerUtils.scanner("请输入重量发送速率：");

        ADPackAssemblyResponse execute = new SetWeighingSendSpeedADPARequest(Integer.parseInt(speed)).execute();
        System.out.println("K:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetWeighingSendSpeedADPDResponse response = new ADPackDisassemblyRequest<SetWeighingSendSpeedADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 9）分度值读取命令
     **/
    private static void J() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainDivisionADPARequest().execute();
        System.out.println("J:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainDivisionADPDResponse response = new ADPackDisassemblyRequest<ObtainDivisionADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 8）分度值设定命令
     **/
    private static void I0X80() throws MeterException {
        Division division = ScannerUtils.scanner("请选择分度值：", Division.values());

        ADPackAssemblyResponse execute = new SetDivisionADPARequest(division).execute();
        System.out.println("I0X80:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetDivisionADPDResponse response = new ADPackDisassemblyRequest<SetDivisionADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 7） 设皮命令
     **/
    private static void I() throws MeterException {
        String peeled = ScannerUtils.scanner("请输入皮重[0-16777215]：");

        ADPackAssemblyResponse execute = new SetPeeledADPARequest(new BigDecimal(peeled)).execute();
        System.out.println("I:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetPeeledADPDResponse response = new ADPackDisassemblyRequest<SetPeeledADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 6）版本号读取命令 暂时没有响应
     **/
    private static void G() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainVersionADPARequest().execute();
        System.out.println("G:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainVersionADPDResponse response = new ADPackDisassemblyRequest<ObtainVersionADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 5）去皮命令
     **/
    private static void F() throws MeterException {
        ADPackAssemblyResponse execute = new SetPeeledZeroADPARequest().execute();
        System.out.println("F:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetPeeledZeroADPDResponse response = new ADPackDisassemblyRequest<SetPeeledZeroADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 5）置零命令
     **/
    private static void E() throws MeterException {
        ADPackAssemblyResponse execute = new SetZeroADPARequest().execute();
        System.out.println("E:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetZeroADPDResponse response = new ADPackDisassemblyRequest<SetZeroADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 4）固件升级命令
     **/
    private static void D() throws MeterException {
        ADPackAssemblyResponse execute = new UpgradeFirmwareADPARequest().execute();
        System.out.println("D:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        UpgradeFirmwareADPDResponse response = new ADPackDisassemblyRequest<UpgradeFirmwareADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 模块唯一码读取命令（读取模块唯一编码）
     **/
    private static void B() throws MeterException {
        ADPackAssemblyResponse execute = new ObtainMacADPARequest().execute();
        System.out.println("D:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        ObtainMacADPDResponse response = new ADPackDisassemblyRequest<ObtainMacADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }

    /**
     * @description: 模式设定命令（设定重量发送模式）
     **/
    private static void A() throws MeterException {
        WeighingMode mode = ScannerUtils.scanner("请选择模式", WeighingMode.values());

        ADPackAssemblyResponse execute = new SetWeighingModelADPARequest(mode).execute();
        System.out.println("A:" + execute.toJSONParse());

        String scanner = ScannerUtils.scanner("请输入响应：");

        SetWeighingModelADPDResponse response = new ADPackDisassemblyRequest<SetWeighingModelADPDResponse>(scanner).execute();
        System.out.println(response.toJSONParse());
    }


    /**
     * @description: 解析测试
     **/
    private static void ADDisassembly() throws MeterException {
        // 读取重量响应
        ObtainWeightADPDResponse obtainWeigthADPDResponse = new ADPackDisassemblyRequest<ObtainWeightADPDResponse>("9C 4D 4A 23 73 7B C9 C9 F2 5B 8B ").execute();
        System.out.println(obtainWeigthADPDResponse.toJSONParse());

        // 读取重量响应
        ObtainWeightADPDResponse obtainWeigthADPDResponse1 = new ADPackDisassemblyRequest<ObtainWeightADPDResponse>("9C4DE48F2FFA916FBA9C8B").execute();
        System.out.println(obtainWeigthADPDResponse1.toJSONParse());

        // 读取版本响应
        ObtainVersionADPDResponse obtainVersionADPDResponse = new ADPackDisassemblyRequest<ObtainVersionADPDResponse>("9C7DF6008ED07D2B28DDF28B").execute();
        System.out.println(obtainVersionADPDResponse.toJSONParse());

        // 设置模式响应
        SetWeighingModelADPDResponse setWeighingModelADPDResponse = new ADPackDisassemblyRequest<SetWeighingModelADPDResponse>("9C9CDF71920E8B").execute();
        System.out.println(setWeighingModelADPDResponse.toJSONParse());

        // 获取Mac响应
        ObtainMacADPDResponse obtainMacADPDResponse = new ADPackDisassemblyRequest<ObtainMacADPDResponse>("9C 7D BA C9 E2 97 D0 6E CF 24 BB 8B").execute();
        System.out.println(obtainMacADPDResponse.toJSONParse());

        // 满量程读取命令
        ObtainFullScaleADPDResponse obtainFullScaleADPDResponse = new ADPackDisassemblyRequest<ObtainFullScaleADPDResponse>("9C 4D 41 93 61 B3 1B FD 3D 4F 8B").execute();
        System.out.println(obtainFullScaleADPDResponse.toJSONParse());
        RangeDivision rangeDivision = RangeDivision.getRangeDivision(obtainFullScaleADPDResponse.getScale());
        System.out.println(rangeDivision.toString());

        // 内码读取命令
        ObtainInternalCodeADPDResponse obtainInternalCodeADPDResponse = new ADPackDisassemblyRequest<ObtainInternalCodeADPDResponse>("9C 2E E3 05 1B F4 A1 87 9D 8B ").execute();
        System.out.println(obtainInternalCodeADPDResponse.toJSONParse());
    }

    /**
     * @description: 组装测试
     **/
    private static void ADAssemblyTest() throws MeterException {
        ADPackAssemblyResponse execute = new SetWeighingModelADPARequest(WeighingMode.Continuous).execute();
        System.out.println("A:" + execute.toJSONParse());

        execute = new ObtainMacADPARequest().execute();
        System.out.println("B:" + execute.toJSONParse());

        execute = new UpgradeFirmwareADPARequest().execute();
        System.out.println("D:" + execute.toJSONParse());

        execute = new SetZeroADPARequest().execute();
        System.out.println("E:" + execute.toJSONParse());

        execute = new SetPeeledZeroADPARequest().execute();
        System.out.println("F:" + execute.toJSONParse());
    }

    // /**
    //  * @description: 其他测试
    //  **/
    // private static void OTHERS() throws MeterException {
    //     byte[] bytes = "Z".getBytes();
    //     System.out.println(bytes);

    //     byte b = (byte) (bytes[0] + 0x80);

    //     byte[] bytes1 = {b};
    //     System.out.println(new String(bytes1));

    //     System.out.println(ByteUtils.toHexString(bytes1));
    //     System.out.println(ByteUtils.toHexString("A".getBytes()));

    //     ADScaleProtocolManager manager = new ADScaleProtocolManager();
    //     manager.initPortmanager(new SerialPort(new WSerialPortControl(),
    //             new SerialDevice("COM3", 9600), new DeviceClientEventListener() {
    //         /**
    //          * @param bytes
    //          * @description: 连接监听
    //          */
    //         @Override
    //         public void onClientEvent(byte[] bytes) {

    //         }

    //         /**
    //          * @param e
    //          * @description: 连接异常监听
    //          */
    //         @Override
    //         public void onClientEventExp(MeterException e) {

    //         }

    //         /**
    //          * @param key
    //          * @param response
    //          * @description: 发送命令添加回调
    //          */
    //         @Override
    //         public void addProtocolResponse(String key, IProtocolResponse response) {

    //         }
    //     }
    //     ), new IProtocolResponse<SetWeighingModelADPDResponse>() {
    //         @Override
    //         public void target(SetWeighingModelADPDResponse target) {

    //         }

    //         @Override
    //         public void exp(MeterException e) {

    //         }
    //     });

    //     ADPackAssemblyResponse adPackAssemblyResponse = new ObtainMacADPARequest().execute();
    //     ADPackAssemblyResponse assembly = (ADPackAssemblyResponse) manager.execute(new ObtainMacADPARequest());

    //     SetWeighingModelADPDResponse setWeighingModelADPDResponse = new ADPackDisassemblyRequest<SetWeighingModelADPDResponse>("").execute();
    //     SetWeighingModelADPDResponse disassembly = (SetWeighingModelADPDResponse) manager.execute(new ADPackDisassemblyRequest<SetWeighingModelADPDResponse>(""));
    // }
}
