package com.jhscale.test.lora;

import com.jhscale.common.utils.FileUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.lora.LoRaAction;
import com.jhscale.meter.lora.LoRaDevice_EZY;
import com.jhscale.meter.lora.LoRaHost;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.utils.ScannerUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: LoraTest
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/4/270:25
 */
public class LoRaTest {

    public static void main(String[] args) throws MeterException {
        // test();

        LoRaHost.getInstance().Init_Manager(new WSerialPortControl(), new SerialDevice("COM2", 115200), 2000);

        LoRaHost.getInstance().addDevice(
                new LoRaDevice_EZY(1, "Left"),
                new LoRaDevice_EZY(2, "Right"));

        LoRaHost.getInstance().Init_AsWorking(0, new LoRaAction() {
            @Override
            public void execute() {
                LoRaHost.getInstance().Task_Clear();
                LoRaHost.getInstance().CMD_Version();
            }
        });

        int value = 0;

        while (true) {
            String scanner = ScannerUtils.scanner("请输入发送指令：");
            //while(StringUtils.isBlank(scanner)) ;

            if (StringUtils.isNumeric(scanner) && scanner.length() > 0)
                value = Integer.parseInt(scanner);
            else {
                switch (scanner) {
//                case "0":
//                    LoRaHost.Init_AsMatching();
//                    break;
//                case "1":
//                    LoRaHost.CMD_ChangeDevicePara(0,1,LoRaHost.getInstance().para,true);
//                    break;
//                case "2":
//                    LoRaHost.CMD_ChangeDevicePara(0,2,LoRaHost.getInstance().para,true);
//                    break;
//                case "3":
//                    LoRaHost.Init_AsWorking(0);
//                    break;
                    case "":
                        LoRaHost.getInstance().Task_Clear();
                        break;
                    case "TW":
                    case "tw":
                        LoRaHost.getInstance().Task_All();
                        break;
                    case "W":
                    case "w":
                        ((LoRaDevice_EZY) LoRaHost.getInstance().getDevice(1)).CMD_Weight(value);
                        break;
                    case "Z":
                    case "z":
                        ((LoRaDevice_EZY) LoRaHost.getInstance().getDevice(1)).CMD_Zero(true);
                        break;
                    case "T":
                    case "t":
                        ((LoRaDevice_EZY) LoRaHost.getInstance().getDevice(1)).CMD_Tare(true);
                        break;
                    case "TT":
                    case "tt":
                        ((LoRaDevice_EZY) LoRaHost.getInstance().getDevice(1)).CMD_Tare(new BigDecimal(value), true);
                        break;
                    case "T1":
                    case "t1":
                        ((LoRaDevice_EZY) LoRaHost.getInstance().getDevice(1)).CMD_Tare(BigDecimal.ONE, true);
                        break;
                    case "T2":
                    case "t2":
                        ((LoRaDevice_EZY) LoRaHost.getInstance().getDevice(1)).CMD_Tare(BigDecimal.valueOf(2), true);
                        break;
                    case "CAL":
                    case "cal":
                        ((LoRaDevice_EZY) LoRaHost.getInstance().getDevice(1)).CMD_Calibrate(new BigDecimal("0.2"), 3000, 3, 300000, 0, 0);
                        break;
//                case "9":
//                    LoRaHost.getInstance().getDevice(2).CMD_Routine();
//                    break;
                }
            }
            // 休眠1秒结束
            //sleep(1);
        }
    }

    /**
     * @description: 获取指令
     **/
    public static String command(String scanner) {
        while (StringUtils.isNotBlank(scanner)) {
            switch (scanner) {
                case "1":
                    return scanner;
                case "2":
                    return scanner;
                case "3":
                    return scanner;
            }
        }
        return "";
    }

    public static final File file = new File("F:\\JHScale\\Resources", "TEST.txt");

    /**
     * @description: 文件读写
     **/
    private static void readAndWriteFile() {
        FileUtils.writer("新文件", file);
        String reader = FileUtils.reader(file);
        System.out.println(reader);
        FileUtils.writer("追加写", file, true);
        String reader1 = FileUtils.reader(file);
        System.out.println(reader1);
    }

}
