package com.jhscale.test.mqtt;

import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.SerialPort;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.mqtt.*;
import com.jhscale.meter.mqtt.cmd.*;
import com.jhscale.meter.mqtt.data.TruckData;
import com.jhscale.meter.mqtt.data.TruckLog;
import com.jhscale.meter.mqtt.em.*;
import com.jhscale.meter.mqtt.entity.*;
import com.jhscale.meter.protocol.ad.em.CommunicationState;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.utils.AesHexUtils;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.test.mqtt.entity.TestCommand1Request;
import com.jhscale.test.mqtt.entity.TestData;
import com.jhscale.test.serial.PortManagerTest;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.*;

/**
 * @author lie_w
 * @title: TruckTest
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/11/410:01
 */
public class MQTTTest {

//    static {
//        JLog.init(new JavaLog());
//    }

    private static final Integer NID = 0;
    private static final String USER = "U0001";
    private static final String UID = "18082350542";
    private static final String CODING = "C";
    private static final String KEY = "5E738798E6E4256B2DDAB863ADB88C976A43CEBFB5071718";
    private static final String KEYD = "F8263FC036CD9B2504D8D5218C410A833933FC88B12A8D06";

    private static SerialPort serialPort;

    // 需要执行的命令列表
    private static List<MQTTCMD> CMDS = new ArrayList();
    private static Map<String, DefaultBack> commandMap = new HashMap<>();

    public static void main(String[] args) throws MeterException {
        /**
         * @description: 指令组装解析测试
         **/
        // command_test();

        /**
         * @description: 指令数据流测试
         **/
        // command_data();

        /**
         * @description: 内部指令测试
         **/
        // inner_command_test();

        /**
         * @description: 串口测试
         **/
        // serial_port_test();

        /**
         * @description: 工具测试
         **/
        // mqtt_tool_test();

        /**
         * @description: 字段注解测试
         **/
        // annotations_test();

        /**
         * @description: AES测试
         **/
        // aesTest();

        /**
         * @description: 实际指令测试
         **/
        // actual_test();

        /**
         * @description: 数据流
         **/
        // data();
         contentParse();

        // TruckLog truckLog = new TruckLog(DCmd.SEND, ByteUtils.hex2Ten("45"));
        // truckLog.setDate(new Date());
        // truckLog.setType(0);
        // truckLog.setPluNo(0);
        // truckLog.setUnit(3);
        // truckLog.setGross(BigDecimal.valueOf(43.2));
        // truckLog.setTare(BigDecimal.valueOf(43.2));
        // truckLog.setWeight(BigDecimal.valueOf(43.2));
        // truckLog.setCarNum("沪0000");
        // truckLog.setPayType(0);
        // truckLog.setPayMoney(BigDecimal.valueOf(0.01));
        // System.out.println(truckLog.toJSON());

        // String data = MQTTPackBuilder.packSubContent(Arrays.asList(truckLog), null, false);
        // System.out.println(data);

        // List<IMQTT> imqtts = MQTTUnpackBuilder.unpackSubContent(data, null, false);
        // System.out.println(imqtts.get(0).toJSON());
    }

    /**
     * @description: 指令数据流测试
     **/
    private static void command_data() throws MeterException {
        TruckData truckData = new TruckData(DCmd.REQUEST, 0);
        truckData.setData("");
        String over = MQTTBuilder.packBuilder()
                .mark(new Mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.API))
                .mqttClient(new MQTTClient()
                        .appendNid(300)
                        .appendKey(KEY))
                .add(truckData)
                .spack()
                .over();
        System.out.println(over);

        unpack(over);
    }

    /**
     * @description: 数据流
     **/
    private static void data() {
        String data = "41 41 41 31 32 33 00 9F B8 BF 41 9C 2E B1 05 FE A2 6A E0 13 2D 28 12";
        data = data.replace(" ", "");
        System.out.println(data);
        try {
            String decrypt0 = AesHexUtils.decrypt(data, "F8 26 3F C0 36 CD 9B 25 04 D8 D5 21 8C 41 0A 83 39 33 FC 88 B1 2A 8D 06".replace(" ", ""));
            System.out.println(decrypt0);
        } catch (MeterException e) {
            e.printStackTrace();
        }

        try {
            String decrypt1 = AesHexUtils.decrypt(data, "5E 73 87 98 E6 E4 25 6B 2D DA B8 63 AD B8 8C 97 6A 43 CE BF B5 07 17 18 ".replace(" ", ""));
            System.out.println(decrypt1);
        } catch (MeterException e) {
            e.printStackTrace();
        }
    }

    private static void actual_test() throws MeterException {
        BigDecimal bigDecimal = new BigDecimal("10");
        String string = bigDecimal.toString();
        int index = string.indexOf(".");
        int f = string.length() - index - 1;
        System.out.println(f);

        BigDecimal multiply = new BigDecimal("105.0").multiply(new BigDecimal("10.00"));
        System.out.println(multiply);
        DecimalFormat df = new DecimalFormat("#0.00");
        multiply = new BigDecimal(df.format(multiply));
        System.out.println(multiply);
//        String content = "020100013904014141413132330055303030310039453134304330353745413831444435333035007463703A2F2F34372E3130322E3134322E3130002C017103";
        String content = "0285040130A154751D4413B4359925FD587F2A6375A93A59684605D21BBC4B533570F3E3CCD90F9AAF6051E1F4D22BA2FABD2B1EDFC703";
        MQTTUnpackBuilder unpackBuilder = MQTTBuilder.unpackBuilder()
                .loader(new ServerMQTTLoader() {
                    @Override
                    public ModuleInfo keyAndEncoding(String uid) {
                        return new ModuleInfo(CODING, "0FCAF3DABA129B0C2D8389C750D9A00E18B52D8ED65E897B");
                    }
                })
                .content(content)
                .sunpack();
        System.out.println(unpackBuilder.toJSON());
    }

    private static void aesTest() {
        String uid = "AAA123";
        String user = "U0001";
        String password = "1231A123";
        String random = "11223344";
        String KEY = MQTTBuilder.buildKey(uid, user, password, random);
        System.out.println(KEY);
//        System.out.println(s.length());
        String AES_KEY = "5E738798E6E4256B2DDAB863ADB88C976A43CEBFB5071718";
        System.out.println(AES_KEY);
        System.out.println("-----------");
        System.out.println(KEY.substring(8));
        System.out.println(AES_KEY.substring(8));
//        System.out.println(AES_KEY.length());

//        String aeskey = "9E140C057EA81DD53056F6E538B5688E";
//        System.out.println(aeskey.length());
//        String accept = "02c539001e26ce251a6d62e12c2da24b2eb49e4bb21c36b1b1eff8522e70bf522b76a0c8399b6503";
//        String content = "02004114003612000054ec24290d163838";
//        String send = "02c5390011EA913573F30B5C62FD0907B0D9DCF8F393E82D68C041EA77D4146F885F792D67E1D703";
//        try {
//            String str = "02004114003612000054ec24290d163838".toUpperCase();
//            String key = "12345678901234567890123456789012";
//            String appendFill = ByteUtils.appendFill(str);
//            System.out.println(appendFill);
//
//            String encrypt = AesHexUtils.encrypt(appendFill, aeskey);
//            System.out.println(encrypt);
//
//            String decrypt = AesHexUtils.decrypt(encrypt, aeskey);
//            System.out.println(decrypt);
//            System.out.println(str);
//
//            System.out.println(decrypt.contains(str));
//        } catch (MeterException e) {
//            e.printStackTrace();
//        }
    }

    /**
     * @description:
     **/
    private static void annotations_test() {
        TestCommand1Request request = new TestCommand1Request();
        request.setImei("1111");
        request.setSimId("2222");

        IMQTT imqtt = request.appendFloat();
        System.out.println(imqtt.over());

        char[] chars = imqtt.parseFloat();
        System.out.println(chars);

    }

    /**
     * @description: 工具测试
     **/
    private static void mqtt_tool_test() {
        text();
        System.out.println("------------------------------");
        date();
        System.out.println("------------------------------");
        bigDecimal();
        System.out.println("------------------------------");
        character();
    }

    private static void character() {
        char key = 'Y';
        IMQTT imqtt = new IMQTT();
        imqtt.append(key);
        System.out.println(key + " target: " + imqtt.over());

        Character key2 = imqtt.parseChar();
        System.out.println(key + " after: " + key2);
        System.out.println(key + " result:" + (key2 == key));
    }

    private static void bigDecimal() {
        String key = "BigDecimal";
        BigDecimal bigDecimal = new BigDecimal("15.3");
        System.out.println(key + " source: " + bigDecimal);
        IMQTT imqtt = new IMQTT();
        imqtt.append(bigDecimal);
        System.out.println(key + " target: " + imqtt.over());

        BigDecimal bigDecimal2 = imqtt.parseBigDecimal();
        System.out.println(key + " after: " + bigDecimal2);
        System.out.println(key + " result:" + (bigDecimal.compareTo(bigDecimal2) == 0));

        System.out.println("******************************");

        BigDecimal bigDecimal3 = new BigDecimal("45663.46");
        System.out.println(key + " source: " + bigDecimal3);
        IMQTT imqtt3 = new IMQTT();
        imqtt3.append(bigDecimal3);
        System.out.println(key + " target: " + imqtt3.over());

        BigDecimal bigDecimal4 = imqtt3.parseBigDecimal();
        System.out.println(key + " after: " + bigDecimal4);
        System.out.println(key + " result:" + (bigDecimal3.compareTo(bigDecimal4) == 0));
    }

    private static void date() {
        String key = "Date";
        Date date1 = new Date();
        String date1Str = DateUtils.getFormatDate(date1, DateUtils.YYYY_MM_DD_HH_MM_SS);
        System.out.println(key + " source: " + date1Str);
        IMQTT imqtt = new IMQTT();
        imqtt.append(date1);
        System.out.println(key + " target: " + imqtt.over());
        Date date2 = imqtt.parseDate();
        String date2Str = DateUtils.getFormatDate(date2, DateUtils.YYYY_MM_DD_HH_MM_SS);
        System.out.println(key + " after: " + date2Str);
        System.out.println(key + " result:" + date1Str.equals(date2Str));
    }

    private static void text() {
        String key = "TEXT";
        String text1 = "460115875600333";
        System.out.println(key + " source: " + text1);
        IMQTT imqtt = new IMQTT();
        imqtt.append(text1);
        System.out.println(key + " target: " + imqtt.over());
        String text2 = imqtt.parseText();
        System.out.println(key + " after: " + text2);
        System.out.println(key + " result:" + text1.equals(text2));
    }

    /**
     * @description: 串口测试
     **/
    private static void serial_port_test() {
        try {
            serialPort = new SerialPort(new WSerialPortControl(),
                    new SerialDevice<>("COM3", 9600, 0),
                    new DefaultTruckClientEventListener());

            CMDS.add(MQTTCMD.X0100_read_module);

            Thread bufferExecute = bufferExecute();

            boolean OPEN = serialPort.openPort();
            System.out.println("OPEN: " + OPEN);

            if (OPEN) {
                Thread cmdExecute = cmdExecute();

                PortManagerTest.sleep(3600);

                boolean CLOSE = serialPort.closePort();
                System.out.println("CLOSE: " + CLOSE);

                bufferExecute.stop();
                cmdExecute.stop();
            }
        } catch (MeterException e) {
            e.printStackTrace();
        }
    }

    /**
     * @description: 写出内容
     **/
    public static void write(String cacheKey, String command, DefaultBack defaultBack) {
        try {
            commandMap.put(cacheKey, defaultBack);
            serialPort.writeDataImmediately(ByteUtils.fromHexString(command));
        } catch (MeterException e) {
            e.printStackTrace();
        }
    }

    /**
     * @description: 串口主动获取信息
     **/
    private static void base_module() throws MeterException {
        X0100_RReadModule x0100_rReadModule = new X0100_RReadModule();
        x0100_rReadModule.setType(0);

        MQTTPackBuilder packBuilder = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0100_rReadModule)
                .spack();
        String command = packBuilder.over();
        System.out.println(command);
        write(packBuilder.cacheKey(), command, new DefaultBack() {
            @Override
            public void response(Object response) {
                System.out.println("base_module 请求响应信息：" + JSONUtils.objectToJSON(command));
                PortManagerTest.sleep(20);
                CMDS.add(MQTTCMD.X0100_read_module);
            }
        });
    }

    /**
     * @description: 串口断开连接
     **/
    private static void base_break() throws MeterException {
        MQTTPackBuilder packBuilder = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(new X0101_RMQTTBreak())
                .spack();

        String command = packBuilder.over();
        System.out.println(command);
        write(packBuilder.cacheKey(), command, new DefaultBack() {
            @Override
            public void response(Object command) {
                System.out.println("base_break 请求响应信息：" + JSONUtils.objectToJSON(command));
            }
        });
    }

    /**
     * @description: 命令处理
     */
    private static Thread cmdExecute() {
        Thread thread = new Thread() {
            @Override
            public void run() {
                while (true) {
                    Iterator<MQTTCMD> iterator = CMDS.iterator();
                    if (iterator.hasNext()) {
                        MQTTCMD next = iterator.next();
                        try {
                            switch (next) {
                                case X0100_read_module:
                                    base_module();
                                    break;
                                case X0101_mqtt_break:
                                    base_break();
                                    break;
                            }
                        } catch (MeterException e) {
                            e.printStackTrace();
                        }
                        iterator.remove();
                    }
                    PortManagerTest.sleep(1);
                }
            }
        };
        thread.start();
        return thread;
    }

    /**
     * @description: 缓冲区数据处理
     */
    private static Thread bufferExecute() {
        DefaultTruckClientEventListener clientEventListener = (DefaultTruckClientEventListener) serialPort.getClientEventListener();
        Thread thread = new Thread() {
            @Override
            public void run() {
                while (true) {
                    Iterator<String> iterator = clientEventListener.buffers.iterator();
                    String content = "";
                    while (iterator.hasNext()) {
                        content += iterator.next();
                        iterator.remove();

                        MQTTContentBuffer buffer = new MQTTContentBuffer().validContent(content);

                        if (StringUtils.isNotBlank(buffer.content())) {
                            System.out.println("有效数据包: " + buffer.getContent());

                            try {
                                MQTTUnpackBuilder builder = new MQTTUnpackBuilder()
                                        .loader(new ServerMQTTLoader() {
                                            @Override
                                            public ModuleInfo keyAndEncoding(String uid) {
                                                return new ModuleInfo(CODING, KEY);
                                            }
                                        })
                                        .content(buffer.content())
                                        .sunpack();
                                System.out.println("串口接受响应信息：" + builder.toJSON());

                                DefaultBack defaultBack = commandMap.get(builder.cacheKey());
                                if (Objects.nonNull(defaultBack)) {
                                    defaultBack.response(builder.getImqtts());
                                }
                            } catch (MeterException e) {
                                e.printStackTrace();
                            }
                        }
                        content = buffer.surplus();
                    }
                    if (StringUtils.isNotBlank(content)) {
                        clientEventListener.buffers.add(0, content);
                    }
                    PortManagerTest.sleep(1);
                }
            }
        };
        thread.start();
        return thread;
    }

    /**
     * @description: 发送接受响应回调函数
     **/
    private interface DefaultBack {
        void response(Object command);
    }


    /**
     * @description: 默认通讯器
     **/
    private static class DefaultTruckClientEventListener implements DeviceClientEventListener {

        private List<String> buffers = Collections.synchronizedList(new ArrayList<>());

        /**
         * @param bytes
         * @description: 连接监听
         */
        @Override
        public void onClientEvent(byte[] bytes) throws MeterException {
            String content = ByteUtils.toHexString(bytes);
            System.out.println(String.format("onClientEvent: ASCII:[%s]；HEX:[%s]", new String(bytes), content));
            buffers.add(content);
        }

        /**
         * @param e
         * @description: 连接异常监听
         */
        @Override
        public void onClientEventExp(MeterException e) {
            System.out.println("onClientEventExp: " + e.getMessage());
        }

        /**
         * @param key
         * @param response
         * @description: 发送命令添加回调
         */
        @Override
        public void addProtocolResponse(String key, ProtocolEntity response) {
            System.out.println("addProtocolResponse: " + key);
        }

        /**
         * @param communication
         * @description: 设置通讯状态模式
         */
        @Override
        public void setCommunication(CommunicationState communication) {

        }

        /**
         * @description: 获取当前通讯协议状态
         **/
        @Override
        public CommunicationState getCommunication() {
            return null;
        }

        /**
         * @description: 监听器停止
         **/
        @Override
        public void stop() {

        }
    }

    /**
     * @description: Command测试
     **/
    private static void command_test() throws MeterException {
//        X0100_RReadModule();
//        X0101_RMQTTBreak();
//        X0104_RMQTTLink();
//        X0164_RSetTopic();
//        X0167_RModule_Heart();
//        X0168_RModule_Subscribe();
//        X0104_SMQTTLink();
//        X0106_SBind1();

//        TestData();
//        truckLog();
//        X0160_RLbslocRssis();
//        X0166_SModule_Time();

//        X0400_RObtian_Sensor();
//        X0400_SObtian_Sensor();
//
//        X0402_RInit();
//        X0402_SInit();
//
        X0140_RReportApply();
//        X0140_SReportApply();

//        X0169_RLCD_Display();
//        X0169_SLCD_Display();

//        X0404_RPay_Apply();
//        X0404_SPay_Apply();

//        X0406_Order_Print();
    }

    private static void X0406_Order_Print() {
        X0406_ROrder_Print x0406ROrderPrint = new X0406_ROrder_Print();
        x0406ROrderPrint.setCharset(Encoding.GBK.getCharset());
        x0406ROrderPrint.setFid(45);
        x0406ROrderPrint.setNo("111");
        x0406ROrderPrint.setTitle("request.getTitle()");
        x0406ROrderPrint.setSvpnno("1234");
        x0406ROrderPrint.setWeight(new BigDecimal("143.0"));
        x0406ROrderPrint.setMoney(new BigDecimal("200.00"));
        x0406ROrderPrint.setPayType(1);
        x0406ROrderPrint.setCar("沪C710XX");
        x0406ROrderPrint.setFinishTime(new Date());
        System.out.println(x0406ROrderPrint.toJSON());
        String over = x0406ROrderPrint.packSubContent().over();
        System.out.println(over);

        X0406_ROrder_Print x0406ROrderPrint1 = new X0406_ROrder_Print();
        x0406ROrderPrint1.setBuffer(new StringBuffer(over.substring(4)));
        x0406ROrderPrint1.setCharset(Charset.forName("GBK"));
        x0406ROrderPrint1.fillingSub();
        System.out.println(x0406ROrderPrint1.toJSON());
    }

    /**
     * @description: LCD显示
     **/
    private static void X0404_SPay_Apply() throws MeterException {
        X0169_SLCD_Display x0169_slcd_display = new X0169_SLCD_Display()
                .setStatus('Y');

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Response, Confirm.NWAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0169_slcd_display)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: LCD显示
     **/
    private static void X0404_RPay_Apply() throws MeterException {
        X0404_RPay_Apply x0404_rPay_apply = new X0404_RPay_Apply();
        x0404_rPay_apply.setFid(45);
        x0404_rPay_apply.setUnit(1);
        x0404_rPay_apply.setWeight(BigDecimal.valueOf(134.0));


        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.AES_Encrypt, ACK.Request, Confirm.WAIT, CD.CMD)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0404_rPay_apply)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: LCD显示
     **/
    private static void X0169_SLCD_Display() throws MeterException {
        X0169_SLCD_Display x0169_slcd_display = new X0169_SLCD_Display()
                .setStatus('Y');

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Response, Confirm.NWAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0169_slcd_display)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: LCD显示
     **/
    private static void X0169_RLCD_Display() throws MeterException {
        X0169_RLCD_Display x0169_rlcd_display = new X0169_RLCD_Display()
                .setType(3)
                .setAction(0)
                .setTimeout(60)
                .setText1("https://blog.csdn.net/qq135595696/article/details/128782494")
                .setText2("请扫码绑定");

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0169_rlcd_display)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: 读取模块信息
     **/
    private static void X0402_RInit() throws MeterException {
        X0402_RInit x0402_rInit = new X0402_RInit();

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.CMD)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0402_rInit)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: 读取模块信息
     **/
    private static void X0402_SInit() throws MeterException {
        X0402_SInit x0402_sInit = new X0402_SInit();

        UniqueSensor sensor0 = new UniqueSensor();
        sensor0.setIndex(0);
        sensor0.setAddress(0);
        sensor0.setUnique("A0148E30A0148E30");
        x0402_sInit.addSensors(sensor0);

        UniqueSensor sensor1 = new UniqueSensor();
        sensor1.setIndex(1);
        sensor1.setAddress(1);
        sensor1.setUnique("A0148E31A0148E31");
        x0402_sInit.addSensors(sensor1);

        UniqueSensor sensor2 = new UniqueSensor();
        sensor2.setIndex(2);
        sensor2.setAddress(2);
        sensor2.setUnique("A0148E32A0148E32");
        x0402_sInit.addSensors(sensor2);

        UniqueSensor sensor3 = new UniqueSensor();
        sensor3.setIndex(3);
        sensor3.setAddress(3);
        sensor3.setUnique("A0148E33A0148E33");
        x0402_sInit.addSensors(sensor3);

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Response, Confirm.NWAIT, CD.CMD)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0402_sInit)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: Command测试
     **/
    private static void inner_command_test() throws MeterException {
        Mark mark = new Mark();
        mark.setAck(ACK.Response);
        IMQTT imqtt = null;

        String innerContent = "6001fe2fe139755b7b0114";
        imqtt = new ICMD(innerContent).unpackSubContent(mark);
        System.out.println(imqtt.toJSON());

        innerContent = "6101005934363031313538373536303033333300383938363033323039343032313734333933313500";
        imqtt = new ICMD(innerContent).unpackSubContent(mark);
        System.out.println(imqtt.toJSON());
    }

    /**
     * @description: 汽车衡日志
     **/
    private static void truckLog() throws MeterException {
//        TruckLog truckLog = new TruckLog(DCmd.SEND, 45);
//        truckLog.setDate(new Date());
//        truckLog.setType(0);
//        truckLog.setPluNo(12);
//        truckLog.setCarNo(1);
//        truckLog.setUnit(3);
//        truckLog.setGross(new BigDecimal("4.5"));
//        truckLog.setTare(new BigDecimal("1"));
//        String command = MQTTBuilder.packBuilder()
//                .mark(new Mark(Encrypt.AES_Encrypt, ACK.Request, Confirm.NWAIT, CD.API))
//                .mqttClient(new MQTTClient()
//                        .appendNid(10)
//                        .appendKey(KEY))
//                .add(truckLog)
//                .spack()
//                .over();
//        System.out.println(command);
//        unpack(command);

//        TruckLog truckErrorLog1 = new TruckLog(DCmd.SEND, 46);
//        truckErrorLog1.setDate(new Date());
//        truckErrorLog1.setType(100);
//        truckErrorLog1.setErrNum1(new BigDecimal("25.5"));
//        String commandError1 = MQTTBuilder.packBuilder()
//                .mark(new Mark(Encrypt.AES_Encrypt, ACK.Request, Confirm.NWAIT, CD.API))
//                .mqttClient(new MQTTClient()
//                        .appendNid(10)
//                        .appendKey(KEY))
//                .add(truckErrorLog1)
//                .spack()
//                .over();
//        System.out.println(commandError1);
//        unpack(commandError1);

//        TruckLog truckErrorLog2 = new TruckLog(DCmd.SEND, 47);
//        truckErrorLog2.setDate(new Date());
//        truckErrorLog2.setType(101);
//        truckErrorLog2.setSensorError("FFFFFFFFFFFFFFFFFFFFFFFF");
//        String commandError2 = MQTTBuilder.packBuilder()
//                .mark(new Mark(Encrypt.AES_Encrypt, ACK.Request, Confirm.NWAIT, CD.API))
//                .mqttClient(new MQTTClient()
//                        .appendNid(10)
//                        .appendKey(KEY))
//                .add(truckErrorLog2)
//                .spack()
//                .over();
//        System.out.println(commandError2);
//        unpack(commandError2);

        TruckLog truckErrorLog3 = new TruckLog(DCmd.SEND, 48);
        truckErrorLog3.setDate(new Date());
        truckErrorLog3.setType(102);
        truckErrorLog3.setErrNum1(new BigDecimal("45.3"));
        String commandError3 = MQTTBuilder.packBuilder()
                .mark(new Mark(Encrypt.AES_Encrypt, ACK.Request, Confirm.NWAIT, CD.API))
                .mqttClient(new MQTTClient()
                        .appendNid(10)
                        .appendKey(KEY))
                .add(truckErrorLog3)
                .spack()
                .over();
        System.out.println(commandError3);
        unpack(commandError3);
    }

    /**
     * @description: 测试指令测试
     **/
    private static void TestData() throws MeterException {
        TestData testData = new TestData(DCmd.REQUEST, 0);
        String command = MQTTBuilder.packBuilder()
                .mark(new Mark(Encrypt.AES_Encrypt, ACK.Request, Confirm.NWAIT, CD.API))
                .mqttClient(new MQTTClient()
                        .appendNid(10)
                        .appendKey(KEY))
                .add(testData)
                .spack()
                .over();
        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: 内容解析
     **/
    private static void contentParse() throws MeterException {
        //        String content = "02 01 00 01 32 04 01 41 41 41 31 32 33 00 55 30 30 30 31 00 00 74 63 70 5F 73 73 6C 3A 2F 2F 6D 71 74 74 2E 6A 68 73 63 61 6C 65 2E 6E 65 74 3A 38 38 38 30 00 2C 01 BA 03";
//        String content0 = "02 85 0F 00 10 DD 92 8C BD AD 4D 6F 6B 8C AA 64 47 FE C7 B8 7A 08 03";
//        unpack(content0);
//        System.out.println("----------");
//        String content1 = "02 85 0F 00 3D 24 61 62 63 31 32 33 34 35 36 37 38 00 62 FA 23 31 EC E0 E2 FA 12 FA A8 FE 2F 1E D9 87 5F 12 D4 C1 D5 07 D0 7F 2E 5E 1A DF 15 11 43 1C C7 EE 2A BB 31 0A A8 7E 44 CA 93 46 8F 67 F2 48 C3 03 ";
//        unpack(content1);
//        System.out.println("----------");
//        String content2 = "02 8D 0A 00 10 F4 F6 FB 70 09 DF 13 3E 99 2E C3 73 EE BE B0 A7 35 03 ";
//        unpack(content2);
//        System.out.println("----------");
//        String content3 = "02 8D 0A 00 27 41 41 41 31 32 33 00 52 84 1B FF 47 27 47 70 26 AA 46 C5 E7 DB B0 68 0B 47 EB 7F E4 15 07 92 34 48 ED 67 BA E6 5F D8 D6 03 ";
//        sunpack(content3);
//        String content4 = "02 4D 0A 00 08 41 41 41 31 32 33 00 00 B8 03 ";
//        sunpack(content4);
//
//        System.out.println("##########");
//
//        String content5 = "02 8D 0A 00 20 52 84 1B FF 47 27 47 70 26 AA 46 C5 E7 DB B0 68 0B 47 EB 7F E4 15 07 92 34 48 ED 67 BA E6 5F D8 76 03 ";
//        unpack(content5);
//        System.out.println("----------");
//        String content6 = "02 4D 0A 00 08 41 41 41 31 32 33 00 00 B8 03 ";
//        sunpack(content6);
//
//        System.out.println("##########");
//
//        String content7 = "02 8D 0A 00 10 34 B1 DC FA 1B 03 AF EC 48 E6 FC 71 A3 5E 22 35 0E 03 ";
//        unpack(content7);
//        String content8 = "02 4D 0A 00 01 00 58 03";
//        unpack(content8);
//        System.out.println("----------");
//        String content9 = "02 8D 0A 00 27 41 41 41 31 32 33 00 52 84 1B FF 47 27 47 70 26 AA 46 C5 E7 DB B0 68 0B 47 EB 7F E4 15 07 92 34 48 ED 67 BA E6 5F D8 D6 03 ";
//        sunpack(content9);
//        String content10 = "02 4D 0A 00 08 41 41 41 31 32 33 00 00 B8 03 ";
//        sunpack(content10);

//        String content10 = "0285CD00104B1DE0FDB1F6F761CD7956ECD6BC5A5E7803";
//        unpack(content10);
//        String content12 = "028948002D35314234303231323333313300765321E1ADF6F196304668A6D1C298682DE5004798CB1962C0ED91B337AD4AAF7A03";
//        sunpack(content12);

        String content13 = "0285DB0032414655736749544D784D56413340453540005EC98122C546F618EDB170B1DE1E071D1BDE6C273EBB912ABCD9C8FCE93227A6FE03";
        sunpack(content13);

//        String content11 = "02C50C011D35314234303231323333313300D4AAB800899BFCDB95BD853F84AFD37D2403";
//        List<IMQTT> imqtts = MQTTUnpackBuilder.unpackSubContent(content11, null, false);

//        String content4 = "02 01 00 01 2E 04 01 41 41 41 31 32 33 00 55 30 30 30 31 00 31 32 33 31 41 31 32 33 00 74 63 70 3A 2F 2F 31 30 36 2E 31 35 2E 37 37 2E 35 34 3A 00 FF 01 B9 03 ";
//        unpack(content4);
//        String content5 = "02 01 00 01 2E 04 01 41 41 41 31 32 33 00 55 30 30 30 31 00 31 32 33 31 41 31 32 33 00 74 63 70 3A 2F 2F 31 30 36 2E 31 35 2E 37 37 2E 35 34 3A 00 FF 01 B9 03 ";
//        unpack(content5);
//        String content6 = "02 01 00 01 2E 04 01 41 41 41 31 32 33 00 55 30 30 30 31 00 31 32 33 31 41 31 32 33 00 74 63 70 3A 2F 2F 31 30 36 2E 31 35 2E 37 37 2E 35 34 3A 00 FF 01 B9 03";
//        unpack(content6);
//        String content7 = "02 01 00 01 32 04 01 41 41 41 31 32 33 00 55 30 30 30 31 00 00 74 63 70 5F 73 73 6C 3A 2F 2F 6D 71 74 74 2E 6A 68 73 63 61 6C 65 2E 6E 65 74 3A 38 38 38 30 00 2C 01 BA 03 ";
//        unpack(content7);
//        String content8 = "02 85 0F 00 27 41 41 41 31 32 33 00 D0 D6 DE 5D 82 8D 92 05 AE F9 EA B7 40 43 7C 34 88 FC 44 EC 54 2F 18 36 16 8D EA 86 42 A0 40 95 65 03 ";
//        unpack(content8);
    }

    /**
     * @description: MQTT连接加密响应
     **/
    private static void X0106_SBind1() throws MeterException {
        X0106_SBind1 x0106_sBind1 = new X0106_SBind1();
        x0106_sBind1.setR1(257);
        x0106_sBind1.setR1qr("http://www.jhscale.net/R1=257");

        String command = MQTTBuilder.packBuilder()
                .mark(new Mark(Encrypt.AES_Encrypt, ACK.Response, Confirm.NWAIT, CD.CMD))
                .mqttClient(new MQTTClient()
                        .appendNid(15)
                        .appendKey(KEY))
                .add(x0106_sBind1)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: MQTT连接加密响应
     **/
    private static void X0104_SMQTTLink() throws MeterException {
        X0104_SMQTTLink x0104_smqttLink = new X0104_SMQTTLink();
        x0104_smqttLink.setStatus('Y');

        String command = MQTTBuilder.packBuilder()
                .mark(new Mark(Encrypt.AES_Encrypt, ACK.Request, Confirm.NWAIT, CD.CMD))
                .mqttClient(new MQTTClient()
                        .appendNid(15)
                        .appendKey(KEY))
                .add(x0104_smqttLink)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: 读取模块信息
     **/
    private static void X0100_RReadModule() throws MeterException {
        X0100_RReadModule x0100_rReadModule = new X0100_RReadModule();
        x0100_rReadModule.setType(0);

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0100_rReadModule)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: 读取模块信息
     **/
    private static void X0400_SObtian_Sensor() throws MeterException {
        X0400_SObtian_Sensor x0400_sObtian_sensor = new X0400_SObtian_Sensor();

        SensorInfo sensor0 = new SensorInfo();
        sensor0.setIndex(0);
        sensor0.setAddress(0);
        sensor0.setInner("C0148E30");
        sensor0.setCoefficient("D0148E30");
        x0400_sObtian_sensor.addSensors(sensor0);

        SensorInfo sensor1 = new SensorInfo();
        sensor1.setIndex(1);
        sensor1.setAddress(1);
        sensor1.setInner("C0148E31");
        sensor1.setCoefficient("D0148E31");
        x0400_sObtian_sensor.addSensors(sensor1);

        SensorInfo sensor2 = new SensorInfo();
        sensor2.setIndex(2);
        sensor2.setAddress(2);
        sensor2.setInner("C0148E32");
        sensor2.setCoefficient("D0148E32");
        x0400_sObtian_sensor.addSensors(sensor2);

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Response, Confirm.NWAIT, CD.CMD)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0400_sObtian_sensor)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: 读取模块信息
     **/
    private static void X0400_RObtian_Sensor() throws MeterException {
        X0400_RObtian_Sensor x0400_rObtian_sensor = new X0400_RObtian_Sensor();
        x0400_rObtian_sensor.setSensor_index("111");

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.CMD)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0400_rObtian_sensor)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: 读取模块信息
     **/
    private static void X0166_SModule_Time() throws MeterException {
        X0166_SModule_Time x0166_sModule_time = new X0166_SModule_Time();
        x0166_sModule_time.setImei("86134e453");
        x0166_sModule_time.setSimId("145464135");
        x0166_sModule_time.setTime(new Date());

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Response, Confirm.NWAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0166_sModule_time)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: 读取模块信息
     **/
    private static void X0160_RLbslocRssis() throws MeterException {
        X0160_RLbslocRssis x0160_rLbslocRssis = new X0160_RLbslocRssis();

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0160_rLbslocRssis)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: 设置订阅号
     **/
    private static void X0164_RSetTopic() throws MeterException {
        X0164_RUpdateTopic.Topic topic1 = new X0164_RUpdateTopic.Topic("/event/topic1", 0);
        X0164_RUpdateTopic.Topic topic2 = new X0164_RUpdateTopic.Topic("/event/topic2", 1);
        X0164_RUpdateTopic.Topic topic3 = new X0164_RUpdateTopic.Topic("/event/topic3", 2);
        List<X0164_RUpdateTopic.Topic> addTopics = new ArrayList<>();
        addTopics.add(topic1);
        addTopics.add(topic2);
        List<X0164_RUpdateTopic.Topic> delTopics = new ArrayList<>();
        delTopics.add(topic3);

        X0164_RUpdateTopic x0164_rUpdateTopic = new X0164_RUpdateTopic();
        x0164_rUpdateTopic.setAddTopics(addTopics);
        x0164_rUpdateTopic.setDelTopics(delTopics);

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0164_rUpdateTopic)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: 模块心跳
     **/
    private static void X0167_RModule_Heart() throws MeterException {
        X0167_RModule_Heart x0167_rModuel_heart = new X0167_RModule_Heart();
        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.CMD)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0167_rModuel_heart)
                .lpack()
                .over();

        System.out.println(command);
        sunpack(command);
    }

    /**
     * @description: 模块订阅
     **/
    private static void X0168_RModule_Subscribe() throws MeterException {
        X0168_RModule_Subscribe x0168_rModule_subscribe = new X0168_RModule_Subscribe();
        x0168_rModule_subscribe.setUser(USER);
        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.CMD)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0168_rModule_subscribe)
                .lpack()
                .over();

        System.out.println(command);
        sunpack(command);
    }

    /**
     * @description: 汇报响应
     **/
    private static void X0140_RReportApply() throws MeterException {
        X0140_RReportApply x0140_rReportApply = new X0140_RReportApply();
        x0140_rReportApply.setReportType(1);
        x0140_rReportApply.setReportCycle(5);
        x0140_rReportApply.setReportInvalid(30);

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0140_rReportApply)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: 汇报响应
     **/
    private static void X0140_SReportApply() throws MeterException {
        X0140_SReportApply x0140_sReportApply = new X0140_SReportApply();
        x0140_sReportApply.setReportType(1);
        x0140_sReportApply.setEndSign('C');
        x0140_sReportApply.setFlag("0000000000000001");
        x0140_sReportApply.setUnit(3);
        x0140_sReportApply.setWeight(new BigDecimal("45.3"));

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Response, Confirm.WAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(x0140_sReportApply)
                .spack()
                .over();

        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: MQTT断开连接
     **/
    private static void X0101_RMQTTBreak() throws MeterException {
        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(new X0101_RMQTTBreak())
                .spack()
                .over();
        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: MQTT连接
     **/
    private static void X0104_RMQTTLink() throws MeterException {
        X0104_RMQTTLink mqttLinkRequest = new X0104_RMQTTLink();
        mqttLinkRequest.setUid("#123456");
        mqttLinkRequest.setUser("U1000");
        mqttLinkRequest.setPassword("789456452313245");
        mqttLinkRequest.setDomain("tcp://47.102.142.104:1883");
        mqttLinkRequest.setKeepAlive(300);

        String command = MQTTBuilder.packBuilder()
                .mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE)
                .mqttClient(new MQTTClient()
                        .appendNid(NID)
                        .appendUid(UID)
                        .appendKey(KEY)
                        .appendEncoding(CODING))
                .add(mqttLinkRequest)
                .spack()
                .over();
        System.out.println(command);
        unpack(command);
    }

    /**
     * @description: 拆包
     **/
    private static void unpack(String command) throws MeterException {
        command = command.replace(" ", "");
        MQTTUnpackBuilder builder = MQTTBuilder.unpackBuilder()
                .content(command)
                .loader(new LocalMQTTLoader() {
                    @Override
                    public ModuleInfo keyAndEncoding() {
                        return new ModuleInfo(CODING, "0292CF99628E0F06DA0B052A7310A63838959BADF4927D82");
                    }
                })
                .lunpack();
        System.out.println(builder.toJSON());
    }

    /**
     * @description: 拆包
     **/
    private static void sunpack(String command) throws MeterException {
        command = command.replace(" ", "");
        MQTTUnpackBuilder builder = MQTTBuilder.unpackBuilder()
                .content(command)
                .loader(new ServerMQTTLoader() {
                    @Override
                    public ModuleInfo keyAndEncoding(String uid) {
                        return new ModuleInfo(CODING, "578E1D2E972BD2ACED7D81F21E0AB0FDA955D8BE44B5C1C9");
                    }
                })
                .sunpack();
        System.out.println(builder.toJSON());
    }


}
