package com.jhscale.test.network;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.common.content.JHContents;
import com.jhscale.common.em.DeviceType;
import com.jhscale.common.exception.GeneralException;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.model.device._inner.DLOGContent;
import com.jhscale.common.model.http.DeviceHead;
import com.jhscale.common.model.http.HttpResponse;
import com.jhscale.common.model.http.JRequest;
import com.jhscale.common.model.http.JResponse;
import com.jhscale.common.utils.HttpUtils;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.utils.ScannerUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author lie_w
 * @title: EquipmentTest
 * @projectName common
 * @description: TODO
 * @date 2021/6/112:48
 */
public class MeterEquipmentTest {

    // 本地测试网关
    private static final int ZUUL_TYPE = 3;
    private static final String ZUUL_URL = "http://192.168.101.150:15100";
    private static final String ZUUL_DEV_URL = "http://192.168.101.120:15100";
    private static final String UAT_ZUUL_URL = "http://192.168.1.51:15100";
    private static final String PROD_ZUUL_URL = "https://eq.jhscale.net";

    private static final String TYPE = DeviceType.Android_Scales.getType();
    private static final String UNIQUE = "SCOPA1ERA0704A0E126ADE";
    // PROD
    private static final String KEY = "16CB26D6E5787F8E40BB54FDE6C7E935";
    // 53
    // private static final String KEY = "AD63B2A519B60D9F60772008C79CE9C1";

    private static Map<String, String> map = new HashMap<>();

    static {
        map.put("X-Equipment-Info", "{\"type\":\"" + TYPE + "\",\"unique\":\"" + UNIQUE + "\"}");
        map.put("X-Company", "JHScale 1.0");
        map.put("X-Equipment-Secret", KEY);
        map.put("X-Equipment-Key", KEY);
    }

    public static String ZUUL() {
        String zuul = "";
        switch (ZUUL_TYPE) {
            case 0:
                zuul = ZUUL_URL;
                break;
            case 1:
                zuul = ZUUL_DEV_URL;
                break;
            case 2:
                zuul = UAT_ZUUL_URL;
                break;
            case 3:
                zuul = PROD_ZUUL_URL;
                break;
        }
        return zuul;
    }

    public static <T> T post(String url, JRequest request, Class<T> clazz) throws ProfessionalException {
        System.out.println(String.format("{%s} -> {%s}", url, request.toJSON()));
        String post = HttpUtils.post(ZUUL() + url, request.toJSON(), map);
        System.out.println(JSONUtils.parseJSON(post));
        return result(clazz, post);
    }

    public static <T> T get(String url, JRequest request, Class<T> clazz) throws ProfessionalException, TechnologyException {
        System.out.println(String.format("{%s} -> {%s}", url, request.toJSON()));
        String get = HttpUtils.get(ZUUL() + url, map);
        System.out.println(JSONUtils.parseJSON(get));
        return result(clazz, get);
    }

    private static <T> T result(Class<T> clazz, String response) throws ProfessionalException {
        if (clazz.equals(String.class)) {
            return (T) response;
        } else {
            HttpResponse httpResponse = JSONUtils.jsonToObject(response, HttpResponse.class);
            if (JHContents.SUCCESS.equals(httpResponse.getReturn_code()) && JHContents.SUCCESS.equals(httpResponse.getResult_code()))
                return JSONUtils.objectToObject(httpResponse.getResponse(), clazz);
            throw new ProfessionalException(Objects.isNull(httpResponse.getReturn_msg()) ? httpResponse.getResult_msg().toJSON() : httpResponse.getReturn_msg().toJSON());
        }
    }

    public static void main(String[] args) throws GeneralException {
        // 设备登陆
        // AttributionLoginRequest();
        // 获取店铺信息
        // GetStoreRequest();
        // 请求头信息
        // X_Equipment_Info();
        // 授权设备登陆
        // AuthBalanceLoginRequest();

        // member_test();
        BigDecimal bigDecimal = new BigDecimal("100000000000000");
        System.out.println(bigDecimal.toString());
        System.out.println(bigDecimal.compareTo(BigDecimal.ZERO));
        System.out.println(invalidMoney(bigDecimal));
        // System.out.println(new BigDecimal("999999999999999.9999").compareTo(bigDecimal));
        // System.out.println(new BigDecimal("999999999999999.9999").compareTo(bigDecimal) >= 0);
        // System.out.println(new BigDecimal("-999999999999999.9999").compareTo(bigDecimal));
        // System.out.println(new BigDecimal("-999999999999999.9999").compareTo(bigDecimal) <= 0);
    }

    /**
     * @description: 数值有效
     **/
    public static boolean invalidMoney(BigDecimal money) {
        return new BigDecimal("999999999999999.9999").compareTo(money) >= 0
                && new BigDecimal("-999999999999999.9999").compareTo(money) <= 0;
    }

    /**
     * @description: 会员测试
     **/
    private static void member_test() throws GeneralException {
        // 会员信息 发卡操作
        // CardIssuedRequest();
        // 会员查询用户信息
        // mobileUserQuery();
        // 会员用户登陆
        // memberLogin();
        // 获取积分套餐列表
        // integral_setmeal();
        // 积分兑换
        // integral_exchange();
        // 会员用户登录以及查询
        memberLoginQuery();
    }

    private static void memberLoginQuery() throws ProfessionalException {
        String URL = "/mbalance/terminal/query";
        String login = memberLogin();
        JSONObject jsonObject = JSONObject.parseObject(login);
        JSONObject response = jsonObject.getJSONObject("response");
        TerminalLoginResponse loginResponse = JSONUtils.objectToObject(response, TerminalLoginResponse.class);
        if (!"TRADE_WAIT".equals(loginResponse.getStatus()) && StringUtils.isNotBlank(loginResponse.getLockId())) {
            int count = 0;
            while (count < 5) {
                TerminalLoginQueryRequest loginQueryRequest = new TerminalLoginQueryRequest();
                loginQueryRequest.setLockId(loginResponse.getLockId());
                loginQueryRequest.setSign(loginQueryRequest.bulidSign(KEY));
                System.out.printf("%s 第[ %s ]次%n", URL, count);
                post(URL, loginQueryRequest, String.class);
                SystemtUtils.sleep(5);
                count++;
            }
        }
    }

    @ApiModel("设备终端会员用户登陆请求")
    public static class TerminalLoginQueryRequest extends JRequest {

        @ApiModelProperty(value = "登陆锁定ID")
        private String lockId;

        public String getLockId() {
            return lockId;
        }

        public void setLockId(String lockId) {
            this.lockId = lockId;
        }
    }

    private static void integral_exchange() throws ProfessionalException {
        String URL = "/mbalance/terminal/integral/exchange";
        IntegralExchangeRequest request = new IntegralExchangeRequest();
        request.setLockId(lockId());
        request.setFid("0A");
        request.setMealVersion(8);
        request.setMealOrder(10);
        request.setCount(2);
        request.setIntegral(new BigDecimal("100"));
        request.defaultInit();
        request.setSign(request.bulidSign(KEY));
        String response = post(URL, request, String.class);
        System.out.println(response);
    }

    private static String lockId() throws ProfessionalException {
        String login = memberLogin();
        JSONObject jsonObject = JSONObject.parseObject(login);
        JSONObject response = jsonObject.getJSONObject("response");
        String lockId = response.getString("lockId");
        return lockId;
    }

    public static class IntegralExchangeRequest extends JRequest {

        @ApiModelProperty(value = "登陆锁定ID")
        private String lockId;

        @ApiModelProperty(value = "设备记录编号（HEX）", name = "fid", required = true)
        private String fid;

        @ApiModelProperty(value = "充值套餐版本号", name = "mealVersion")
        private Integer mealVersion;

        @ApiModelProperty(value = "充值套餐序号", name = "mealOrder")
        private Integer mealOrder;

        @ApiModelProperty(value = "兑换套餐数量", name = "count")
        private Integer count;

        @ApiModelProperty(value = "使用过积分", name = "integral")
        private BigDecimal integral;

        @ApiModelProperty(value = "使用过积分备注", name = "remark")
        private String remark;

        public String getLockId() {
            return lockId;
        }

        public void setLockId(String lockId) {
            this.lockId = lockId;
        }

        public String getFid() {
            return fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public Integer getMealVersion() {
            return mealVersion;
        }

        public void setMealVersion(Integer mealVersion) {
            this.mealVersion = mealVersion;
        }

        public Integer getMealOrder() {
            return mealOrder;
        }

        public void setMealOrder(Integer mealOrder) {
            this.mealOrder = mealOrder;
        }

        public Integer getCount() {
            return count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public BigDecimal getIntegral() {
            return integral;
        }

        public void setIntegral(BigDecimal integral) {
            this.integral = integral;
        }

        public String getRemark() {
            return remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }
    }

    private static void integral_setmeal() throws GeneralException {
        String URL = "/mbalance/terminal/integral";
        JRequest request = new JRequest();
        request.setSign(request.bulidSign(KEY));
        String response = get(URL, request, String.class);
        System.out.println(response);
    }


    private static String memberLogin() throws ProfessionalException {
        String URL = "/mbalance/terminal/login";

        String scanner = ScannerUtils.scanner("请输入登录方式 C.18082350542: ");
        TerminalLoginRequest request = new TerminalLoginRequest();
        if (StringUtils.isNotBlank(scanner)) {
            if (scanner.startsWith("88")) {
                request.setType("A");
                request.setText(scanner);
            } else {
                String[] arr = scanner.split("\\.");
                request.setType(arr[0]);
                request.setText(arr[1]);
            }
        } else {
            request.setType("C");
            request.setText("18082350542");
        }

        request.defaultInit();
        request.setSign(request.bulidSign(KEY));
        String response = post(URL, request, String.class);
        // System.out.println(response);
        return response;
    }

    @ApiModel("设备终端会员用户登陆请求")
    public static class TerminalLoginRequest extends JRequest {

        @ApiModelProperty(value = "登陆类型 A-小程序条码登陆|B-实体卡内部ID登陆|C-手机号登陆|D-手机号注册登陆", example = "A", required = true, position = 1)
        private String type;

        @ApiModelProperty(value = "文本内容 A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号", required = true, position = 2)
        private String text;

        @ApiModelProperty(value = "自增序列 B-实体卡内部ID登陆-自增序列", position = 3)
        private Long number;

        @ApiModelProperty(value = "外部卡号 B-实体卡内部ID登陆-外部卡号|C-手机号登陆-手机区号[不传默认商家区号]", position = 4)
        private String text1;

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Long getNumber() {
            return number;
        }

        public void setNumber(Long number) {
            this.number = number;
        }

        public String getText1() {
            return text1;
        }

        public void setText1(String text1) {
            this.text1 = text1;
        }
    }

    @ApiModel("设备终端会员用户登陆响应")
    public static class TerminalLoginResponse extends JResponse {

        @ApiModelProperty(value = "登陆锁定ID", example = "A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号")
        private String lockId;

        @ApiModelProperty(value = "交易状态",
                example = "新码-NEW|" +
                        "商户客户检查通过-MU_SUCCESS|" +
                        "等待输入密码-WAIT_PWD|" +
                        "输入密码-INPUT|" +
                        "密码检查通过-PWD_SUCCESS|" +
                        "等待选择卡套餐-WAIT_SELECT|" +
                        "选择卡套餐-SELECT|" +
                        "卡套餐检查通过-MEAL_SUCCESS|" +
                        "交易等待中-TRADE_WAIT|" +
                        "终端退出-TD_QUIT|")
        private String status;

        @ApiModelProperty(value = "登陆类型", example = "A-小程序条码登陆|B-实体卡内部ID登陆|C-手机号登陆|D-手机号注册登陆")
        private String type;

        @ApiModelProperty(value = "允许交易情况", example = "A-允许所有扣款方式|B-允许储值扣款和储值混合扣款|C-只允许储值扣款|D-只允许现金扣款——" +
                "交易情况=B/C时，如果余额=0，会自动进入冲值界面，如果交易情况=B，且余额不足时，会自动进入冲值界面")
        private String tradeEnv;

        @ApiModelProperty(value = "卡等级")
        private Integer level;

        @ApiModelProperty(value = "特价情况")
        private String specialType;

        @ApiModelProperty(value = "折扣情况")
        private BigDecimal discount;

        @ApiModelProperty(value = "可用余额")
        private BigDecimal balance;

        @ApiModelProperty(value = "可用赠送余额")
        private BigDecimal giveBalance;

        // @ApiModelProperty(value = "赠送余额到期时间")
        // private Date giveBalanceTime;

        @ApiModelProperty(value = "可用积分")
        private BigDecimal integral;

        @ApiModelProperty(value = "套餐卡号")
        private String cardKid;

        @ApiModelProperty(value = "卡号")
        private String card;

        @ApiModelProperty(value = "对应的手机")
        private String operatorMobile;

        @ApiModelProperty(value = "操作用户头像")
        private String operatorPic;

        @ApiModelProperty(value = "登陆查询间隔时间 默认5s查询一次")
        private int queryInterval;

        @ApiModelProperty(notes = "允许现金支付 0-未开启 1-已开启")
        private Integer enableCash;

        @ApiModelProperty(notes = "允许积分 0-未开启 1-已开启")
        private Integer enableIntegral;

        @ApiModelProperty(notes = "混合支付 0-未开启 1-已开启")
        private Integer enableBlend;

        @ApiModelProperty(notes = "允许手机号登陆 0-未开启 1-已开启")
        private Integer enablePhone;

        @ApiModelProperty(notes = "手机号支付限额")
        private BigDecimal phoneFreePay;

        public String getLockId() {
            return lockId;
        }

        public void setLockId(String lockId) {
            this.lockId = lockId;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTradeEnv() {
            return tradeEnv;
        }

        public void setTradeEnv(String tradeEnv) {
            this.tradeEnv = tradeEnv;
        }

        public Integer getLevel() {
            return level;
        }

        public void setLevel(Integer level) {
            this.level = level;
        }

        public String getSpecialType() {
            return specialType;
        }

        public void setSpecialType(String specialType) {
            this.specialType = specialType;
        }

        public BigDecimal getDiscount() {
            return discount;
        }

        public void setDiscount(BigDecimal discount) {
            this.discount = discount;
        }

        public BigDecimal getBalance() {
            return balance;
        }

        public void setBalance(BigDecimal balance) {
            this.balance = balance;
        }

        public BigDecimal getGiveBalance() {
            return giveBalance;
        }

        public void setGiveBalance(BigDecimal giveBalance) {
            this.giveBalance = giveBalance;
        }

        // public Date getGiveBalanceTime() {
        //     return giveBalanceTime;
        // }

        // public void setGiveBalanceTime(Date giveBalanceTime) {
        //     this.giveBalanceTime = giveBalanceTime;
        // }

        public BigDecimal getIntegral() {
            return integral;
        }

        public void setIntegral(BigDecimal integral) {
            this.integral = integral;
        }

        public String getCardKid() {
            return cardKid;
        }

        public void setCardKid(String cardKid) {
            this.cardKid = cardKid;
        }

        public String getCard() {
            return card;
        }

        public void setCard(String card) {
            this.card = card;
        }

        public String getOperatorMobile() {
            return operatorMobile;
        }

        public void setOperatorMobile(String operatorMobile) {
            this.operatorMobile = operatorMobile;
        }

        public String getOperatorPic() {
            return operatorPic;
        }

        public void setOperatorPic(String operatorPic) {
            this.operatorPic = operatorPic;
        }

        public int getQueryInterval() {
            return queryInterval;
        }

        public void setQueryInterval(int queryInterval) {
            this.queryInterval = queryInterval;
        }

        public Integer getEnableCash() {
            return enableCash;
        }

        public void setEnableCash(Integer enableCash) {
            this.enableCash = enableCash;
        }

        public Integer getEnableIntegral() {
            return enableIntegral;
        }

        public void setEnableIntegral(Integer enableIntegral) {
            this.enableIntegral = enableIntegral;
        }

        public Integer getEnableBlend() {
            return enableBlend;
        }

        public void setEnableBlend(Integer enableBlend) {
            this.enableBlend = enableBlend;
        }

        public Integer getEnablePhone() {
            return enablePhone;
        }

        public void setEnablePhone(Integer enablePhone) {
            this.enablePhone = enablePhone;
        }

        public BigDecimal getPhoneFreePay() {
            return phoneFreePay;
        }

        public void setPhoneFreePay(BigDecimal phoneFreePay) {
            this.phoneFreePay = phoneFreePay;
        }
    }


    private static void mobileUserQuery() throws ProfessionalException {
        String URL = "/mbalance/terminal/mobile-user-query";
        TerminalUserQueryRequest request = new TerminalUserQueryRequest();
        request.setText("0542");
        request.defaultInit();
        request.setSign(request.bulidSign(KEY));
        String response = post(URL, request, String.class);
        System.out.println(response);
    }

    @ApiModel("终端用户模糊查询")
    public static class TerminalUserQueryRequest extends JRequest {

        @ApiModelProperty(value = "手机号后几位查询用户信息 长度 >= 4", required = true)
        private String text;

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    /**
     * @description: 日志上传
     **/
    public static void updateLogData(DLOGContent... contents) throws ProfessionalException {
        String URL = "/data/log-data/batch-upload/V2";
        BatchUploadRequest request = new BatchUploadRequest();
        request.setContents(Arrays.asList(contents));
        request.defaultInit();
        request.setSign(request.bulidSign(KEY));
        Boolean response = post(URL, request, Boolean.class);
        System.out.println(response);
    }

    public static class BatchUploadRequest extends JRequest {
        @ApiModelProperty("日志记录-V1")
        private List<String> logDatas;

        @ApiModelProperty("日志记录-V2")
        private List<DLOGContent> contents;

        public List<String> getLogDatas() {
            return logDatas;
        }

        public void setLogDatas(List<String> logDatas) {
            this.logDatas = logDatas;
        }

        public List<DLOGContent> getContents() {
            return contents;
        }

        public void setContents(List<DLOGContent> contents) {
            this.contents = contents;
        }
    }

    private static void CardIssuedRequest() throws ProfessionalException {
        String URL = "/mbalance/terminal/card/issued";
        CardIssuedRequest request = new CardIssuedRequest();
        request.setInternalCode("_7C2A0E2C74080400021EC03DC424261D");
        request.defaultInit();
        request.setSign(request.bulidSign(KEY));
        CardIssuedResponse response = post(URL, request, CardIssuedResponse.class);
        System.out.println(response.toJSON());
    }

    public static class CardIssuedRequest extends JRequest {
        @ApiModelProperty(value = "空卡内码 _32位HEX", required = true)
        private String internalCode;

        public String getInternalCode() {
            return internalCode;
        }

        public void setInternalCode(String internalCode) {
            this.internalCode = internalCode;
        }
    }

    public static class CardIssuedResponse extends JResponse {
        @ApiModelProperty(value = "空卡内码 _32位HEX", required = true)
        private String internalCode;

        @ApiModelProperty(value = "内部ID", required = true)
        private String innerId;

        @ApiModelProperty(value = "外部ID", required = true)
        private String outerId;

        public String getInternalCode() {
            return internalCode;
        }

        public void setInternalCode(String internalCode) {
            this.internalCode = internalCode;
        }

        public String getInnerId() {
            return innerId;
        }

        public void setInnerId(String innerId) {
            this.innerId = innerId;
        }

        public String getOuterId() {
            return outerId;
        }

        public void setOuterId(String outerId) {
            this.outerId = outerId;
        }
    }

    private static void AuthBalanceLoginRequest() throws ProfessionalException {
        AuthBalanceLoginRequest request = new AuthBalanceLoginRequest();
        request.setDeviceType("Factory_Tool");
        request.setUnique("2014000000000001");
        request.defaultInit();
        request.setSign(request.bulidSign("9DA525C1BFE4902EB975662E01A07CC9"));
        System.out.println(request.toJSON());
        // post("/ysscale/mobile/user/my/myShop", request, GetStoreResponse.class);
    }

    private static void X_Equipment_Info() {
        DeviceHead deviceHead = new DeviceHead();
        deviceHead.setType(DeviceType.Factory_Tool);
        deviceHead.setUnique("B42E9905A818");
        System.out.println(JSONUtils.objectToJSON(deviceHead));
    }

    public static class AuthBalanceLoginRequest extends JRequest {
        @ApiModelProperty(notes = "设备唯一标识", name = "unique", required = true)
        private String unique;

        @ApiModelProperty(notes = "设备类型", name = "deviceType", required = true)
        private String deviceType;

        public String getUnique() {
            return unique;
        }

        public void setUnique(String unique) {
            this.unique = unique;
        }

        public String getDeviceType() {
            return deviceType;
        }

        public void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }
    }

    private static void GetStoreRequest() throws ProfessionalException {
        GetStoreRequest request = new GetStoreRequest();
        request.setUserId(26);
        request.setStoreId(1);
        request.defaultInit();
        request.setSign(request.bulidSign(KEY));
        post("/ysscale/mobile/user/my/myShop", request, GetStoreResponse.class);
    }

    public static class GetStoreRequest extends JRequest {
        @ApiModelProperty(value = "商户编号", name = "userId")
        private Integer userId;

        @ApiModelProperty(value = "商铺编号", name = "storeId")
        private Integer storeId;

        public Integer getUserId() {
            return userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public Integer getStoreId() {
            return storeId;
        }

        public void setStoreId(Integer storeId) {
            this.storeId = storeId;
        }
    }

    public static class GetStoreResponse extends JResponse {
        private Integer id;

        private Long stSign;

        private Integer userId;

        private String userName;

        private Integer storeId;

        private String storeSid;

        private String adminId;

        private String name;

        private String icon;

        private String country;

        private String storeArea;

        private String address;

        private BigDecimal lng;

        private BigDecimal lat;

        private BigDecimal staoreMoney;

        private String moneyCurrency;

        private String payWxMchId;

        private String payWxoaMchId;

        private String payAliMchId;

        // 店铺本身策略
        private Integer storePayStrategy;

        // 支付策略
        private Integer payStrategy;

        // 策略名称
        private String strategyName;

        // 策略内容
        private String strategyContent;

        private String payUnionMchId;

        private String areaCode;

        private String mobile;

        private String timeZone;

        private String language;

        private Integer ratioId;

        public Integer getId() {
            return id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Long getStSign() {
            return stSign;
        }

        public void setStSign(Long stSign) {
            this.stSign = stSign;
        }

        public Integer getUserId() {
            return userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public String getUserName() {
            return userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public Integer getStoreId() {
            return storeId;
        }

        public void setStoreId(Integer storeId) {
            this.storeId = storeId;
        }

        public String getStoreSid() {
            return storeSid;
        }

        public void setStoreSid(String storeSid) {
            this.storeSid = storeSid;
        }

        public String getAdminId() {
            return adminId;
        }

        public void setAdminId(String adminId) {
            this.adminId = adminId;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getIcon() {
            return icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getCountry() {
            return country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getStoreArea() {
            return storeArea;
        }

        public void setStoreArea(String storeArea) {
            this.storeArea = storeArea;
        }

        public String getAddress() {
            return address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public BigDecimal getLng() {
            return lng;
        }

        public void setLng(BigDecimal lng) {
            this.lng = lng;
        }

        public BigDecimal getLat() {
            return lat;
        }

        public void setLat(BigDecimal lat) {
            this.lat = lat;
        }

        public BigDecimal getStaoreMoney() {
            return staoreMoney;
        }

        public void setStaoreMoney(BigDecimal staoreMoney) {
            this.staoreMoney = staoreMoney;
        }

        public String getMoneyCurrency() {
            return moneyCurrency;
        }

        public void setMoneyCurrency(String moneyCurrency) {
            this.moneyCurrency = moneyCurrency;
        }

        public String getPayWxMchId() {
            return payWxMchId;
        }

        public void setPayWxMchId(String payWxMchId) {
            this.payWxMchId = payWxMchId;
        }

        public String getPayWxoaMchId() {
            return payWxoaMchId;
        }

        public void setPayWxoaMchId(String payWxoaMchId) {
            this.payWxoaMchId = payWxoaMchId;
        }

        public String getPayAliMchId() {
            return payAliMchId;
        }

        public void setPayAliMchId(String payAliMchId) {
            this.payAliMchId = payAliMchId;
        }

        public Integer getStorePayStrategy() {
            return storePayStrategy;
        }

        public void setStorePayStrategy(Integer storePayStrategy) {
            this.storePayStrategy = storePayStrategy;
        }

        public Integer getPayStrategy() {
            return payStrategy;
        }

        public void setPayStrategy(Integer payStrategy) {
            this.payStrategy = payStrategy;
        }

        public String getStrategyName() {
            return strategyName;
        }

        public void setStrategyName(String strategyName) {
            this.strategyName = strategyName;
        }

        public String getStrategyContent() {
            return strategyContent;
        }

        public void setStrategyContent(String strategyContent) {
            this.strategyContent = strategyContent;
        }

        public String getPayUnionMchId() {
            return payUnionMchId;
        }

        public void setPayUnionMchId(String payUnionMchId) {
            this.payUnionMchId = payUnionMchId;
        }

        public String getAreaCode() {
            return areaCode;
        }

        public void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        public String getMobile() {
            return mobile;
        }

        public void setMobile(String mobile) {
            this.mobile = mobile;
        }

        public String getTimeZone() {
            return timeZone;
        }

        public void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public String getLanguage() {
            return language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public Integer getRatioId() {
            return ratioId;
        }

        public void setRatioId(Integer ratioId) {
            this.ratioId = ratioId;
        }
    }

    /**
     * @description: 登陆
     **/
    private static void AttributionLoginRequest() throws ProfessionalException {
        String URL = "/socketService/zuul/attribution/login";
        AttributionLoginRequest request = new AttributionLoginRequest();
        request.setUnique(UNIQUE);
        request.defaultInit();
        AttributionLoginResponse response = post(URL, request, AttributionLoginResponse.class);
        String key = response.decrypt(response.getKey());
        System.out.println(key);
        System.out.println("AttributionLoginRequest Key：" + key.equals(KEY));
    }

    public static class AttributionLoginRequest extends JRequest {
        private String unique;

        public String getUnique() {
            return unique;
        }

        public void setUnique(String unique) {
            this.unique = unique;
        }
    }

    public static class AttributionLoginResponse extends JResponse {

        /**
         * @description: 设备基础信息
         **/
        @ApiModelProperty(notes = "设备ID", name = "id")
        private Integer id;

        @ApiModelProperty(notes = "设备唯一标识", name = "unique", required = true)
        private String unique;

        @ApiModelProperty(notes = "别名", name = "nickName")
        private String nickName;

        @ApiModelProperty(notes = "设备绑定状态", name = "bind", example = "0未绑定、1已绑定、2已解绑、3已禁用")
        private Integer bind;

        @ApiModelProperty(notes = "设备密钥", name = "key", required = true)
        private String key;

        @ApiModelProperty(notes = "字符集", name = "encoding")
        private String encoding;

        @ApiModelProperty(notes = "版本", name = "bversion")
        private String bversion;

        @ApiModelProperty(notes = "设备日志记录id", name = "fid")
        private String fid;

        @ApiModelProperty(notes = "心跳间隔 （秒）", name = "heart")
        private Integer heart;

        /**
         * @description: 商户信息
         **/
        @ApiModelProperty(notes = "用户ID", name = "userId")
        private Integer userId;
        @ApiModelProperty(notes = "用户编号", name = "usSign")
        private Long usSign;
        @ApiModelProperty(notes = "用户国家", name = "country")
        private String country;
        @ApiModelProperty(notes = "用户名", name = "userName")
        private String userName;
        @ApiModelProperty(notes = "用户真实姓名", name = "realName")
        private String realName;
        @ApiModelProperty(notes = "用户区号", name = "areaCode")
        private String areaCode;
        @ApiModelProperty(notes = "用户手机", name = "mobile")
        private String mobile;
        @ApiModelProperty(notes = "用户邮箱", name = "email")
        private String email;
        @ApiModelProperty(notes = "用户地区编号", name = "area")
        private String area;
        @ApiModelProperty(notes = "语言", name = "lang")
        private String lang;
        @ApiModelProperty(notes = "用户时区", name = "timeZone")
        private String timeZone;

        /**
         * @description: 店铺信息
         **/
        @ApiModelProperty(notes = "店铺id", name = "storeId")
        private Integer storeId;
        @ApiModelProperty(notes = "店铺编号", name = "stSign")
        private Long stSign;
        @ApiModelProperty(notes = "店铺名称", name = "storeName")
        private String storeName;
        @ApiModelProperty(notes = "店铺SID", name = "storeSid")
        private String storeSid;
        @ApiModelProperty(notes = "店铺地区", name = "storeArea")
        private String storeArea;
        @ApiModelProperty(notes = "店铺地址", name = "storeAddress")
        private String storeAddress;
        @ApiModelProperty(notes = "管理员编号", name = "adminId")
        private String adminId;
        @ApiModelProperty(notes = "聚合支付信息", name = "payments")
        private List payments;
        @ApiModelProperty(notes = "云支付策略编号", name = "cloudPayStrategyId")
        private Integer cloudPayStrategyId;
        @ApiModelProperty(notes = "云支付策略", name = "cloudPayStrategy")
        private String cloudPayStrategy;

        /**
         * @description: 经销商信息
         **/
        @ApiModelProperty(notes = "经销商ID", name = "agentId")
        private Integer agentId;
        @ApiModelProperty(notes = "经销商业务标识", name = "agSign")
        private Long agSign;
        @ApiModelProperty(notes = "经销商名称", name = "agentName")
        private String agentName;
        @ApiModelProperty(notes = "经销商地区编号", name = "agentArea")
        private String agentArea;
        @ApiModelProperty(notes = "经销商地址", name = "agentAddress")
        private String agentAddress;
        @ApiModelProperty(notes = "区号", name = "agentAreaCode")
        private String agentAreaCode;
        @ApiModelProperty(notes = "经销商联系电话", name = "agentMobile")
        private String agentMobile;

        /**
         * @description: 可能存在的市场信息
         **/
        @ApiModelProperty(value = "市场方索引编号", name = "marketId")
        private Integer marketId;
        @ApiModelProperty(value = "市场方业务编号", name = "mkSign")
        private Long mkSign;
        @ApiModelProperty(value = "市场方名称", name = "marketName")
        private String marketName;
        @ApiModelProperty(value = "市场方联系方式", name = "mobile")
        private String marketMobile;
        @ApiModelProperty(value = "市场方区域编号", name = "area")
        private String marketArea;
        @ApiModelProperty(value = "市场方地址", name = "address")
        private String marketAddress;
        @ApiModelProperty(value = "市场方国际区号", name = "areaCode")
        private String marketAreaCode;

        public Integer getId() {
            return id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getUnique() {
            return unique;
        }

        public void setUnique(String unique) {
            this.unique = unique;
        }

        public String getNickName() {
            return nickName;
        }

        public void setNickName(String nickName) {
            this.nickName = nickName;
        }

        public Integer getBind() {
            return bind;
        }

        public void setBind(Integer bind) {
            this.bind = bind;
        }

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getEncoding() {
            return encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getBversion() {
            return bversion;
        }

        public void setBversion(String bversion) {
            this.bversion = bversion;
        }

        public String getFid() {
            return fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public Integer getHeart() {
            return heart;
        }

        public void setHeart(Integer heart) {
            this.heart = heart;
        }

        public Integer getUserId() {
            return userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public Long getUsSign() {
            return usSign;
        }

        public void setUsSign(Long usSign) {
            this.usSign = usSign;
        }

        public String getCountry() {
            return country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getUserName() {
            return userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getRealName() {
            return realName;
        }

        public void setRealName(String realName) {
            this.realName = realName;
        }

        public String getAreaCode() {
            return areaCode;
        }

        public void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        public String getMobile() {
            return mobile;
        }

        public void setMobile(String mobile) {
            this.mobile = mobile;
        }

        public String getEmail() {
            return email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getArea() {
            return area;
        }

        public void setArea(String area) {
            this.area = area;
        }

        public String getLang() {
            return lang;
        }

        public void setLang(String lang) {
            this.lang = lang;
        }

        public String getTimeZone() {
            return timeZone;
        }

        public void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public Integer getStoreId() {
            return storeId;
        }

        public void setStoreId(Integer storeId) {
            this.storeId = storeId;
        }

        public Long getStSign() {
            return stSign;
        }

        public void setStSign(Long stSign) {
            this.stSign = stSign;
        }

        public String getStoreName() {
            return storeName;
        }

        public void setStoreName(String storeName) {
            this.storeName = storeName;
        }

        public String getStoreSid() {
            return storeSid;
        }

        public void setStoreSid(String storeSid) {
            this.storeSid = storeSid;
        }

        public String getStoreArea() {
            return storeArea;
        }

        public void setStoreArea(String storeArea) {
            this.storeArea = storeArea;
        }

        public String getStoreAddress() {
            return storeAddress;
        }

        public void setStoreAddress(String storeAddress) {
            this.storeAddress = storeAddress;
        }

        public String getAdminId() {
            return adminId;
        }

        public void setAdminId(String adminId) {
            this.adminId = adminId;
        }

        public List getPayments() {
            return payments;
        }

        public void setPayments(List payments) {
            this.payments = payments;
        }

        public Integer getCloudPayStrategyId() {
            return cloudPayStrategyId;
        }

        public void setCloudPayStrategyId(Integer cloudPayStrategyId) {
            this.cloudPayStrategyId = cloudPayStrategyId;
        }

        public String getCloudPayStrategy() {
            return cloudPayStrategy;
        }

        public void setCloudPayStrategy(String cloudPayStrategy) {
            this.cloudPayStrategy = cloudPayStrategy;
        }

        public Integer getAgentId() {
            return agentId;
        }

        public void setAgentId(Integer agentId) {
            this.agentId = agentId;
        }

        public Long getAgSign() {
            return agSign;
        }

        public void setAgSign(Long agSign) {
            this.agSign = agSign;
        }

        public String getAgentName() {
            return agentName;
        }

        public void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        public String getAgentArea() {
            return agentArea;
        }

        public void setAgentArea(String agentArea) {
            this.agentArea = agentArea;
        }

        public String getAgentAddress() {
            return agentAddress;
        }

        public void setAgentAddress(String agentAddress) {
            this.agentAddress = agentAddress;
        }

        public String getAgentAreaCode() {
            return agentAreaCode;
        }

        public void setAgentAreaCode(String agentAreaCode) {
            this.agentAreaCode = agentAreaCode;
        }

        public String getAgentMobile() {
            return agentMobile;
        }

        public void setAgentMobile(String agentMobile) {
            this.agentMobile = agentMobile;
        }

        public Integer getMarketId() {
            return marketId;
        }

        public void setMarketId(Integer marketId) {
            this.marketId = marketId;
        }

        public Long getMkSign() {
            return mkSign;
        }

        public void setMkSign(Long mkSign) {
            this.mkSign = mkSign;
        }

        public String getMarketName() {
            return marketName;
        }

        public void setMarketName(String marketName) {
            this.marketName = marketName;
        }

        public String getMarketMobile() {
            return marketMobile;
        }

        public void setMarketMobile(String marketMobile) {
            this.marketMobile = marketMobile;
        }

        public String getMarketArea() {
            return marketArea;
        }

        public void setMarketArea(String marketArea) {
            this.marketArea = marketArea;
        }

        public String getMarketAddress() {
            return marketAddress;
        }

        public void setMarketAddress(String marketAddress) {
            this.marketAddress = marketAddress;
        }

        public String getMarketAreaCode() {
            return marketAreaCode;
        }

        public void setMarketAreaCode(String marketAreaCode) {
            this.marketAreaCode = marketAreaCode;
        }
    }
}
