package com.jhscale.test.other;

import com.jhscale.common.ai.ProbablyScore;
import com.jhscale.common.model.device._inner.AIValue;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.module.DAIModel;
import com.jhscale.common.model.device.plu.module.DAIType;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.meter.ai.AIInfo;
import com.jhscale.meter.ai.AILocalFactory;
import com.jhscale.meter.ai.AIRecord;
import com.jhscale.meter.ai.AIResult;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.jhscale.test.other.AI_Distance_Test.*;

public class AITest {

    public static void main(String[] args) {
        // demo();
        // factory();

        tensorflow();
    }

    private static void tensorflow() {
        // 翠山梨
        String csl_1 = "-0.2959862~PLU00000013258@qz,-4.7883463~PLU00000013243@qz,-5.7397656~PLU00000013285@nm,-7.5258217~PLU00000013224@xhs,-8.773092~SG00000000025@TZ,-9.139898~SG00000000010@L,-9.689774~PLU00000013289@pg,-12.5567~PLU00000013299@sz,-14.702263~SC00000000173@SNG,-14.896095~PLU00000013204@qj,-14.96677~PLU00000013131@blb,-15.485282~PLU00000013149@dst,-15.594583~QT00000000073@fs,-15.679901~PLU00000147091@ql,-16.235775~PLU00000013170@jmc,-16.36931~PLU00000013405@yd,-16.493237~PLU00000013180@kg,-16.512047~PLU00000013139@cj,-16.860798~PLU00000013246@zyc,-16.956577~PLU00000013282@mht,-17.251814~PLU00000013167@hg,-17.264923~PLU00000015223@lpt,-17.889128~PLU00000013192@mdm,-17.991615~PLU00000013254@clz,-18.20374~PLU00000013360@zy,-18.342869~PLU00000013273@hlg,-18.343962~PLU00000013173@jd,-18.36251~PLU00000013276@lz,-18.802505~SC00000000014@CT,-19.123764~PLU00000013203@qc,-19.20107~PLU00000013225@xhl,-19.38914~PLU00000013210@sc,-19.591896~PLU00000013187@ls,-19.747473~PLU00000013341@whr,-19.833982~PLU00000020581@wd,-19.94275~PLU00000013179@jxc,-20.116413~PLU00000016706@dy,-20.279078~PLU00000013295@rcg,-20.328125~PLU00000013275@lm,-20.38946~PLU00000013309@xj,-20.476446~PLU00000013274@jz,-20.707516~PLU00000013253@cm,-20.797018~PLU00000013193@mx,-21.09269~PLU00000014967@tg,-21.101622~PLU00000013221@wwc,-21.110146~PLU00000013286@nyg,-21.17768~PLU00000013213@sg,-21.209639~PLU00000013161@hlj,-21.242865~PLU00000027759@xm,-21.632778~PLU00000013165@hc,-21.690657~PLU00000013263@hmg,-21.74492~PLU00000013277@lz,-21.820522~PLU00000013255@cz,-22.208239~PLU00000013138@bc,-22.445097~PLU00000013223@ws,-22.705717~PLU00000013191@md,-22.73367~SG00000000042@ZPT,-23.2225~PLU00000013181@kxc,-23.351728~PLU00000013174@jb,-23.513292~PLU00000013216@st,-23.785877~PLU00000013477@thc,-23.79702~PLU00000013177@jc,-23.822248~PLU00000013281@mg,-23.82577~PLU00000013344@zdg,-23.936968~PLU00000013202@qc,-23.98763~PLU00000013279@ll,-24.027174~PLU00000013159@hxg,-24.127117~PLU00000013335@lp,-24.14056~PLU00000013232@xc,-24.16621~PLU00000013288@pp,-24.182062~PLU00000013207@qk,-24.44057~PLU00000013336@ljr,-24.502611~PLU00000078559@dgy,-24.549452~PLU00000013230@xg,-24.618053~PLU00000807699@xz,-24.823675~PLU00000013171@jc,-25.009565~PLU00000035128@xxym,-25.012068~PLU00000013199@ng,-25.074093~PLU00000013228@xc,-25.17257~PLU00000013151@dd,-25.349188~PLU00000013148@dc,-25.49244~PLU00000013147@dbc,-25.527695~PLU00000013334@jr,-25.53891~PLU00000013346@zed,-25.598528~PLU00000013485@bd,-25.949675~PLU00000013343@zdc,-25.964825~PLU00000013194@mg,-26.121532~PLU00000013220@td,-26.329498~PLU00000013307@xg,-26.467424~PLU00000013462@jy,-26.47832~PLU00000013271@ht,-26.54384~PLU00000013348@zg,-26.556156~PLU00000013226@xlh,-26.859932~PLU00000013178@jh,-27.010855~PLU00000013164@hlb,-27.049023~PLU00000013357@zx,-27.523045~PLU00000016778@jj,-27.648005~SC00000000174@SHQ,-27.68625~PLU00000013184@sj,-27.733686~PLU00000013152@dg,-27.893122~PLU00000013280@ly,-27.927797~PLU00000013163@hs,-28.087955~PLU00000013172@jj,-28.11695~PLU00000013238@ymc,-28.143742~PLU00000013315@yz,-28.231274~QT00000000151@MF,-28.348778~PLU00000013261@fl,-28.784224~PLU00000013353@zt,-29.12875~PLU00000013339@tb,-29.46037~PLU00000013479@zpg,-29.467075~PLU00000013434@hz,-29.680336~PLU00000013185@lo,-29.708433~SC00000000163@SJD,-29.882662~PLU00000013440@hx,-30.016098~PLU00000013342@zby,-30.539371~PLU00000013245@zgl,-30.964682~PLU00000013319@byj,-31.535992~PLU00000013328@xg,-31.649332~PLU00000013352@zs,-31.670895~PLU00000013359@zx,-31.746054~PLU00000013427@my,-32.043636~SC00000000147@YD,-32.449413~PLU00000013480@spg,-32.481056~QT00000000036@NM,-32.93267~PLU00000013241@yt,-32.981182~PLU00000013244@zs,-33.029583~PLU00000013458@dy,-33.144485~PLU00000013236@xbg,-33.531483~PLU00000013345@zd,-33.909016~PLU00000013160@hld,-34.07837~PLU00000013456@cy,-34.403027~PLU00000021817@yjm,-34.50038~PLU00000105968@ds,-35.571983~PLU00000013461@hy,-37.65991~PLU00000032666@xlg,-38.297787~PLU00000013390@jxr,-39.447212~PLU00000013209@sy,-41.06362~PLU00000013469@xhy,-41.135002~PLU00000013384@yz,-42.865917~PLU00000013176@jzg";
        String csl_2 = "1.4651654~PLU00000013258@qz,-5.7051373~SG00000000010@L,-6.000288~PLU00000013243@qz,-6.46955~PLU00000013224@xhs,-8.156136~PLU00000013285@nm,-10.145442~SG00000000025@TZ,-10.174343~PLU00000013289@pg,-14.245797~PLU00000013299@sz,-14.501943~PLU00000013204@qj,-15.863597~PLU00000013149@dst,-16.68358~PLU00000013405@yd,-16.685608~PLU00000013192@mdm,-16.685804~PLU00000013139@cj,-16.818413~PLU00000013282@mht,-17.208708~PLU00000013360@zy,-17.546041~QT00000000073@fs,-17.755175~PLU00000013167@hg,-18.089537~PLU00000013131@blb,-18.242092~PLU00000013276@lz,-18.247257~PLU00000013170@jmc,-18.562233~PLU00000013246@zyc,-18.720032~PLU00000013173@jd,-18.889992~SC00000000173@SNG,-19.022408~PLU00000147091@ql,-19.295395~PLU00000015223@lpt,-19.626945~PLU00000013274@jz,-20.105225~PLU00000013225@xhl,-20.276115~SC00000000014@CT,-20.29509~PLU00000013203@qc,-20.547514~PLU00000013295@rcg,-20.562195~PLU00000013180@kg,-20.600014~PLU00000013273@hlg,-20.714617~PLU00000013286@nyg,-21.679102~PLU00000013309@xj,-21.731672~PLU00000013341@whr,-21.783073~PLU00000013254@clz,-22.095657~PLU00000013187@ls,-22.32947~PLU00000013255@cz,-22.541569~PLU00000078559@dgy,-22.923368~PLU00000013193@mx,-23.12224~PLU00000013210@sc,-23.168587~PLU00000013165@hc,-23.23783~PLU00000013216@st,-23.359089~PLU00000013179@jxc,-23.498919~PLU00000020581@wd,-23.556871~PLU00000013275@lm,-23.635458~PLU00000013138@bc,-23.679197~PLU00000013277@lz,-23.726063~PLU00000027759@xm,-23.858257~PLU00000014967@tg,-24.02346~PLU00000013191@md,-24.05794~PLU00000013253@cm,-24.20159~PLU00000013181@kxc,-24.295341~PLU00000013161@hlj,-24.363245~PLU00000013221@wwc,-24.619553~PLU00000016706@dy,-24.631807~PLU00000013226@xlh,-24.981201~PLU00000013223@ws,-25.038813~PLU00000013263@hmg,-25.149488~PLU00000013281@mg,-25.165176~PLU00000013288@pp,-25.377748~PLU00000013151@dd,-25.484026~PLU00000013336@ljr,-25.523125~PLU00000013213@sg,-25.651443~PLU00000013230@xg,-26.202982~PLU00000013174@jb,-26.27482~PLU00000013228@xc,-26.312801~PLU00000013171@jc,-26.322268~SG00000000042@ZPT,-26.445808~PLU00000013207@qk,-26.471584~PLU00000013279@ll,-26.706472~SC00000000174@SHQ,-26.774454~PLU00000013357@zx,-26.795918~PLU00000013199@ng,-27.019876~PLU00000013271@ht,-27.402214~PLU00000013159@hxg,-27.560793~PLU00000807699@xz,-27.613853~PLU00000013194@mg,-27.635408~PLU00000013335@lp,-27.65006~PLU00000013202@qc,-27.695509~PLU00000013344@zdg,-27.99394~PLU00000013220@td,-28.053047~PLU00000013164@hlb,-28.154404~PLU00000013334@jr,-28.516615~PLU00000035128@xxym,-28.789925~PLU00000013477@thc,-28.912569~PLU00000013177@jc,-28.996084~PLU00000013485@bd,-29.152834~PLU00000013307@xg,-29.2392~PLU00000013147@dbc,-29.286652~PLU00000013346@zed,-29.38789~PLU00000013232@xc,-29.394611~PLU00000013343@zdc,-29.405056~PLU00000013172@jj,-29.670408~PLU00000013152@dg,-29.848982~PLU00000016778@jj,-30.231308~PLU00000013184@sj,-30.310658~PLU00000013280@ly,-30.334852~PLU00000013148@dc,-30.840473~PLU00000013261@fl,-31.429184~SC00000000163@SJD,-31.733746~PLU00000013462@jy,-32.04877~PLU00000013315@yz,-32.22018~PLU00000013163@hs,-32.41885~PLU00000013359@zx,-32.493645~PLU00000013348@zg,-32.645275~QT00000000151@MF,-32.92887~PLU00000013178@jh,-32.948307~PLU00000013185@lo,-33.245495~PLU00000013353@zt,-33.256664~SC00000000147@YD,-33.535534~PLU00000013339@tb,-33.556927~PLU00000013238@ymc,-33.660175~PLU00000013352@zs,-33.766945~PLU00000013245@zgl,-33.923252~PLU00000013244@zs,-34.033173~PLU00000013241@yt,-34.178818~PLU00000013236@xbg,-34.300007~PLU00000013319@byj,-34.486275~PLU00000013427@my,-34.543724~QT00000000036@NM,-35.313557~PLU00000013434@hz,-35.6906~PLU00000013479@zpg,-35.723724~PLU00000013342@zby,-35.76732~PLU00000013440@hx,-35.815742~PLU00000013345@zd,-36.037827~PLU00000021817@yjm,-36.131557~PLU00000013480@spg,-36.849846~PLU00000013160@hld,-37.110977~PLU00000013328@xg,-38.750393~PLU00000013456@cy,-38.843094~PLU00000013458@dy,-40.94589~PLU00000032666@xlg,-41.201664~PLU00000013461@hy,-41.775124~PLU00000105968@ds,-42.875027~PLU00000013390@jxr,-45.07018~PLU00000013209@sy,-45.761314~PLU00000013384@yz,-45.970238~PLU00000013469@xhy,-48.06686~PLU00000013176@jzg";

        // 彩椒
        String cj_1 = "0.23949912~PLU00000013273@hlg,-2.6401076~SC00000000173@SNG,-3.7565527~PLU00000013224@xhs,-4.3302627~PLU00000013276@lz,-6.186353~PLU00000013357@zx,-6.293908~PLU00000013246@zyc,-7.2111926~PLU00000013243@qz,-7.764793~PLU00000013289@pg,-9.011896~PLU00000013161@hlj,-11.881213~PLU00000013348@zg,-13.36283~PLU00000013192@mdm,-13.613619~SG00000000025@TZ,-14.470845~PLU00000013353@zt,-14.783267~PLU00000013336@ljr,-14.865887~PLU00000013139@cj,-15.004161~PLU00000013245@zgl,-15.060724~PLU00000013193@mx,-15.206068~PLU00000013360@zy,-15.316671~SG00000000042@ZPT,-15.57785~PLU00000013177@jc,-16.24157~PLU00000013341@whr,-16.315693~PLU00000013286@nyg,-16.429268~PLU00000013254@clz,-16.785126~PLU00000013359@zx,-16.805868~PLU00000147091@ql,-17.337868~PLU00000013258@qz,-17.462708~SC00000000014@CT,-17.744894~PLU00000013172@jj,-17.968445~PLU00000013346@zed,-17.992485~PLU00000013274@jz,-18.016352~PLU00000013282@mht,-18.267756~PLU00000013204@qj,-18.569117~PLU00000013335@lp,-18.68157~PLU00000013285@nm,-18.799116~PLU00000013307@xg,-18.911068~PLU00000013263@hmg,-18.972752~PLU00000013299@sz,-19.138237~PLU00000013281@mg,-19.241613~PLU00000013253@cm,-19.692566~SG00000000010@L,-20.129114~PLU00000013339@tb,-20.21442~PLU00000013187@ls,-20.33455~PLU00000013344@zdg,-20.794874~PLU00000013275@lm,-20.817732~PLU00000013138@bc,-20.819~PLU00000013228@xc,-20.927443~PLU00000013271@ht,-20.965557~PLU00000013210@sc,-21.113058~PLU00000013334@jr,-21.16494~PLU00000013179@jxc,-21.505503~PLU00000013173@jd,-21.882324~PLU00000013207@qk,-22.17191~PLU00000014967@tg,-22.374838~PLU00000013149@dst,-22.730373~PLU00000013202@qc,-23.162735~PLU00000013477@thc,-23.172485~PLU00000027759@xm,-23.313208~PLU00000013309@xj,-23.643742~PLU00000015223@lpt,-23.660309~PLU00000807699@xz,-23.732119~PLU00000013180@kg,-24.07099~PLU00000013277@lz,-24.377613~PLU00000013480@spg,-24.608002~PLU00000013131@blb,-24.699888~PLU00000013181@kxc,-24.758144~PLU00000013191@md,-24.99795~PLU00000013164@hlb,-25.252132~PLU00000013203@qc,-25.58325~PLU00000013485@bd,-25.900414~PLU00000013405@yd,-25.917067~PLU00000013479@zpg,-26.06998~PLU00000013288@pp,-26.660618~PLU00000013216@st,-26.736414~PLU00000013342@zby,-27.029963~PLU00000013295@rcg,-27.127232~PLU00000013185@lo,-27.166441~PLU00000013226@xlh,-27.207132~PLU00000013352@zs,-27.68664~PLU00000020581@wd,-27.713768~PLU00000013167@hg,-27.806147~PLU00000013223@ws,-27.957436~PLU00000013221@wwc,-28.252588~PLU00000013159@hxg,-28.683447~PLU00000013261@fl,-29.151157~PLU00000013184@sj,-29.280266~PLU00000013199@ng,-29.445244~PLU00000013343@zdc,-29.513039~PLU00000013170@jmc,-29.59686~PLU00000013225@xhl,-29.622856~PLU00000013315@yz,-30.039879~PLU00000013461@hy,-30.12468~PLU00000013160@hld,-30.252762~PLU00000013163@hs,-30.26314~PLU00000013230@xg,-30.278374~PLU00000013279@ll,-30.374153~SC00000000147@YD,-30.511639~PLU00000013328@xg,-30.663328~PLU00000013255@cz,-30.83892~SC00000000163@SJD,-30.921394~SC00000000174@SHQ,-30.960583~PLU00000013238@ymc,-31.263239~PLU00000016778@jj,-31.3131~PLU00000016706@dy,-31.332443~PLU00000013152@dg,-31.337206~PLU00000013174@jb,-31.45377~PLU00000035128@xxym,-31.481182~PLU00000013345@zd,-31.51861~PLU00000013151@dd,-32.14067~PLU00000013213@sg,-32.317963~PLU00000013148@dc,-32.48937~PLU00000013220@td,-32.733135~PLU00000078559@dgy,-33.11814~PLU00000013244@zs,-33.210567~PLU00000013171@jc,-33.330986~PLU00000013232@xc,-34.714355~PLU00000013390@jxr,-34.87686~PLU00000013194@mg,-35.489353~PLU00000013178@jh,-36.606224~PLU00000013147@dbc,-36.79122~QT00000000073@fs,-37.238045~PLU00000013427@my,-37.331944~PLU00000013165@hc,-37.73713~PLU00000013384@yz,-38.76938~PLU00000013241@yt,-39.719505~PLU00000013319@byj,-40.173416~PLU00000013458@dy,-40.769146~PLU00000021817@yjm,-40.87887~PLU00000013440@hx,-41.544804~PLU00000013456@cy,-41.922493~QT00000000151@MF,-43.259007~PLU00000032666@xlg,-44.582718~PLU00000013280@ly,-45.27353~PLU00000105968@ds,-45.653625~QT00000000036@NM,-46.903442~PLU00000013462@jy,-47.16894~PLU00000013434@hz,-48.696285~PLU00000013469@xhy,-50.163208~PLU00000013176@jzg,-50.17265~PLU00000013209@sy,-54.70549~PLU00000013236@xbg";
        String cj_2 = "0.5359134~PLU00000013289@pg,-2.9123297~PLU00000013246@zyc,-4.7285395~PLU00000013273@hlg,-8.508407~PLU00000013224@xhs,-10.289503~PLU00000013243@qz,-10.917103~PLU00000013357@zx,-16.434978~SC00000000173@SNG,-16.582737~SG00000000010@L,-16.812237~PLU00000013276@lz,-17.459358~PLU00000013192@mdm,-17.583084~PLU00000013161@hlj,-17.946016~SG00000000025@TZ,-19.325214~PLU00000013139@cj,-22.090555~PLU00000013348@zg,-22.535969~PLU00000013286@nyg,-22.77588~PLU00000013258@qz,-23.444527~PLU00000013245@zgl,-23.66438~PLU00000013360@zy,-24.8811~PLU00000013193@mx,-25.039438~PLU00000013187@ls,-25.738417~PLU00000013336@ljr,-25.768085~PLU00000013285@nm,-26.6294~PLU00000147091@ql,-26.749193~PLU00000013346@zed,-27.417353~PLU00000013299@sz,-27.46039~PLU00000013281@mg,-28.160635~PLU00000013179@jxc,-28.188938~PLU00000013359@zx,-28.39877~PLU00000013263@hmg,-28.840754~PLU00000014967@tg,-29.354414~PLU00000013173@jd,-29.52481~PLU00000013282@mht,-29.563807~SC00000000014@CT,-30.140833~PLU00000013334@jr,-30.153828~SG00000000042@ZPT,-30.294378~PLU00000013341@whr,-30.553167~PLU00000013353@zt,-30.671732~PLU00000013307@xg,-31.70042~PLU00000013210@sc,-31.921013~PLU00000013254@clz,-32.040646~PLU00000013274@jz,-32.731525~PLU00000013131@blb,-32.733578~PLU00000013172@jj,-32.780834~PLU00000013149@dst,-32.828735~PLU00000013275@lm,-33.3256~PLU00000013271@ht,-33.369835~PLU00000013339@tb,-33.789967~PLU00000013228@xc,-34.045834~PLU00000013204@qj,-34.06002~PLU00000015223@lpt,-34.63222~PLU00000013138@bc,-34.640057~PLU00000013221@wwc,-34.701218~PLU00000013253@cm,-34.719013~PLU00000013177@jc,-35.152832~PLU00000013309@xj,-35.259895~PLU00000013202@qc,-35.962482~PLU00000013335@lp,-36.248264~PLU00000013277@lz,-36.920864~PLU00000013344@zdg,-37.154015~PLU00000027759@xm,-37.325836~PLU00000013180@kg,-37.38382~PLU00000013207@qk,-37.394184~PLU00000013226@xlh,-38.52501~PLU00000013181@kxc,-38.728775~PLU00000013203@qc,-38.82365~PLU00000013477@thc,-38.901443~PLU00000013295@rcg,-39.27453~SC00000000174@SHQ,-39.536827~PLU00000013255@cz,-39.840607~PLU00000013315@yz,-39.86209~PLU00000013216@st,-40.675842~PLU00000807699@xz,-41.345444~PLU00000013480@spg,-41.394264~PLU00000013184@sj,-41.406776~PLU00000020581@wd,-41.543285~PLU00000013191@md,-41.75282~PLU00000013185@lo,-41.968693~PLU00000013167@hg,-42.02408~PLU00000013164@hlb,-42.41721~PLU00000013152@dg,-42.91086~PLU00000013279@ll,-43.32709~PLU00000013485@bd,-43.35728~PLU00000013223@ws,-43.42766~PLU00000013199@ng,-43.63869~PLU00000013288@pp,-43.86687~PLU00000013225@xhl,-43.990044~PLU00000013220@td,-44.242355~SC00000000163@SJD,-44.459404~PLU00000013170@jmc,-44.85102~PLU00000013405@yd,-45.167656~PLU00000013159@hxg,-45.404552~PLU00000013343@zdc,-45.499847~QT00000000073@fs,-45.85024~SC00000000147@YD,-46.679893~PLU00000016706@dy,-46.895287~PLU00000013342@zby,-47.408047~PLU00000013213@sg,-47.63193~PLU00000035128@xxym,-47.656796~PLU00000013174@jb,-47.921535~PLU00000013230@xg,-47.962566~PLU00000013352@zs,-48.28384~PLU00000013244@zs,-48.623592~PLU00000013163@hs,-48.635826~PLU00000013479@zpg,-48.826797~PLU00000013328@xg,-48.85734~PLU00000013461@hy,-49.07293~PLU00000013148@dc,-49.07787~PLU00000013345@zd,-49.13969~PLU00000013160@hld,-50.325916~PLU00000013151@dd,-50.544964~PLU00000013171@jc,-50.677593~PLU00000013261@fl,-51.024254~PLU00000013232@xc,-51.123035~PLU00000013178@jh,-51.833527~PLU00000013194@mg,-51.842644~PLU00000078559@dgy,-51.85539~PLU00000013384@yz,-51.98991~PLU00000013238@ymc,-52.24741~PLU00000013147@dbc,-52.54592~PLU00000013165@hc,-53.76575~PLU00000013390@jxr,-54.913353~PLU00000013241@yt,-55.630836~PLU00000013427@my,-55.737976~PLU00000016778@jj,-58.04541~PLU00000013319@byj,-60.157257~PLU00000013458@dy,-61.220547~PLU00000021817@yjm,-61.330223~QT00000000151@MF,-64.07037~PLU00000013280@ly,-64.08222~PLU00000013456@cy,-65.07497~PLU00000032666@xlg,-65.97831~PLU00000013440@hx,-66.54011~PLU00000013462@jy,-68.38815~QT00000000036@NM,-69.304565~PLU00000013469@xhy,-70.30409~PLU00000105968@ds,-73.03715~PLU00000013434@hz,-74.30213~PLU00000013176@jzg,-75.71981~PLU00000013209@sy,-78.9245~PLU00000013236@xbg";

        float csl_1_csl_2 = compare(extracted(csl_1), aiValues(csl_2), 10);
        System.out.println(String.format("翠山梨_1_翠山梨_2: %s", csl_1_csl_2));

        float csl_1_cj_1 = compare(extracted(csl_1), aiValues(cj_1), 10);
        System.out.println(String.format("翠山梨_1_彩椒_1: %s", csl_1_cj_1));

        float csl_1_cj_2 = compare(extracted(csl_1), aiValues(cj_2), 10);
        System.out.println(String.format("翠山梨_1_彩椒_2: %s", csl_1_cj_2));

        float csl_2_cj_1 = compare(extracted(csl_2), aiValues(cj_1), 10);
        System.out.println(String.format("翠山梨_2_彩椒_1: %s", csl_2_cj_1));

        float csl_2_cj_2 = compare(extracted(csl_2), aiValues(cj_2), 10);
        System.out.println(String.format("翠山梨_2_彩椒_2: %s", csl_2_cj_2));

        float cj_1_cj_2 = compare(extracted(cj_1), aiValues(cj_2), 10);
        System.out.println(String.format("彩椒_1_彩椒_2: %s", cj_1_cj_2));
    }

    /**
     * @description: 转义取样值
     **/
    private static Map<String, Float> extracted(String content) {
        String[] split = content.split(",");
        Map<String, Float> model = new HashMap<>();
        for (String s : split) {
            String[] split1 = s.split("~");
            model.put(split1[1], Float.parseFloat(split1[0]));
        }
        return model;
    }

    /**
     * @description: 转义参照值
     **/
    private static List<AIValue> aiValues(String content) {
        String[] split = content.split(",");
        List<AIValue> values = new ArrayList<>();
        for (String s : split) {
            values.add(new AIValue(s));
        }
        return values;
    }

    private static float compare(Map<String, Float> source, List<AIValue> refer, int size) {
        float[] se = new float[size];
        float[] rf = new float[size];
        for (int i = 0; i < size; i++) {
            if (i >= refer.size()) break;
            AIValue aiValue = refer.get(i);
            rf[i] = aiValue.getValue();
            se[i] = source.get(aiValue.getLabel());
        }
        float v6 = calculate6(se, rf);
        float v7 = calculate7(se, rf);
        float v8 = calculate8(se, rf);
        System.out.println(String.format("V6:[%s], V7:[%s], V8:[%s]", v6, v7, v8));
        return calculate8(se, rf);
    }

    private static void factory() {
        DPLUV5 plu1 = new DPLUV5<>()
                .setNo(1)
                .setAiType(
                        new DAIType()
                                .setType(1)
                                .addModels(new DAIModel("M001", "苹果"))
                );
        DPLUV5 plu2 = new DPLUV5<>()
                .setNo(2)
                .setAiType(
                        new DAIType()
                                .setType(1)
                                .addModels(new DAIModel("M002", "香蕉"))
                );
        DPLUV5 plu3 = new DPLUV5<>()
                .setNo(3)
                .setAiType(
                        new DAIType()
                                .setType(1)
                                .addModels(new DAIModel("M003", "橘子"))
                );


        AILocalFactory.getInstance().add(plu1, plu2, plu3);


        // Map<String, Double> parts1 = new HashMap<String, Double>();
        // parts1.put("abc001", 4.0);
        // parts1.put("abc003", 8.0);
        // parts1.put("abc004", 4.0);
        // parts1.put("abc005", 3.123);

        List<ProbablyScore> scores1 = new ArrayList<>();
        scores1.add(new ProbablyScore(1, 4.0f, "abc001"));
        scores1.add(new ProbablyScore(2, 8.0f, "abc003"));
        scores1.add(new ProbablyScore(3, 4.0f, "abc004"));
        scores1.add(new ProbablyScore(4, 3.123f, "abc005"));

        AIRecord record = AILocalFactory.getInstance().collection(
                new AIRecord()
                        .setPluno(4)
                        .setScores(scores1)
        );
        System.out.println(record.toJSON());

        List<ProbablyScore> scores11 = new ArrayList<>();
        scores11.add(new ProbablyScore(1, 4.0f, "abc001"));
        scores11.add(new ProbablyScore(2, 8.0f, "abc003"));
        scores11.add(new ProbablyScore(3, 4.0f, "abc002"));
        scores11.add(new ProbablyScore(4, 3.123f, "abc006"));
        AIRecord record2 = AILocalFactory.getInstance().collection(
                new AIRecord()
                        .setPluno(4)
                        .setScores(scores11)
        );
        System.out.println(record2.toJSON());

        // Map<String, Double> parts2 = new HashMap<String, Double>();
        // parts2.put("abc003", 9.0);
        // parts2.put("abc004", 3.0);
        // parts2.put("abc005", 5.123);

        List<ProbablyScore> scores2 = new ArrayList<>();
        scores2.add(new ProbablyScore(1, 9.0f, "abc003"));
        scores2.add(new ProbablyScore(2, 3.0f, "abc004"));
        scores2.add(new ProbablyScore(3, 5.123f, "abc005"));

        List<AIResult> identify = AILocalFactory.getInstance().identify(scores2);
        System.out.println(JSONUtils.objectToJSON(identify));
    }

    private static void demo() {
        Map<String, Double> parts1 = new HashMap<String, Double>();
        parts1.put("abc001", 4.0);
        parts1.put("abc003", 8.0);
        parts1.put("abc004", 4.0);
        parts1.put("abc005", 3.123);

        Map<String, Double> parts2 = new HashMap<String, Double>();
        parts2.put("abc003", 9.0);
        parts2.put("abc004", 3.0);
        parts2.put("abc005", 5.123);

        Map<String, Double> parts3 = new HashMap<String, Double>();
        parts3.put("abc003", 8.0);
        parts3.put("abc002", 3.0);
        parts3.put("abc005", 7.123);
        parts3.put("abc004", 2.4);

        AIInfo aiInfo;

        aiInfo = new AIInfo("1#abc001:苹果&abc002:香蕉&abc003=10%abc004=4%abc005=4%");
        String output = aiInfo.GetString();
        System.out.println(output);

        aiInfo.Learn(parts2);
        output = aiInfo.GetString();
        System.out.println(output);

//        aiInfo = new AIInfo("1#abc001:苹果");
//        String output = aiInfo.GetString();
//        System.out.println(output);
//
//        aiInfo.Learn(parts2);
//        output = aiInfo.GetString();
//        System.out.println(output);
//
//        aiInfo.Learn(parts3);
//        output = aiInfo.GetString();
//        System.out.println(output);

        Double result = aiInfo.Check(parts1);
        System.out.println(result);
    }
}
