package com.jhscale.test.other;

import com.jhscale.common.model.device._inner.AIValue;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.meter.utils.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title AI_Distance_Test
 * @description
 * @create 2023/11/29 10:58
 */
public class AI_Distance_Test {

    public static final File one = new File("E:\\JHScale\\Resources", "8010005889700005_猕猴桃_20231129105533_result.csv");

    public static void main(String[] args) throws UnsupportedEncodingException {
        String reader = new String(Objects.requireNonNull(FileUtils.fileToBytes(one)), Charset.forName("gbk"));
        // System.out.println(reader);
        AIResultCollection collection = collection(reader);
        // System.out.println(collection.toJSON());
        calculate(collection);


    }

    /**
     * @description: 计算
     **/
    private static void calculate(AIResultCollection collection) {
        Map<String, AIValue> source_map = Optional.ofNullable(collection.getSource().getValues())
                .orElse(Collections.emptyList())
                .stream().collect(Collectors.toMap(AIValue::getLabel, v -> v));

        int count = 10, expand = 100;
        for (AILabelResult referResult : collection.getRefers()) {
            float[] sources = new float[count];
            float[] refers = new float[count];

            for (int i = 0; i < count; i++) {
                AIValue refer_val = referResult.getValues().get(i);
                sources[i] = refer_val.getValue();
                refers[i] = source_map.get(refer_val.getLabel()).getValue();
            }

            float val = calculate8(sources, refers) * expand;
            System.out.println(String.format("Distance: [%s], File: [%s]", val, referResult.getResult()));
        }
    }

    /***************************************************** 算法内容 ******************************************************************/

    /**
     * @description: 计算距离值
     **/
    public static float calculate6(float[] f1, float[] f2) {
        float sum_min = 0f;
        float sum2 = 0f;
        for (int i = 0; i < f2.length; i++) {
            sum_min += Math.min(f2[i], f1[i]);
            sum2 += f2[i];
        }
        return 1 - sum_min / sum2;
    }

    public static float calculate7(float[] f1, float[] f2) {
        float drift = f2[0] - f2[f2.length - 1];
        float[] df1 = drift(f1, drift);
        float[] df2 = drift(f2, drift);
        float sum_min = 0f;
        float sum_max = 0f;
        for (int i = 0; i < df2.length; i++) {
            sum_min += Math.min(df1[i], df2[i]);
            sum_max += Math.max(df1[i], df2[i]);
        }
        return 1 - sum_min / sum_max;
    }

    /**
     * @description: 偏移
     **/
    private static float[] drift(float[] f, float drift) {
        float min = 0f;
        float max = 0f;
        for (int i = 0; i < f.length; i++) {
            if (i == 0) {
                min = f[0];
                max = f[0];
            } else {
                min = Math.min(min, f[i]);
                max = Math.max(max, f[i]);
            }
        }

        float[] df = new float[f.length];
        for (int i = 0; i < f.length; i++) {
            float v = f[i] - min + drift * 0.1f;
            df[i] = v < 0 ? 0 : v;
        }
        return df;
    }

    public static float calculate8(float[] f1, float[] f2) {
        float[] df1 = drift(f1);
        float[] df2 = drift(f2);
        float sum_min = 0f;
        float sum_max = 0f;
        for (int i = 0; i < df2.length; i++) {
            sum_min += Math.min(df1[i], df2[i]);
            sum_max += Math.max(df1[i], df2[i]);
        }
        return 1 - sum_min / sum_max;
    }

    /**
     * @description: 偏移
     **/
    private static float[] drift(float[] f) {
        float min = 0f;
        float max = 0f;
        for (int i = 0; i < f.length; i++) {
            if (i == 0) {
                min = f[0];
                max = f[0];
            } else {
                min = Math.min(min, f[i]);
                max = Math.max(max, f[i]);
            }
        }

        float drift = max - min;
        float[] df = new float[f.length];
        for (int i = 0; i < f.length; i++) {
            df[i] = f[i] - min + drift * 0.1f;
        }
        return df;
    }

    /***************************************************** 算法内容 ******************************************************************/

    /**
     * @description: CSV 文件解析
     **/
    private static AIResultCollection collection(String reader) {
        String[] contents = reader.split("\n");
        AIResultCollection collection = new AIResultCollection();
        for (int i = 0; i < contents.length; i++) {
            if (i == 0) {
                AILabelResult result = contentToCollection(contents[i]);
                collection.setSource(result);
            } else if (i == 1) {
            } else {
                AILabelResult result = contentToCollection(contents[i]);
                collection.add_refer(result);
            }
        }
        return collection;
    }

    /**
     * @description: content 转 result
     **/
    private static AILabelResult contentToCollection(String content) {
        String[] parts = content.split(",");
        AILabelResult result = new AILabelResult(parts[1], parts[2], Integer.parseInt(parts[0]), Float.parseFloat(parts[3]));
        for (int i = 4; i < parts.length; i = i + 2) {
            result.add_value(new AIValue(parts[i], Float.parseFloat(parts[i + 1])));
        }
        return result;
    }

    /**
     * @description: AI 结果解析数据集
     **/
    public static class AIResultCollection extends JSONModel {

        // 图像识别数据内容
        private AILabelResult source;

        // 参照数据
        private List<AILabelResult> refers;

        public AILabelResult getSource() {
            return source;
        }

        public AIResultCollection setSource(AILabelResult source) {
            this.source = source;
            return this;
        }

        public List<AILabelResult> getRefers() {
            return refers;
        }

        public AIResultCollection setRefers(List<AILabelResult> refers) {
            this.refers = refers;
            return this;
        }

        public AIResultCollection add_refer(AILabelResult... results) {
            if (results != null && results.length > 0) {
                if (this.refers == null) this.refers = new ArrayList<>();
                this.refers.addAll(Arrays.asList(results));
            }
            return this;
        }
    }

    /**
     * @description: AI 结果文件转换信息
     **/
    public static class AILabelResult extends JSONModel {

        // 标签编号AI模型编号
        private String label_name;
        // 标签名称
        private String nick_name;

        // 序号
        private Integer serial;

        // 距离值
        private float result;

        // 特征值
        private List<AIValue> values;

        public AILabelResult() {
        }

        public AILabelResult(String label_name, String nick_name, Integer serial, float result) {
            this.label_name = label_name;
            this.nick_name = nick_name;
            this.serial = serial;
            this.result = result;
        }

        /**
         * @description: 添加特征值
         **/
        public void add_value(AIValue value) {
            if (this.values == null) this.values = new ArrayList<>();
            this.values.add(value);
        }

        public String getLabel_name() {
            return label_name;
        }

        public void setLabel_name(String label_name) {
            this.label_name = label_name;
        }

        public String getNick_name() {
            return nick_name;
        }

        public void setNick_name(String nick_name) {
            this.nick_name = nick_name;
        }

        public Integer getSerial() {
            return serial;
        }

        public void setSerial(Integer serial) {
            this.serial = serial;
        }

        public float getResult() {
            return result;
        }

        public void setResult(float result) {
            this.result = result;
        }

        public List<AIValue> getValues() {
            return values;
        }

        public void setValues(List<AIValue> values) {
            this.values = values;
        }

        /**
         * @description: 输出内容
         **/
        public String content() {
            StringBuilder builder = new StringBuilder(String.format("%s,%s,%s,%s,", Objects.nonNull(this.serial) ? this.serial : "", this.getLabel_name(), this.getNick_name(), this.result));
            if (this.values != null && !this.values.isEmpty()) {
                for (AIValue value : this.values) {
                    builder.append(value.getLabel())
                            .append(",")
                            .append(value.getValue())
                            .append(",");
                }
            }
            return builder.append("\n").toString();
        }

        /**
         * @description: 标签名
         **/
        public String label_str() {
            return StringUtils.isNotBlank(this.label_name) && StringUtils.isNotBlank(this.nick_name) ?
                    String.format("%s_%s", this.label_name, this.nick_name)
                    : DateUtils.getDate_YYMMDD(new Date());
        }
    }
}
