package com.jhscale.test.other;

import com.jhscale.common.model.device.UnitType;
import com.jhscale.meter.em.PayCode;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.tool.barcode.BarCodeFactory;
import com.jhscale.meter.tool.barcode.entity.*;
import com.jhscale.meter.tool.barcode.loader.JKYPayCodeLoader;
import com.jhscale.meter.tool.barcode.loader.PLUSpecsLoader;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: BarcodeTest
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/8/419:29
 */
public class BarcodeTest {
    static PLUSpecsItem pluSpecsItem = new PLUSpecsItem();

    static {
        pluSpecsItem.setNo(45);
        pluSpecsItem.setNumber(149);
        pluSpecsItem.setUnit(UnitType.计重.getVal());
        pluSpecsItem.setPrice(new BigDecimal("3.50"));
    }

    public static void main(String[] args) throws MeterException {
//        payCode();
        String code13 = cashierCodeEAN13A();
        String code18 = cashierCodeEAN18A();

        cashierCodeEAN13(code13);
        cashierCodeEAN18(code18);
    }

    // 20 00045 02000 00700 0
    private static String cashierCodeEAN18A() throws MeterException {
        PLUSpecsItem pluSpecsItem = BarcodeTest.pluSpecsItem.toObject(PLUSpecsItem.class);
        pluSpecsItem.setVal(new BigDecimal("2.00"));
        pluSpecsItem.setItem(new BigDecimal("7.00"));
        String code = BarCodeFactory.getInstance().cashierCodeLoader_18_1(Rule.EAN18("20", 2, null, 1, 2, 2, 3, 1))
                .commodityAssemble(pluSpecsItem);
        System.out.println(code);
        return code;
    }

    // 20 00045 02000 0
    private static String cashierCodeEAN13A() throws MeterException {
        PLUSpecsItem pluSpecsItem = BarcodeTest.pluSpecsItem.toObject(PLUSpecsItem.class);
        pluSpecsItem.setVal(new BigDecimal("2.0"));
        pluSpecsItem.setItem(new BigDecimal("7.0"));
        String code = BarCodeFactory.getInstance().cashierCodeLoader_13_1(Rule.EAN13("20", 2, null, 1, 2, 3, 1))
                .commodityAssemble(pluSpecsItem);
        System.out.println(code);
        return code;
    }

    /**
     * @description: 集中收银条码
     **/
    private static String cashierCodeEAN13(String code) throws MeterException {
        code = StringUtils.isNotBlank(code) ? code : "2000001453001";
        CashierResult commodity = BarCodeFactory.getInstance().cashierCodeLoader_13_1(Rule.EAN13("20", 2, null, 1, 2, 3, 3))
                .commodity(code, new PLUSpecsLoader() {
                    @Override
                    public PLUSpecsParam queryPLUSpecsByNumberOrNoOrConstant(PLUNumberNoConstant request) {
                        return pluSpecsItem;
                    }
                });
        System.out.println(commodity.toJSON());
        return code;
    }

    /**
     * @description: 集中收银条码
     **/
    private static void cashierCodeEAN18(String code) throws MeterException {
        code = StringUtils.isNotBlank(code) ? code : "200000145300045001";
        CashierResult commodity = BarCodeFactory.getInstance().cashierCodeLoader_18_1(Rule.EAN18("20", 2, null, 1, 2, 2, 3, 3))
                .commodity(code, new PLUSpecsLoader() {
                    @Override
                    public PLUSpecsParam queryPLUSpecsByNumberOrNoOrConstant(PLUNumberNoConstant request) {
                        return pluSpecsItem;
                    }
                });
        System.out.println(commodity.toJSON());
    }

    /**
     * @description: 支付码
     **/
    private static void payCode() throws MeterException {
        PayCode payCode = BarCodeFactory.getInstance()
                .build(new JKYPayCodeLoader("88", 24))
                .payCode("");
        System.out.println(payCode);
    }
}
