package com.jhscale.test.other;

import com.jhscale.common.model.device.barcode_format.DBarcodeFormatV2;
import com.jhscale.common.model.device.barcode_format.module.DBarV2;
import com.jhscale.common.model.device.data_parameter.DDataParameterV1;
import com.jhscale.common.model.device.label_format.DLabelFormatV2;
import com.jhscale.common.model.device.label_format.module.DLabelV2;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.text_parameter.DTextParameterV1;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.em.WeighingMode;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.log.JavaLog;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ble_print.BlePrintProtocolManager;
import com.jhscale.meter.protocol.ble_print.em.Action;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.assembly.*;
import com.jhscale.meter.protocol.ble_print.entity.disassembly.ReadLOGBPPDResponse;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.ScannerUtils;

import static com.jhscale.meter.protocol.ble_print.BLEPrintConstant.UP_LOG;

/**
 * @author lie_w
 * @title: Ble_PrintTest
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/5/2711:49
 */
public class Ble_PrintTest {

    private static IProtocolManager protocolManager;

    static {
        JLog.init(new JavaLog());
        GlobalPara.getInstance().setRunLog(true);

        try {
            protocolManager = new BlePrintProtocolManager().initPortmanager(
                    new WSerialPortControl(),
                    new SerialDevice("COM3", 9600, 0),
                    new IProtocolResponse() {
                        /**
                         * @param target
                         * @description: 目标数据
                         */
                        @Override
                        public void target(IPackResponse target) throws MeterException {
                            System.out.println("Default: " + target.toJSON());
                        }

                        @Override
                        public void exp(MeterException e) {
                            System.out.println(e.getMessage());
                        }
                    }
            );
            protocolManager.openPort();

            protocolManager.log(true);
        } catch (MeterException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws MeterException {
        // test1();
        // Set_Weighing_Model();
        // Obtain_MAC();
        // Set_Zero();
        // Set_Peeled_Zero();
        // Obtain_Version();
        // Power_Off();
        // Write_Text();
        // Write_Print_Format();
        // Write_PLU();
        // Write_Bar_Format();
        // Read_Log();
        // Set_Time();
        // Write_Data();
        // send();

        // Read_Response();

        Command_Status();

    }

    private static void Command_Status() throws MeterException {
        CommandStatusBPPARequest request = new CommandStatusBPPARequest();
        request.setAction(Action.Command_Start);
        protocolManager.execute(request, new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Command_Status Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    /**
     * @description: 发送响应
     **/
    private static void Read_Response() throws MeterException {
        Read_Response(BPCMD.Read_Log, 23, 0, 10);
    }

    private static void Read_Response(BPCMD bpcmd, int fid, int status, int length) throws MeterException {
        ReadResponseBPPARequest request = new ReadResponseBPPARequest();
        request.setData(bpcmd);
        request.setFid(fid);
        request.setStatus(status);
        request.setLength(length);
        protocolManager.execute(request, new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.printf("Read_Response Result: %s%n", target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    /**
     * @description: 直接发送
     **/
    private static void send() throws MeterException {
        while (true) {
            String content = ScannerUtils.scanner("\n发送内容");
            protocolManager.execute(ByteUtils.fromHexString(content));
            SystemtUtils.sleep(1);
        }
    }

    private static void Write_Data() throws MeterException {
        WriteDataBPPARequest request = new WriteDataBPPARequest();
        request.add(new DDataParameterV1<>()
                .setNo(1)
                .setValue(50));
        protocolManager.execute(request, new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Write_Data Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Set_Time() throws MeterException {
        SetTimeBPPARequest request = new SetTimeBPPARequest();
        request.setDate(DateUtils.timeStrFormat("2023-06-01 10:00:00"));
        protocolManager.execute(request, new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Set_Time Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Read_Log() throws MeterException {
        ReadLOGBPPARequest request = new ReadLOGBPPARequest();
        request.setAction(UP_LOG);
        request.setFid(5);
        protocolManager.execute(request, new IProtocolResponse<ReadLOGBPPDResponse>() {
            @Override
            public void target(ReadLOGBPPDResponse target) throws MeterException {
                System.out.printf("Read_Log Result: %s%n", target.toJSON());

                Read_Response(request.getBpcmd(), target.lastFid(), 0, target.length());

            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Write_Bar_Format() throws MeterException {
        WriteBarFormatBPPARequest request = new WriteBarFormatBPPARequest();
        request.add(new DBarcodeFormatV2<>()
                .setNo(1)
                .setSplit(" ")
                .add(new DBarV2().setSno(0),
                        new DBarV2().setSno(1),
                        new DBarV2().setSno(2),
                        new DBarV2().setSno(8).setScontent(4)));
        protocolManager.execute(request, new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Write_Bar_Format Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Write_PLU() throws MeterException {
        WritePLUBPPARequest request = new WritePLUBPPARequest();
        request.add(
                new DPLUV5<>().setNo(1).setName("苹果"),
                new DPLUV5<>().setNo(2).setName("香蕉"),
                new DPLUV5<>().setNo(3).setName("橘子"),
                new DPLUV5<>().setNo(4).setName("荔枝"),
                new DPLUV5<>().setNo(5).setName("草莓")
        );
        protocolManager.execute(request, new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Write_PLU Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Write_Print_Format() throws MeterException {
        WriteLabelFormatBPPARequest request = new WriteLabelFormatBPPARequest();
        request.setFormat(new DLabelFormatV2<>()
                .setNo(1)
                .setHeight(50)
                .setWeight(48)
                .add(
                        new DLabelV2().setNo(1).setSign0(0).setX(0).setY(0).setWidth(10).setHeight(4),
                        new DLabelV2().setNo(2).setSign0(6).setSign1(3).setX(0).setY(150).setWidth(10).setHeight(4)
                ));
        protocolManager.execute(request, new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Write_Print_Format Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Write_Text() throws MeterException {
        WriteTextBPPARequest request = new WriteTextBPPARequest();
        request.add(
                new DTextParameterV1<>()
                        .setNo(1)
                        .setValue("上海友声衡器有限公司欢迎您的到来"),
                new DTextParameterV1<>()
                        .setNo(2)
                        .setValue("谢谢惠顾")
        );
        protocolManager.execute(request, new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Write_Text Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Power_Off() throws MeterException {
        protocolManager.execute(new PowerOffBPPARequest(), new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Power_Off Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Obtain_Version() throws MeterException {
        protocolManager.execute(new ObtainVersionBPPARequest(), new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Obtain_Version Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Set_Peeled_Zero() throws MeterException {
        protocolManager.execute(new SetPeeledZeroBPPARequest(), new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Set_Peeled_Zero Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Set_Zero() throws MeterException {
        protocolManager.execute(new SetZeroBPPARequest(), new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Set_Zero Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Obtain_MAC() throws MeterException {
        protocolManager.execute(new ObtainMacBPPARequest(), new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Obtain_MAC Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Set_Weighing_Model() throws MeterException {
        protocolManager.execute(new SetWeighingModelBPPARequest(WeighingMode.Signle_Stable), new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Set_Weighing_Model Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    /**
     * @description: // 上海友声衡器有限公司欢迎您的到来// 谢谢惠顾！
     * 02 2F 33
     * 49 00 C9 CF BA A3 D3 D1 C9 F9 BA E2 C6 F7 D3 D0      BA0
     * CF DE B9 AB CB BE BB B6 D3 AD C4 FA B5 C4 B5 BD      C34
     * C0 B4 00 01 D0 BB D0 BB BB DD B9 CB A3 A1 00         8EB    20BF
     * F2
     * 03
     **/
    private static void test1() throws MeterException {
        String s = ByteUtils.toHexString("上海友声衡器有限公司欢迎您的到来".getBytes());
        System.out.println(s);


        byte[] bytes = ByteUtils.fromHexString(("02 2F 33 49 00 C9 CF BA A3 D3 D1 C9 F9 BA E2 C6 F7 D3 D0 CF DE B9 " +
                "AB CB BE BB B6 D3 AD C4 FA B5 C4 B5 BD C0 B4 00 01 D0 BB D0 BB BB DD B9 CB A3 A1 00 F2 03").replace(" ", ""));
        boolean execute = protocolManager.execute(bytes);
        System.out.println(execute);
    }
}
