package com.jhscale.test.other;

import com.jhscale.common.utils.JSONUtils;
import com.jhscale.meter.call.entity.Request;
import com.jhscale.meter.call.service.impl.BCPort;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.BluetoothPort;
import com.jhscale.meter.io.control.win.WBluetoothControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.DeviceDiscoverEventListener;
import com.jhscale.meter.model.device.BlueDevice;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.utils.ByteUtils;

import java.util.Set;

/**
 * @author lie_w
 * @title: BluetoothTest
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/5/268:35
 */
public class BluetoothTest {

    public static void main(String[] args) throws MeterException {
         setModel();
        mac();
        // parse();

        // bluetooth_found();
        // bluetooth_link();
    }

    /**
     * @description: 蓝牙发现
     **/
    private static void bluetooth_found() throws MeterException {
        BluetoothPort bluetoothPort = new BluetoothPort(new WBluetoothControl(), new DeviceDiscoverEventListener() {
            /**
             * @param device
             * @description: 发现监听事件
             */
            @Override
            public void onDiscoverEvent(Device device) {
                System.out.println("onDiscoverEvent: " + JSONUtils.objectToJSON(device));
            }

            /**
             * @param devicesDiscovered
             * @description: 完成设备查找 返回全部设备列表
             */
            @Override
            public void onDiscoverSuccessEvent(Set devicesDiscovered) {
                System.out.println("onDiscoverSuccessEvent: " + JSONUtils.objectToJSON(devicesDiscovered));
            }

            /**
             * @param e
             * @description: 查找设备异常
             */
            @Override
            public void onDiscoverEventExp(MeterException e) {
                e.printStackTrace();
            }
        });

        bluetoothPort.discovery();

        try {
            Thread.sleep(120000);
        } catch (InterruptedException e) {
        }
    }

    /**
     * @description: 蓝牙 连接
     **/
    private static void bluetooth_link() throws MeterException {
        BluetoothPort bluetoothPort = new BluetoothPort(new WBluetoothControl(),
                new BlueDevice("HC-02", "YS-6A2A"),
                new DeviceClientEventListener() {
                    /**
                     * @param bytes
                     * @description: 连接监听
                     */
                    @Override
                    public void onClientEvent(byte[] bytes) throws MeterException {
                        System.out.println(ByteUtils.toHexString(bytes));
                    }

                    /**
                     * @param e
                     * @description: 连接异常监听
                     */
                    @Override
                    public void onClientEventExp(MeterException e) {

                    }
                });
        bluetoothPort.openPort();
    }

    private static void mac() {
        String cmd = new BCPort(new Request("B", "")).assemble();
        System.out.println(cmd);// 9c9cf73a029f8b
    }

    /**
     * @description: 设置模式
     **/
    private static void setModel() {
        String cmd = new BCPort(new Request("A", "00")).assemble();
        System.out.println(cmd);// 9c9cf73a029f8b
    }

    /**
     * @description: 解析
     **/
    public static void parse() {
        String accept = "9C9CB48129D78B";
        String paese = new BCPort(accept).paese();
        System.out.println(paese);
    }
}
