package com.jhscale.test.other;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.wifi.constant.CMDConstant;
import com.jhscale.meter.wifi.constant.CommandType;
import com.jhscale.meter.wifi.entity.*;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.service.IHexCmd;
import com.jhscale.meter.wifi.service.impl.HexCmd;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: WifiTest
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2019/9/1612:41
 */
public class WifiTest {

    public static void main(String[] args) throws Exception {

//        String base64 = "H4sIAAAAAAAAAE2LQQ6AQAwCvwRdG7dXUP//JLd6UBLCZBKUlTQuJJ5kLH7DucrPjM1Qg8XqVTD+\n" +
//                "H5dgez/rqME2N7+o1nNeAAAA";
//        System.out.println(ByteUtils.toHexString(Base64.decodeBase64(base64)));
//
//        Log log = new Log("832402", base64, "", true);
//        System.out.println(log.toString());

//        parseCommond();
//        parseCommond4();
//        parseCommond3();
//        parseCommond5();

//        getPLUs2();

//        getShortKey();
//        getShortKey2();

//        data();

//        data2();

        parseData();

//        recove();
//        parseRecover();

//        contentPackageCmd();

//        pluParse();

//        cmdValid();
    }

    /**
     * @description: 内容解析
     **/
    private static void parseCommond5() throws MeterException {
        String commond = "02051d002600000023f0148e3ae1bc50ec1054d319e435e1203012000043433030332056332e313345310003";
        byte[] bytes = ByteUtils.fromHexString(commond);

        System.out.println(bytes);
        IHexCmd hexCmd = new HexCmd();
        CommandRequest request = hexCmd.cmdParse(bytes, "");
        System.out.println(JSONObject.toJSONString(request));

//        request.setType(CommandType.DATA);

        if (request.getType().equals(CommandType.DATA)) {
            List<Content> contentList = hexCmd.contentParse(request.getContent(), "");
            System.out.println(JSONObject.toJSONString(contentList));
        }

        request.start().appendHex("00").append(request.getContentLength()).over();
        String response = hexCmd.cmdResponseAssembler(request, "");

        System.out.println(response);

        String response1 = hexCmd.cmdResponseAssembler(request);

        System.out.println(response1);
    }

    private static void cmdValid() throws MeterException {
        List<Content> list = new ArrayList<>();
        Data data = new Data(CMDConstant.SEND, "146");
        data.setValue("0");
        list.add(data);
        String assembler = new HexCmd().assembler(list.toArray(new Content[list.size()]));
        System.out.println(assembler);

        List<Content> contents = new HexCmd().contentParse(assembler, "");
        System.out.println(contents.size());

//        List<Content> contents2 = new HexCmd().contentParse(assembler + "123", "");
//        System.out.println(contents2.size());

        CMD cmd = new HexCmd().assemblerContentCmd("0023F0148E3A", assembler);
        System.out.println(JSON.toJSON(cmd));

        CommandRequest request = new HexCmd().cmdParse(cmd.getSb().toString(), "");
        System.out.println(JSON.toJSON(request));

        CommandRequest request2 = new HexCmd().cmdParse(cmd.getSb().toString() + "343", "");
        System.out.println(JSON.toJSON(request2));
    }

    /**
     * @description: 内容拼装
     **/
    private static void contentPackageCmd() {
        String data = "C51A0E01038011010001000000000015000000530145000100040608";
        IHexCmd hexCmd = new HexCmd();
        CMD cmd = hexCmd.assemblerContentCmd("0023F0148E3A", data);
        System.out.println(JSON.toJSON(cmd));
    }

    /**
     * @description: 解析回收
     **/
    private static void parseRecover() throws MeterException {
//        String data = "c51f0401c6bbb9fb0005401f0000075d0300003332313435343335343300011e02c91c04f401f7d2f7d10001409c000007f401000035353535353500016400c5190432f5f9f5f70001a00f000007320000003535353500016400";
//        String data = "c503080001c503080102c503080214c503080301c503080400c503080501c503080600c50508071f0b20c503080801c503080900c503080a00c503080b00c503080c00c503080d00c503080e00c503080f00c503081000c503081100c503081200c503081300c503081400c503081500c503081607c503081707c503081805c50308190cc503081a10c503081b30c503081c01c503081d00c503081e1ec503081f00c503082000c503082100c503082203c503082301c503082401c503082508c503082614c503082700c503082800c503082905c503082a01c503082b01c503082c1ec503082d01c503082e00c503082f00c50308300ac503083100c503083201c503083302c503083400c503083500c503083600c503083700c503083800c503083900c503083a01c503083b00c503083c01c503083d03c503083e03c503083f03c503084003c503084104c503084200c503084301c503084401c503084502c503084600c503084700c503084800c503084900c503084a00c503084b00c503084c00c503084d00c503084e02c503084f01c503085001c503085101c503085201c503085301c503085400c503085514c503085614c503085700c503085800c503085901c503085a01c503085b00c503085c01c503085d00c503085e00c503085f00c503086000c503086101c503086203c503086303c503086400c503086500c503086600c503086703c503086800c503086900c503086a00c503086b00c503086c00c503086d00c503086e00c503086f00c503087000c503087100c503087200c503087301c503087400c503087500c503087603c503087702c503087803c503087901c503087a00c503087b00c503087c00c503087d00c503087e00c503087f00c503088000c503088100c503088200c503088300c503088400c503088502c503088602c503088700c503088800c503088900c503088a00c503088b00c503088c02c503088d01c503088e01c503088f06c503089000c503089100c503089200c503089300c503089400c503089501c5030896c0c5030897a8c503089800c503089900c503089ac0c503089ba8c503089c01c503089d35c503089ec0c503089fa8c50308a000c50308a101c50308a2ffc50308a3ffc50308a4ffc50308a500c50408a62d83c50408a72e83c50408a82f83c50408a93083c50308aa08c50308ab08c50308ac08c50308ad08c50308ae00c50308af00c50308b000c50308b100c50308b200c50308b300c50308b400c50308b500c50308b600c50308b700c50308b800c50308b900c50308ba00c50308bb00c50308bc06c50308bd07c50308be00c50308bf01c50308c000c50308c100c50308c200c50308c301c50308c403c50308c500c50308c604c50308c700c50308c803c50308c903c50308ca02c50308cb02c50308cc00c50308cd00c50308ce03c50308cf02c50308d003c50308d102c50308d200c50308d300c50308d403c50308d500c50308d600c50308d709c50308d809c50308d904c50308da00c50308db28c50308dc00c50308dd02c50308de02c50308df04c50308e000c50308e105c50308e200c50308e300c50308e400c50308e501c50308e600c50308e700c50308e800c50308e900c50308ea00c50308eb00c50308ec00c50308ed00c50308ee00c50308efc8c50308f030c50308f100c50308f200c50308f301c50308f400c50308f500c50308f600c50308f700c50308f800c50308f900c50308fa00c50308fb00c50308fc00c50308fd00c50308fe00c50308ff00c90408000100c90408010103c90408020103c90408030100c90408040100c90408050100c90408060100c90408070100c90408080100c90408090100c904080a0100c904080b0100c904080c0101c904080d0100c904080e0100c904080f0101c90408100100c90408110101c9060812016b9698c90408130101c90408140100c90408150100c90408160100c90408170100c90408180100c90408190100c904081a0100c904081b0101c904081c0100c904081d0100c904081e0100c904081f0100c90408200100c90408210100c90408220100c90408230100c90408240100c90408250100c90408260100c90408270100c90408280100c90408290100c904082a0102c904082b0100c904082c0100c904082d0100c904082e0100c904082f0100c90408300100c90408310100c90408320100c90408330101c90408340101c90408350100c90408360100c90408370100c90408380100c90408390100c904083a0100c904083b0100c904083c0100c904083d0100c904083e0100c904083f0100c90408400100c90408410100c90408420100c90408430100c90408440100c90408450100c90408460100c90408470100c90408480100c90408490100c904084a0100c904084b0100c904084c0100c904084d0100c904084e0100c904084f0100c90408500100c90408510100c90408520100c90408530100c90408540104c9040855010dc90408560100c90408570100c90408580100c90408590100c904085a0100c904085b0100c904085c0100c904085d0100c904085e0100c904085f0100c90408600100c90408610101c90408620100c90408630100c90408640100c90408650100c90408660101c90408670100c90408680164c90408690101c904086a0101c904086b010ac904086c0100c904086d0100c904086e0100c904086f0100c90408700100c90408710100c90408720100c90408730100c90408740100c90408750100c90408760100c90408770100c9050878013783c9050879013883c905087a013983c905087b013a83c904087c0100c904087d0100c904087e0100c904087f0100c90408800100c90408810100c90408820100c90408830100c90408840100c90408850100c90408860100c90408870100c90408880100c90408890100c904088a0100c904088b0100c904088c0100c904088d0100c904088e0100c904088f0100c90408900100c90408910100c90408920100c90408930100c90408940100c90408950100c90408960100c90408970100c90408980100c90408990100c904089a0100c904089b0100c904089c0100c904089d0100c904089e0100c904089f0101c90408a00101c90408a10108c90408a20114c90408a30100c90408a40100c90408a50100c90408a60101c90408a70100c90408a80100c90408a90100c90408aa0100c90408ab0100c90408ac0100c90408ad0100c90408ae01c0c90408af01a8c90408b00100c90408b10100c90408b201c0c90408b301a8c90408b40100c90408b50101c90408b601ffc90408b701ffc90408b801ffc90408b90100c90408ba0100c90408bb0100c90408bc0100c90408bd0100c90408be0100c90408bf0100c90408c00100c90408c10100c90408c20109c90408c30100c90408c40100c90408c50102c90408c60106c90408c70101c90408c80100c90408c90100c90408ca0100c90408cb0100c90408cc0100c90408cd0100c90408ce0100c90408cf0100c90408d00100c90408d10100c90408d20100c90408d30100c90408d40100c90408d50100c90408d60100c90408d70100c90408d80100c90408d90100c90408da0100c90408db0100c90408dc0100c90408dd0100c90408de0100c90408df0100c90408e00100c90408e10100c90408e20100c90408e30100c90408e40100c90408e50100c90408e60100c90408e70100c90408e80100c90408e90100c90408ea0100c90408eb0100c90408ec0100c90408ed0100c90408ee0100c90408ef0100c90408f00100c90408f10100c90408f20100c90708f301fe01c35a";
//        String data = "c5030a0117c5030a0203c5030a0300c5030a0400c5030a0500c5030a0600c5030a0700c5030a0800c5030a0900c5030a0a00c9040a010100c9040a020100c9040a030100c9040a040100c9040a050100c9040a060100c9040a070100c9040a080100c9040a090100c9040a0a0100c9040a010200c9040a020200c9040a030200c9040a040200c9040a050200c9040a060200c9040a070200c9040a080200c9040a090200c9040a0a0200";
        String data = "c5030a0101c5030a0202c5030a0303c5030a0404c5030a0505c5030a0606c5030a0700c5030a0800c5030a0900c5030a0a00c5030a0b00c5030a0c00c5030a0d00c5030a0e00c5030a0f00c5030a1000c5030a1100c5030a1200c5030a1300c5030a1400c5030a1500c5030a1600c5030a1700c5030a1800c5030a1900c5030a1a00c5030a1b00c5030a1c00c5030a1d00c5030a1e00c5030a1f00c5030a2000c5030a2100c5030a2200c5030a2300c5030a2400c5030a2500c5030a2600c5030a2700c5030a2800c5030a2900c5030a2a00c5030a2b00c5030a2c00c5030a2d00c5030a2e00c5030a2f00c5030a3000c9040a010100c9040a020100c9040a030100c9040a040100c9040a050100c9040a060100c9040a070100c9040a080100c9040a090100c9040a0a0100c9040a0b0100c9040a0c0100c9040a0d0100c9040a0e0100c9040a0f0100c9040a100100c9040a110100c9040a120100c9040a130100c9040a140100c9040a150100c9040a160100c9040a170100c9040a180100c9040a190100c9040a1a0100c9040a1b0100c9040a1c0100c9040a1d0100c9040a1e0100c9040a1f0100c9040a200100c9040a210100c9040a220100c9040a230100c9040a240100c9040a250100c9040a260100c9040a270100c9040a280100c9040a010200c9040a020200c9040a030200c9040a040200c9040a050200c9040a060200c9040a070200c9040a080200c9040a090200c9040a0a0200c9040a0b0200c9040a0c0200c9040a0d0200c9040a0e0200c9040a0f0200c9040a100200c9040a110200c9040a120200c9040a130200c9040a140200c9040a150200c9040a160200c9040a170200c9040a180200c9040a190200c9040a1a0200c9040a1b0200c9040a1c0200c9040a1d0200c9040a1e0200c9040a1f0200c9040a200200c9040a210200c9040a220200c9040a230200c9040a240200c9040a250200c9040a260200c9040a270200c9040a280200";
//        String data = "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";
        CommandRequest request = new HexCmd().cmdParse(data, "");
        List<Content> contents = new HexCmd().contentParse(request.getContent(), "");
        System.out.println(JSONObject.toJSONString(contents));
    }

    /**
     * @description: 解析原始指令
     **/
    private static void parseCommond4() throws MeterException {
        String aeskey = "E1BC50EC4170c48b09c03bc5ebaef9a8c0507e4011e06643";
        String encoding = "";

        String commond1 = "0289ef002bcf527051e271c39ce48a0cf6b714c55d6b0d31fabda1734f150e4147f45d2058eac5ef92f5334cbf9e1770bd09e28336afb803";
        System.out.println(commond1.length());
        byte[] bytes1 = ByteUtils.fromHexString(commond1);
        System.out.println(bytes1.length);

        IHexCmd hexCmd = new HexCmd();
        CommandRequest request = hexCmd.cmdParse(bytes1, aeskey);
        System.out.println(JSONObject.toJSONString(request));

        if (request.getType().equals(CommandType.DATA)) {
            List<Content> contentList = hexCmd.contentParse(request.getContent(), encoding);
            System.out.println(JSONObject.toJSONString(contentList));
        }

        String commond2 = "020e5000e90fc5150401c6bbb9fb000250830e088108200a0000000a00c5190402e9d9d7d3000210000000810a082002000000b8f6000100c5190403";
        System.out.println(commond2.length());
        byte[] bytes2 = ByteUtils.fromHexString(commond2);
        System.out.println(bytes2.length);

        IHexCmd hexCmd2 = new HexCmd();
        CommandRequest request2 = hexCmd2.cmdParse(bytes2, aeskey);
        System.out.println(JSONObject.toJSONString(request2));

        if (request2.getType().equals(CommandType.API)) {
            List<Content> contentList = hexCmd2.contentParse(request.getContent(), encoding);
            System.out.println(JSONObject.toJSONString(contentList));
        }

        request.start().appendHex("00").append(request.getContentLength()).over();
        String response = hexCmd.cmdResponseAssembler(request, aeskey);

        System.out.println(response);

        String response1 = hexCmd.cmdResponseAssembler(request);

        System.out.println(response1);
    }

    /**
     * @description: 解析原始指令
     **/
    private static void parseCommond() throws MeterException {
        String aeskey = "E1BC50EC4170c48b09c03bc5ebaef9a8c0507e4011e06643";
        String encoding = "";

        String commond = "";
//        commond = "020591002600000023f0148e3ae1bc50ec1054d319e435e120760d000043433030332056332e313244380003"; // cmd
        commond = "0289ef002bcf527051e271c39ce48a0cf6b714c55d6b0d31fabda1734f150e4147f45d2058eac5ef92f5334cbf9e1770bd09e28336afb803"; // data
        commond = "0209ef002bc92901820d0a8d8326070000005a0800000001000301000000ca020000620900005a080000c6bbb9fb000003"; // data
        byte[] bytes = ByteUtils.fromHexString(commond);

        System.out.println(bytes);
        IHexCmd hexCmd = new HexCmd();
        CommandRequest request = hexCmd.cmdParse(bytes, aeskey);
        System.out.println(JSONObject.toJSONString(request));

        if (request.getType().equals(CommandType.DATA)) {
            List<Content> contentList = hexCmd.contentParse(request.getContent(), encoding);
            System.out.println(JSONObject.toJSONString(contentList));
        }

        request.start().appendHex("00").append(request.getContentLength()).over();
        String response = hexCmd.cmdResponseAssembler(request, aeskey);

        System.out.println(response);

        String response1 = hexCmd.cmdResponseAssembler(request);

        System.out.println(response1);
    }

    /**
     * @description: 解析原始指令
     **/
    private static void parseCommond3() throws MeterException {
        String aeskey = "";
        String encoding = "";

        String commond = "";
        commond = "020e8a00d002c5030a0101c5030a0202c5030a0303c5030a0404c5030a0505c5030a0606c5030a0700c5030a0800c5030a0900c5030a0a00c5030a0b00c5030a0c00c5030a0d00c5030a0e00c5030a0f00c5030a1000c5030a1100c5030a1200c5030a1300c5030a1400c5030a1500c5030a1600c5030a1700c5030a1800c5030a1900c5030a1a00c5030a1b00c5030a1c00c5030a1d00c5030a1e00c5030a1f00c5030a2000c5030a2100c5030a2200c5030a2300c5030a2400c5030a2500c5030a2600c5030a2700c5030a2800c5030a2900c5030a2a00c5030a2b00c5030a2c00c5030a2d00c5030a2e00c5030a2f00c5030a3000c9040a010100c9040a020100c9040a030100c9040a040100c9040a050100c9040a060100c9040a070100c9040a080100c9040a090100c9040a0a0100c9040a0b0100c9040a0c0100c9040a0d0100c9040a0e0100c9040a0f0100c9040a100100c9040a110100c9040a120100c9040a130100c9040a140100c9040a150100c9040a160100c9040a170100c9040a180100c9040a190100c9040a1a0100c9040a1b0100c9040a1c0100c9040a1d0100c9040a1e0100c9040a1f0100c9040a200100c9040a210100c9040a220100c9040a230100c9040a240100c9040a250100c9040a260100c9040a270100c9040a280100c9040a010200c9040a020200c9040a030200c9040a040200c9040a050200c9040a060200c9040a070200c9040a080200c9040a090200c9040a0a0200c9040a0b0200c9040a0c0200c9040a0d0200c9040a0e0200c9040a0f0200c9040a100200c9040a110200c9040a120200c9040a130200c9040a140200c9040a150200c9040a160200c9040a170200c9040a180200c9040a190200c9040a1a0200c9040a1b0200c9040a1c0200c9040a1d0200c9040a1e0200c9040a1f0200c9040a200200c9040a210200c9040a220200c9040a230200c9040a240200c9040a250200c9040a260200c9040a270200c9040a28020003 "; // data
//        commond = "020d850026C5240401C6BBB9FB000220030000830A0820010000003332313435343335343300B8F600010003"; // data
        byte[] bytes = ByteUtils.fromHexString(commond);

        System.out.println(bytes);
        IHexCmd hexCmd = new HexCmd();
        CommandRequest request = hexCmd.cmdParse(bytes, aeskey);
        System.out.println(JSONObject.toJSONString(request));

        request.setType(CommandType.DATA);

        if (request.getType().equals(CommandType.DATA)) {
            List<Content> contentList = hexCmd.contentParse(request.getContent(), encoding);
            System.out.println(JSONObject.toJSONString(contentList));
        }

        request.start().appendHex("00").append(request.getContentLength()).over();
        String response = hexCmd.cmdResponseAssembler(request, aeskey);

        System.out.println(response);

        String response1 = hexCmd.cmdResponseAssembler(request);

        System.out.println(response1);
    }

    /**
     * @description: 解析原始指令
     **/
    private static void parseCommond2() throws MeterException {
        String aeskey = "E1BC50EC4170c48b09c03bc5ebaef9a8c0507e4011e06643";
        String encoding = "";

        String commond = "";
//        commond = "020591002600000023f0148e3ae1bc50ec1054d319e435e120760d000043433030332056332e313244380003"; // cmd
        commond = "02898f023326e8e3207b711c1498cae1a703f65da3532a824c2dac33df6fde7752861eab0c07a57df9fcb03be4f6e11372a0ca6059c4272b81fa40c6f0f6168399a4f72f3a241303"; // data

        IHexCmd hexCmd = new HexCmd();
        CommandRequest parse = hexCmd.cmdParse(commond, aeskey);
        System.out.println(JSONObject.toJSONString(parse));

        if (parse.getType().equals(CommandType.DATA)) {
            List<Content> contentList = hexCmd.contentParse(parse.contentString(), encoding, false);
            System.out.println(JSONObject.toJSONString(contentList));
        }
    }

    /**
     * @description: PLU解析
     **/
    private static void pluParse() {
//        String data = "c50c040168686800010800000000c50d0402d0a1b4fc00010900000000c509040300010000000000c509040400010000000000c509040500010000000000c509040600010000000000c509040700010000000000c509040800010000000000c509040900010000000000c511040a36a1a237bac5b3c600013000000000c50b040b646400010800000000c50d040cc7dbb2cb00014205000000c50f040dd4b2b0d7b2cb00010204000000c50f040eb4f3b0d7b2cb0001d201000000c50d040fccc6b2cb0001e205000000c50d0410dcedddef0001f204000000c50f0411d3cdc2f3b2cb00017202000000c50f0412cbaebbc6b9cf00014205000000c50f0413c2ccc7d1d7d300010204000000c50d0414c2e9bdb70001a204000000c50f0415bcdcb6b9cdf500016a0a000000c50f0416d7cfb6b9bdc70001b20d000000c50f0417c3e6b6b9bdc70001b212000000c50f0418b0d7d4b2b4d000011a03000000c50f0419d7cfd4b2b4d00001a204000000c50d041accf0bdb700013a06000000c50d041bbce2bdb700012207000000c50f041cd0d3b1abb9bd0001b20d000000c50f041dbdf0d5ebb9bd00015a09000000c50f041ed7cfc7d1d7d30001a204000000c50f041fbab5bbc6b9cf00010901000000c50f0420cddecddeb2cb00021800000000c50d0421bdc7b9cf00011208000000c5110422bac3cef7baeccac100010204000000c5110423bac3bafac2dcb2b70001f204000000c50f0424d0a1b0d7b2cb00013a06000000c50d0425bec2b2cb00013206000000c50f0426b4f3c2edd1be00024000000000c50d0427b2a4b2cb0001e205000000c50f0428d0a1c2edd1be00022800000000c50f0429d0a1d3cdb2cb00016208000000c50d042ac9fab2cb0001c202000000c50d042bbfe0dcc400011208000000c511042cd3d0bbfab2cbbba80001920a000000c50d042db2cbbba80001f204000000c50d042eb6acb9cf00015204000000c50d042fcbe2c3e700019a0f000000c50d0430bfe0b9cf0001ba12000000c50f0431bbc6b6b9c1a300027900000000c50d0432c0adc6a400027900000000c5110433badab0d7beedb7db00020800000000c50d0434babcbdb70001ba12000000c5110435b0d7d3f1c9bdd2a90001ba12000000c50f0436b0d7c2dcb2b700010204000000c50f0437d0c4c0efc3c000013a06000000c5110438b4f3baecc2dcb2b700013201000000c5110439ccfab9f7c9bdd2a90001da15000000c50f043ad4b2b0d7b2cb00011a03000000c50f043bd7cfb8cac0b60001f204000000c50f043cbac3cdc1b6b900010204000000c511043dcdc1baecc2dcb2b700011a03000000c50f043ecef7c0bcbba800017a0c000000c50d043fb4f3cbe20001620d000000c50b0440bdaa00018210000000c50d0441cfe3b2cb00017a0c000000c50f0442bbc6b6b9d1bf00010204000000c50f0443c2ccb6b9d1bf0001f204000000c50d0444cfcac4a20001020e000000c50d0445c4beb6fa00019001000000c50d0446cfe3b9bd00019a0f000000c50d0447cbe2cca60001ba12000000c50d0448d0a1b4d00001f209000000c50d0449b4f3b4d00001f204000000c50d044ab5d8b9cf00013a06000000c50f044bb8c9b6b9b8af0001420a000000c511044cccd8cef7baeccac100011a03000000c50f044dccd8cdc1b6b900011a03000000c50f044ebadacfb8b7db0001920a000000c50f044fb0d7cfb8b7db0001920a000000c50f0450b4d6b0d1b7db00022000000000c50f0451cfb8b0d1b7db00022000000000c50d0452b7dbc6a400017a0c000000c50d0453bfedb7db00016208000000c50f0454d6d0bfedb7db0001920a000000c50d0455bdf0b9cf0001f204000000c50f0456bac9c0bcb6b900010104000000c509045700010000000000c509045800010000000000c509045900010000000000c509045a00010000000000c509045b00010000000000c509045c00010000000000c509045d00010000000000c509045e00010000000000c509045f00010000000000c509046000010000000000c509046100010000000000c509046200010000000000c509046300010000000000c509046400010000000000c509046500010000000000c509046600010000000000c509046700010000000000c509046800010000000000c509046900010000000000c509046a00010000000000c509046b00010000000000c509046c00010000000000c509046d00010000000000c509046e00010000000000c509046f00010000000000c509047000010000000000c510047131bac5b3c6c8e200010000000000c50d0472c5c5b9c70001a000000000c50d0473baf3c7f000014903000000c50d0474c7b0b2db00016903000000c50f0475cfc2cee5bba80001e903000000c50d0476c9cfc4d400011903000000c50d0477d6e2d7d300016903000000c50f0478b4f3b9c7cdb700016903000000c50d0479d1fcc5cc00019903000000c50d047abebbc8e200016800000000c50d047bc5a3c8e20001f000000000c50d047cbeb2c5c500012905000000c509047d00010000000000c509047e00010000000000c509047f00010000000000c50e048032bac5b3c600010000000000c50f0481d6edcaddc8e200028800000000c50f0482d6edcee5bba800029800000000c50f0483d1f2c8e2beed0002d000000000c50d0484d1f2c5c50002e000000000c5110485cef7c3c9b8e1d1f200021801000000c5110486beabc6b7b7cac5a30002e000000000c5110487b4f3c6acb7cac5a300020801000000c50d0488bca6b2e60001c207000000c50d0489bca6cdc80001b212000000c50d048abca6cdb700021000000000c50f048bbca6b4f3d0d80001c216000000c50d048cbca6b8ce00021800000000c50d048dc8abb3e100010104000000c50d048ebca6bcdc00014205000000c50d048fbca6ebd30001a104000000c50f0490b4f3d6d0b3e100013906000000c50f0491c5fdc5c3cdc800014214000000c50d0492bca6b6c70002a902000000c50d0493bca6d7a60001e903000000c50d0494bca6d0c400017a0c000000c50f0495baecd7cfcfba0001110d000000c50d0496d7cfcfba00011801000000c50d0497c7e0cfba00011801000000c50f0498b5b6d3e3b6ce00021103000000c50f0499bbc6bba8d3e300010104000000c50d049abeb8d3e300014105000000c50d049bf6cfd3e30001e105000000c50f049cb4f3bbc6d3e30002c107000000c50d049dd6d0b5b600010104000000c50d049eb4f3b5b60001e105000000c50d049fc7e0d3e30001e20a000000c50d04a0f7a8d3e300010902000000c50904a100010000000000c50904a200010000000000c50d04a3bca6b2b10001d206000000c51104a4b0b2beaed3e3cde800016800000000c50d04a5bca6c6a400020902000000c50f04a6bca6cbe9c8e200010902000000c50f04a7a3b9c3abbcfe00024900000000c50f04a8a3b1d4aabcfe00020800000000c51204a9a3b22ea3b5d4aabcfe0002c900000000c50f04aaa3b3d4aabcfe00021800000000c51204aba3b32ea3b5d4aabcfe00021901000000c50f04aca3b5d4aabcfe00022800000000c50f04ada3b6d4aabcfe00023000000000c51204aea3b62ea3b8d4aabcfe00022102000000c50f04afa3b7d4aabcfe00023800000000c50904b000010000000000c50904b100010000000000c50904b200010000000000c50904b300010000000000c51604b433a1a234a1a235cbaeb9fbb3c600010000000000c50f04b5bce2b0d0c0e600017a0c000000c50f04b6bbcab9dac0e600015a09000000c50f04b7bba8b8c7c0e60001920f000000c50f04b8c4cfb9fbc0e600012211000000c50904b900020000000000c50f04bacef7d6dcc3dc0001ba12000000c50904bb00010000000000c50f04bcb8dfc0d6c3db00010104000000c50f04bdbdf0c3dbb9cf00017a0c000000c50f04beb9fec3dcb9cf0001ba12000000c51104bfc3e5b5e9cef7b9cf00017a0c000000c51104c0f7e8f7ebcef7b9cf00019a0f000000c50d04c1d0a1b7ef00019a0f000000c50d04c2b9b1e9d900017a0c000000c50d04c3bdf0bddb00016a0a000000c50904c400010000000000c50904c500010000000000c50d04c6c1f1c1ab00010109000000c50904c700010000000000c51304c8b0d7d0c4bbf0c1fab9fb0001b212000000c51104c9c9bdb6abb8bbcabf00012102000000c50f04cabbc6d4aacba70001e20a000000c51504cbb4f3d6d8bec5c2e9c0b1cccc00023000000000c50d04ccc6ebb3c80001d101000000c50f04cdccd8bcdbb3c800018101000000c51704ceb4f3bdf0bdb4baecc3b7ceb6beab00025000000000c51304cfbaecd0c4bbf0c1fab9fb0001b103000000c51104d0ccd8bcdbe8d6d7d30001c207000000c51104d1beabc6b7e8d6d7d30001720c000000c51304d2d6d8c7ecd0a1ccecb6ec00026901000000c51104d3baecd0c4e8d6d7d30001920f000000c51104d4b9fab2facfe3bdb60001720c000000c51104d5bdf8bfdacfe3bdb600018101000000c50f04d6b0d9cfe3b9fb00022800000000c50d04d7c4fbc3ca00022800000000c50f04d8cac1b1fdd7d30001c102000000c50f04d9d3f1cec4c3a200013106000000c50d04dacfe3c0e60001f902000000c50f04dbbaa3ced6b5c20001ba12000000c51204dccaaebacd31d0a1cca800013106000000c51704ddcca8cde5baecd0c4bbf0c1fab9fb0001a104000000c50d04dec4beb9cf00017102000000c50f04dfccf0c3e6bdb400021800000000c50d04e0c9dfb9fb0001c102000000c50d04e1bedeb7e500012102000000c50f04e2c9a2b2ddddae00011903000000c50f04e33939b2ddddae00013106000000c50f04e4b4f3d3a3ccd20001c002000000c50f04e5cacde5c8b9fb00015109000000c50f04e6c0b1bdb7cbbf00021901000000c50d04e7c9dfb9fb0001c102000000c50d04e8c9a3d3a100022800000000c50f04e9bac3baeccce100017102000000c51104eabdf8bfdabaeccce100013106000000c51104ebbdf8bfdac2ccb9fb00013106000000c50f04ecbaecb1a6caaf00010104000000c50f04edb0d7c3b5b9e500018101000000c50f04eec5a3d3cdb9fb0002c102000000c50d04efbadacce100016103000000c51104f0bdf8bfdac0b6ddae00029000000000c51104f1bec5bec5b2ddddae00019000000000c50d04f2bdf0bddb00012102000000c50f04f3bac3b9f0d4b000011103000000c51104f4ccd8bcdbb9f0d4b00001b901000000c50d04f5c7a7ecfb0001c102000000c51304f6baeccfe3e5fac6bbb9fb00011103000000c51304f7b0a2bfcbcbd5c6bbb9fb0001b212000000c50f04f8e2a8baefccd200015a09000000c50f04f9b4f3d3a3ccd200018115000000c50d04fac9bdd6f10001e10a000000c51104fbccc7d0c4c6bbb9fb0001b212000000c51104fcbac3c9b0ccc7e9d90001fa18000000c51104fdccd8bcdbc9b0ccc70001ba12000000c50d04fec2abb8cc0001420a000000c51104ffccd8bcdbb3f3e9d90001d101000000c910040001bac3b3f3e9d900011103000000c90e040101b1ace9d900019a0f000000c90a04020100010000000000c90a04030100010000000000c90a04040100010000000000";
        String data = "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";
        List<Content> contents = new HexCmd().parse(data, "", false);
        contents.forEach(content -> {
            System.out.println(JSONObject.toJSONString(content));
        });
    }

    /**
     * @description: 数据参数
     **/
    private static void data() {
        List<Content> list = new ArrayList<>();

        for (int i = 0; i < 52; i++) {
            Data data = new Data(CMDConstant.SEND, i + "");
            data.setValue("0");
            list.add(data);
        }

        CMD cmd = new HexCmd().assembler("0023F0148E3A", list.toArray(new Content[list.size()]));
        System.out.println(JSONObject.toJSONString(cmd));
    }

    /**
     * @description: 数据参数
     **/
    private static void data2() {
        List<Content> list = new ArrayList<>();
        Data data = new Data(CMDConstant.SEND, "146");
        data.setValue("1");
        list.add(data);
        CMD cmd = new HexCmd().assembler("0023F0148E3A", list.toArray(new Content[list.size()]));
        System.out.println(JSONObject.toJSONString(cmd));
    }

    /**
     * @description: 文本参数
     **/
    private static void text() {
        List<Content> list = new ArrayList<>();
        Text text = new Text(CMDConstant.SEND, "0");
        text.setValue("测试名称");
        list.add(text);

        CMD cmd = new HexCmd().assembler("0023F0148E3A", list.toArray(new Content[list.size()]));
        System.out.println(JSONObject.toJSONString(cmd));

        Text text1 = new Text(CMDConstant.SEND, "1");
        text1.setValue("1");
        list.add(text1);

        Text text2 = new Text(CMDConstant.SEND, "2");
        text2.setValue("去");
        list.add(text2);

        Text text3 = new Text(CMDConstant.SEND, "3");
        text3.setValue("1");
        list.add(text3);

        Text text4 = new Text(CMDConstant.SEND, "4");
        text4.setValue("222");
        list.add(text4);

        Text text5 = new Text(CMDConstant.SEND, "5");
        text5.setValue("1");
        list.add(text5);

        Text text6 = new Text(CMDConstant.SEND, "6");
        text6.setValue("我来试试名称");
        list.add(text6);

        Text text7 = new Text(CMDConstant.SEND, "7");
        text7.setValue("1");
        list.add(text7);

        Text text8 = new Text(CMDConstant.SEND, "8");
        text8.setValue("1");
        list.add(text8);

        Text text9 = new Text(CMDConstant.SEND, "9");
        text9.setValue("1");
        list.add(text9);

        Text text10 = new Text(CMDConstant.SEND, "10");
        text10.setValue("1");
        list.add(text10);

        Text text11 = new Text(CMDConstant.SEND, "11");
        text11.setValue("1");
        list.add(text11);

        Text text12 = new Text(CMDConstant.SEND, "12");
        text12.setValue("1");
        list.add(text12);
    }

    /**
     * @description: 回收
     **/
    private static void recove() {
        // 回收PLU
        CMD PLU = new HexCmd().assembler("0023F0148E3A", new PLU(), new Keyboard());
        System.out.println(JSONObject.toJSONString(PLU));
        System.out.println(PLU.getNid());
        System.out.println(PLU.getSb());
        // 回收快捷键
        CMD Keyboard = new HexCmd().assembler("0023F0148E3A", new Keyboard());
        System.out.println(Keyboard.getNid());
        System.out.println(Keyboard.getSb());
        // 回收设备信息
        CMD DefaultContent = new HexCmd().assembler("0023F0148E3A", new DefaultContent());
        System.out.println(DefaultContent.getNid());
        System.out.println(DefaultContent.getSb());

        CMD text = new HexCmd().assembler("0023F0148E3A", new Text());
        System.out.println(JSONObject.toJSONString(text));
        System.out.println(text.getNid());
        System.out.println(text.getSb());

        CMD DATA = new HexCmd().assembler("0023F0148E3A", new Data());
        System.out.println(JSONObject.toJSONString(DATA));
        System.out.println(DATA.getNid());
        System.out.println(DATA.getSb());
    }

    /**
     * @description: 解析数据参数
     **/
    private static void parseData() {
//        Log log = new Log("0001", "ffffffff0000000000000000ff00800218010000002d353032353700", "", false);
//        System.out.println(JSONObject.toJSONString(log));
//        log = new Log("0001", "a64d892407000000000000000000800510010a0000000a000000", "", false);
//        System.out.println(JSONObject.toJSONString(log));
//        log = new Log("0001", "c143892404000000b20400000001800403b2040000b2040000027e96980008000000b2040000b2040000c1d9cab1bcc6cafdbbf5ceef0000", "", false);
//        System.out.println(JSONObject.toJSONString(log));
//        Log log11 = new Log("0001", "H4sIAAAAAAAAAF2MWw7AIAgEr4RLa/WTxXr/I/UhNqYkZMhmlpqQ1XEIZYxVCt5L74WkyEsAWp5s\n" +
//                "0jPJ2kcb0fzsDaWt9H4qG3PY+rOt7StdDfP3BWNDga+oAAAA", "gb2312", true);
//        System.out.println(JSONObject.toJSONString(log11));
//        Log log1 = new Log("0001", "H4sIAAAAAAAAAF2KAQrAMAgDv2SEdvU5GvX/T1jHNgY7CIFLcimgOkTlxuUFawef0aNs2payft+n\niTR6IMhJ74zowaq+thPyj+fnaAAAAA==", "", true);
//        System.out.println(JSONObject.toJSONString(log1));

//        Log log11 = new Log("0001", "H4sIAAAAAAAAAF2QQZLFIAhErwSN0WQJqPc/0lcwk6rJpo3S0Lw5uF4FTY3iU7RO53gTMX83MibJ\n" +
//                "PlxCurWCw8WgZ6v5gHVrWc1KZR8g6XJUxAvS7dLbXzVKyWq6c3g9PV81VfHpao+dNEzpGEZxA/DM\n" +
//                "Ofnvc8hXjVPdhH3rBMekDq6h1MVY7XOsueHoxpJkMtvSKx261l87wJOdyNlh2sIWiVDOrFC3AZdx\n" +
//                "+MyWXETIk4HEywOO/t5X/mrPSYPsXSS3vA9FPWplii+aX5qXv0oSffkPEP/n/wNTYIRKBgIAAA==", "gb2312", true);
//        System.out.println(JSONObject.toJSONString(log11));
//        Log log12 = new Log("9202", "H4sIAAAAAAAAAF2JQQ4AIAjDviQDUY8E8f9PMos3d1jTFOHmitH+aRO++NNSFGmQxVKITm45yFlI\nj2S/VAidA1AAAAA=", "gb2312", true);
//        System.out.println(JSONObject.toJSONString(log12));
        String log = "EAD7642700000000000000000301000201000000080000000A0000000A000000E88BB9E69E9C0000";
        Log log12 = new Log("9202", log, "utf-8", false);
        System.out.println(JSONObject.toJSONString(log12));
        String data = log12.gtDData("utf-8");
        System.out.println(data.equalsIgnoreCase(log));
        System.out.println(log);
        System.out.println(data.toUpperCase());
    }

    /**
     * @description: PLU下发
     **/
    private static void getPLUs2() throws MeterException {
        List<Content> list = new ArrayList<>();
        PLU plu = new PLU(CMDConstant.SEND, "500");
        plu.setName("");
        plu.setWeight("1");
        plu.setPrice("0");
        plu.setNumber("");
        plu.setIndexBar("");
        plu.setText7("");
        plu.setPluSign("0001");
        list.add(plu);
        System.out.println(JSONObject.toJSONString(list));

//        PLU plu2 = new PLU(CMDConstant.SEND, "2");
//        plu2.setName("香蕉");
//        plu2.setWeigth("2");
//        plu2.setPrice("45.2");
//        plu2.setNumber("2");
//        plu2.setIndexBar("321455");
//        plu2.setText7("箱");
//        plu2.setPluSgin("0001");
//        list.add(plu2);
//
//        PLU plu3 = new PLU(CMDConstant.SEND, "3");
//        plu3.setName("芒果");
//        plu3.setWeigth("2");
//        plu3.setPrice("68.25");
//        plu3.setNumber("3");
//        plu3.setIndexBar("42151564");
//        plu3.setText7("笔");
//        plu3.setPluSgin("0001");
//        list.add(plu3);

        CMD cmd = new HexCmd().assembler("0023F0148E3A", list.toArray(new Content[list.size()]));
        System.out.println(cmd.getNid());
        System.out.println(cmd.getSb());

        CommandRequest request = new HexCmd().cmdParse(cmd.getSb().toString(), "");
        List<Content> contents = new HexCmd().contentParse(request.getContent(), "");
        System.out.println(JSONObject.toJSONString(contents));
    }

    /**
     * @description: PLU下发
     **/
    private static void getPLUs() {
        List<Content> list = new ArrayList<>();
        PLU plu = new PLU(CMDConstant.SEND, "1");
        plu.setName("苹果");
        plu.setWeight("5");
        plu.setPrice("1000");
        plu.setNumber("861");
        plu.setIndexBar("3214543543");
        plu.setUseDatePut("1");
        plu.setUseDateData("542");
        list.add(plu);

        PLU plu500 = new PLU(CMDConstant.SEND, "500");
        plu500.setName("饕餮");
        plu500.setWeight("1");
        plu500.setPrice("5000");
        plu500.setNumber("500");
        plu500.setIndexBar("555555");
        plu500.setUseDatePut("1");
        plu500.setUseDateData("100");
        list.add(plu500);

        PLU plu50 = new PLU(CMDConstant.SEND, "50");
        plu50.setName("貔貅");
        plu50.setWeight("1");
        plu50.setPrice("500");
        plu50.setNumber("50");
        plu50.setIndexBar("5555");
        plu50.setUseDatePut("1");
        plu50.setUseDateData("100");
        list.add(plu50);

        CMD cmd = new HexCmd().assembler("0023F0148E3A", list.toArray(new Content[list.size()]));
        System.out.println(cmd.getNid());
        System.out.println(cmd.getSb());
    }

    /**
     * @description: 快捷键
     **/
    private static void getShortKey() {
        List<Content> list = new ArrayList<>();
        Keyboard keyboard = new Keyboard(CMDConstant.SEND, "1");
        keyboard.setValue("2");
        list.add(keyboard);

        CMD cmd = new HexCmd().assembler("0023F0148E3A", list.toArray(new Content[list.size()]));
        System.out.println(cmd.getNid());
        System.out.println(cmd.getSb());
    }

    /**
     * @description: 快捷键
     **/
    private static void getShortKey2() {
        List<Content> list = new ArrayList<>();
        Keyboard keyboard1 = new Keyboard(CMDConstant.SEND, "1");
        keyboard1.setValue("10000024");
        list.add(keyboard1);

        Keyboard keyboard2 = new Keyboard(CMDConstant.SEND, "2");
        keyboard2.setValue("10000027");
        list.add(keyboard2);

        Keyboard keyboard3 = new Keyboard(CMDConstant.SEND, "3");
        keyboard3.setValue("10000045");
        list.add(keyboard3);

        Keyboard keyboard4 = new Keyboard(CMDConstant.SEND, "4");
        keyboard4.setValue("10000025");
        list.add(keyboard4);

        Keyboard keyboard5 = new Keyboard(CMDConstant.SEND, "5");
        keyboard5.setValue("10000045");
        list.add(keyboard5);

        System.out.println(JSON.toJSONString(list));


        CMD cmd = new HexCmd().assembler("0023F0148E3A", list.toArray(new Content[list.size()]));
        System.out.println(cmd.getNid());
        System.out.println(cmd.getSb());
    }
}
